/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.runnables;

import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusCredentialsException;
import fr.obeo.perseus.client.ui.dialogs.PerseusServerCredentialsDialog;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class RetryCredentialsRunnable
implements IRunnableWithProgress {
    private final IRunnableWithProgress delegate;
    private final Shell shell;

    public RetryCredentialsRunnable(IRunnableWithProgress delegate, Shell shell) {
        this.delegate = Objects.requireNonNull(delegate);
        this.shell = Objects.requireNonNull(shell);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int nbRetry = 0;
        boolean retry = true;
        while (retry) {
            try {
                retry = false;
                this.delegate.run((IProgressMonitor)progress.split(50));
            }
            catch (InvocationTargetException e) {
                IPerseusServerConfig config;
                Throwable t = Optional.ofNullable(e.getCause()).orElse(e);
                if (t instanceof PerseusCredentialsException && (config = ((PerseusCredentialsException)t).getPerseusServerConfig()) instanceof PerseusServerConfig && nbRetry++ < 2) {
                    RunnableWithResult.Impl<Integer> runnable = new RunnableWithResult.Impl<Integer>(){

                        public void run() {
                            this.setResult(PerseusServerCredentialsDialog.open(RetryCredentialsRunnable.this.shell, (PerseusServerConfig)config));
                        }
                    };
                    Display.getDefault().syncExec((Runnable)runnable);
                    if ((Integer)runnable.getResult() == 0) {
                        retry = true;
                        progress.setWorkRemaining(100);
                        continue;
                    }
                }
                throw e;
            }
        }
        progress.setWorkRemaining(0);
    }
}

