/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.util;

import fr.obeo.perseus.client.api.PerseusAuthException;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class AuthenticationUtil {
    private AuthenticationUtil() {
    }

    public static void takeUserToAuthenticationPage(final PerseusAuthException authException, final String operationName, Shell shell) {
        final String authorizationURL = authException.getAuthorizationURL();
        MessageDialog.openWarning((Shell)shell, (String)"Additional Authentication required", (String)"To perform the operation, we need to access a server on your behalf.\nYou will be redirected to the server web page where you need to authorize access on your behalf.");
        try {
            final URL url = new URL(authorizationURL);
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
                    }
                    catch (PartInitException e) {
                        PerseusClientUIPlugin.getPlugin().logError(String.format("Operation '%s' failed because user authorization is required but we couldn't automatically redirect the user to the friend server's web page. Please navigate manually to: %s", operationName, authorizationURL), (Throwable)authException);
                    }
                }
            });
        }
        catch (IOException e1) {
            PerseusClientUIPlugin.getPlugin().logError(String.format("Operation '%s' failed because user authorization is required but we couldn't automatically redirect the user to the friend server's web page. Please navigate manually to: %s", operationName, authorizationURL), (Throwable)authException);
        }
    }

    public static String base64UrlEncodeForOAuth2(byte[] bytes) {
        return Base64.getUrlEncoder().encodeToString(bytes).replaceAll("=+$", "");
    }
}

