/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.util;

import fr.obeo.perseus.client.api.IPerseusConfigSupport;
import fr.obeo.perseus.client.ui.preferences.PerseusPreferences;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.util.ModelURI;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PerseusConfigSupport
implements IPerseusConfigSupport {
    private final PerseusPreferences perseusPreferences;

    public PerseusConfigSupport(PerseusPreferences perseusPreferences) {
        this.perseusPreferences = Objects.requireNonNull(perseusPreferences);
    }

    public PerseusConfigSupport() {
        this(new PerseusPreferences());
    }

    public Optional<PerseusServerConfig> findConfigFromModelURI(ModelURI modelURI) {
        List<PerseusServerConfig> serverConfigs = this.perseusPreferences.getServerConfigs();
        for (PerseusServerConfig config : serverConfigs) {
            if (!modelURI.getServerURI().authority().equals(config.getUri().getAuthority()) || !modelURI.getServerURI().scheme().equals(config.getUri().getScheme())) continue;
            return Optional.of(config);
        }
        return Optional.empty();
    }

    public Optional<PerseusServerConfig> findConfig(String serverURI) {
        List<PerseusServerConfig> serverConfigs = this.perseusPreferences.getServerConfigs();
        for (PerseusServerConfig config : serverConfigs) {
            if (!serverURI.equals(config.getUri().toString())) continue;
            return Optional.of(config);
        }
        return Optional.empty();
    }

    public PerseusServerConfig getConfigFromModelURI(ModelURI modelURI) {
        return this.findConfigFromModelURI(modelURI).orElseGet(() -> {
            PerseusServerConfig result = new PerseusServerConfig();
            result.setUri(URI.create(modelURI.getServerURI().toString()));
            return result;
        });
    }
}

