/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.wizards;

import fr.obeo.dsl.traceability.api.IArtifactRepositoryChangeSet;
import fr.obeo.dsl.traceability.api.ISnapshotDiffAction;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.ui.labels.LinkDiffLabelProvider;
import fr.obeo.perseus.client.ui.wizards.LinkDiffContentProvider;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class DisplayRemoteChangesPage
extends WizardPage {
    private final List<? extends IArtifactRepositoryChangeSet> changeModels;
    private final IModelDataProvider modelDataProvider;
    private final ITraceabilityStrategy traceabilityStrategy;
    private final ILabelProvider modelLabelProvider;

    public DisplayRemoteChangesPage(List<? extends IArtifactRepositoryChangeSet> changeModels, ITraceabilityStrategy traceabilityStrategy, IModelDataProvider modelDataProvider, ILabelProvider modelLabelProvider) {
        super("displayRemoteChangesPage");
        this.setTitle("Remote Traceability Changes");
        this.setDescription("The following changes have occurred on the server since the latest synchronization.\r\nYou can decide to apply them all, or reject some of these changes if needed.");
        this.changeModels = Objects.requireNonNull(changeModels);
        this.traceabilityStrategy = Objects.requireNonNull(traceabilityStrategy);
        this.modelDataProvider = Objects.requireNonNull(modelDataProvider);
        this.modelLabelProvider = Objects.requireNonNull(modelLabelProvider);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FillLayout(256));
        Composite composite = new Composite(container, 0);
        composite.setBounds(71, 133, 64, 64);
        TreeColumnLayout tclComposite = new TreeColumnLayout();
        composite.setLayout((Layout)tclComposite);
        this.createTreeViewer(composite, tclComposite);
    }

    private void createTreeViewer(Composite composite, TreeColumnLayout tclComposite) {
        CheckboxTreeViewer treeViewer = new CheckboxTreeViewer(composite, 2048);
        Tree tree = treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeViewerColumn colElement = new TreeViewerColumn((TreeViewer)treeViewer, 0);
        TreeColumn trcolElement = colElement.getColumn();
        tclComposite.setColumnData((Widget)trcolElement, (ColumnLayoutData)new ColumnWeightData(1, 200, true));
        trcolElement.setText("Model Element");
        colElement.setLabelProvider((CellLabelProvider)new LinkDiffLabelProvider(LinkDiffLabelProvider.LinkDiffField.MODEL_OBJECT, this.traceabilityStrategy, this.modelDataProvider, this.modelLabelProvider));
        TreeViewerColumn colLink = new TreeViewerColumn((TreeViewer)treeViewer, 0);
        TreeColumn trcolLink = colLink.getColumn();
        tclComposite.setColumnData((Widget)trcolLink, (ColumnLayoutData)new ColumnPixelData(80, true, true));
        trcolLink.setText("Link Type");
        colLink.setLabelProvider((CellLabelProvider)new LinkDiffLabelProvider(LinkDiffLabelProvider.LinkDiffField.LINK_TYPE, this.traceabilityStrategy, this.modelDataProvider, this.modelLabelProvider));
        TreeViewerColumn colArtifact = new TreeViewerColumn((TreeViewer)treeViewer, 0);
        TreeColumn trcolArtifact = colArtifact.getColumn();
        tclComposite.setColumnData((Widget)trcolArtifact, (ColumnLayoutData)new ColumnWeightData(1, 200, true));
        trcolArtifact.setText("Artifact");
        colArtifact.setLabelProvider((CellLabelProvider)new LinkDiffLabelProvider(LinkDiffLabelProvider.LinkDiffField.ARTIFACT, this.traceabilityStrategy, this.modelDataProvider, this.modelLabelProvider));
        TreeViewerColumn colKind = new TreeViewerColumn((TreeViewer)treeViewer, 0);
        TreeColumn trcolKind = colKind.getColumn();
        tclComposite.setColumnData((Widget)trcolKind, (ColumnLayoutData)new ColumnPixelData(60, true, true));
        trcolKind.setText("Change");
        colKind.setLabelProvider((CellLabelProvider)new LinkDiffLabelProvider(LinkDiffLabelProvider.LinkDiffField.KIND, this.traceabilityStrategy, this.modelDataProvider, this.modelLabelProvider));
        TreeViewerColumn colAction = new TreeViewerColumn((TreeViewer)treeViewer, 0);
        TreeColumn trclmnAction = colAction.getColumn();
        tclComposite.setColumnData((Widget)trclmnAction, (ColumnLayoutData)new ColumnPixelData(60, true, true));
        trclmnAction.setText("Action");
        colAction.setLabelProvider((CellLabelProvider)new LinkDiffLabelProvider(LinkDiffLabelProvider.LinkDiffField.ACTION, this.traceabilityStrategy, this.modelDataProvider, this.modelLabelProvider));
        treeViewer.setContentProvider((IContentProvider)new LinkDiffContentProvider(this.changeModels));
        treeViewer.setInput(this.changeModels);
        treeViewer.expandAll();
        treeViewer.setCheckStateProvider((ICheckStateProvider)new RemoteChangesCheckStateProvider());
        treeViewer.addCheckStateListener((ICheckStateListener)new RemoteChangesCheckStateListener(treeViewer));
    }

    public static final class RemoteChangesCheckStateListener
    implements ICheckStateListener {
        private final CheckboxTreeViewer treeViewer;

        private RemoteChangesCheckStateListener(CheckboxTreeViewer treeViewer) {
            this.treeViewer = treeViewer;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            IArtifactRepositoryChangeSet changeModel;
            List list;
            if (event.getElement() instanceof ISnapshotDiffAction) {
                ((ISnapshotDiffAction)event.getElement()).setAction(event.getChecked() ? ISnapshotDiffAction.DiffAction.ACCEPT : ISnapshotDiffAction.DiffAction.REJECT);
            } else if (event.getElement() instanceof IArtifactRepositoryChangeSet && (list = (changeModel = (IArtifactRepositoryChangeSet)event.getElement()).getDiffActions()) != null) {
                list.forEach(a -> a.setAction(event.getChecked() ? ISnapshotDiffAction.DiffAction.ACCEPT : ISnapshotDiffAction.DiffAction.REJECT));
            }
            this.treeViewer.refresh();
        }
    }

    public static final class RemoteChangesCheckStateProvider
    implements ICheckStateProvider {
        public boolean isGrayed(Object element) {
            if (element instanceof IArtifactRepositoryChangeSet) {
                IArtifactRepositoryChangeSet changeModel = (IArtifactRepositoryChangeSet)element;
                List list = changeModel.getDiffActions();
                return list != null && list.stream().anyMatch(a -> a.getAction() == ISnapshotDiffAction.DiffAction.ACCEPT) && list.stream().anyMatch(a -> a.getAction() == ISnapshotDiffAction.DiffAction.REJECT);
            }
            return false;
        }

        public boolean isChecked(Object element) {
            boolean result = false;
            if (element instanceof ISnapshotDiffAction) {
                result = ((ISnapshotDiffAction)element).getAction() == ISnapshotDiffAction.DiffAction.ACCEPT;
            } else if (element instanceof IArtifactRepositoryChangeSet) {
                IArtifactRepositoryChangeSet changeModel = (IArtifactRepositoryChangeSet)element;
                List list = changeModel.getDiffActions();
                result = list != null && list.stream().allMatch(a -> a.getAction() == ISnapshotDiffAction.DiffAction.ACCEPT);
            }
            return result;
        }
    }
}

