/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.wizards;

import fr.obeo.dsl.traceability.api.IArtifactRepositoryChangeSet;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.wizards.DisplayRemoteChangesPage;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class FetchWizard
extends Wizard {
    private final DisplayRemoteChangesPage displayRemoteChangesPage;
    private final ITraceabilityStrategy traceabilityStrategy;
    private final List<? extends IArtifactRepositoryChangeSet> artifactRepositoryChangeSets;

    public FetchWizard(ITraceabilityStrategy traceabilityStrategy, List<? extends IArtifactRepositoryChangeSet> artifactLinkChangseModels, IModelDataProvider modelDataProvider, AdapterFactory adapterFactory) {
        this.traceabilityStrategy = Objects.requireNonNull(traceabilityStrategy);
        this.artifactRepositoryChangeSets = Objects.requireNonNull(artifactLinkChangseModels);
        this.setWindowTitle("Fetch Traceability Changes");
        this.displayRemoteChangesPage = new DisplayRemoteChangesPage(artifactLinkChangseModels, traceabilityStrategy, modelDataProvider, (ILabelProvider)new AdapterFactoryLabelProvider(adapterFactory));
    }

    public void addPages() {
        this.addPage((IWizardPage)this.displayRemoteChangesPage);
    }

    public boolean performFinish() {
        try {
            this.traceabilityStrategy.applyChanges(this.artifactRepositoryChangeSets, Instant.now());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Update of model failed", (String)e.getMessage());
            PerseusClientUIPlugin.getPlugin().logError("Update of model failed: " + e.getMessage(), e);
        }
        return true;
    }
}

