/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.wizards;

import fr.obeo.perseus.client.api.IPerseusDataFetcher;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.dto.model.ModelDTO;
import fr.obeo.perseus.client.impl.PublishModelData;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.graphql.ProjectAccessLevel;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.wizards.IServerConfigPage;
import fr.obeo.perseus.client.ui.wizards.PublishToPerseusWizard;
import fr.obeo.perseus.client.util.ModelURI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class KnownModelPage
extends WizardPage
implements PropertyChangeListener,
IServerConfigPage {
    private final IPerseusDataFetcher dataFetcher;
    private Text txtDescription;
    private Text txtCommitMessage;
    private Group grpDetails;
    private Group grpCommit;
    private Text txtName;
    private DataBindingContext bindingContext;
    private final PublishModelData selectedModel = new PublishModelData();
    private PerseusServerConfig config;
    private String modelFetchingError;
    private Label lblModelURI;

    public KnownModelPage(IPerseusDataFetcher dataFetcher) {
        super("KnownModelPage");
        this.dataFetcher = Objects.requireNonNull(dataFetcher);
        this.setTitle("Publish Model");
        this.setDescription("Fill in the model information and publication message.");
    }

    public PerseusServerConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(PerseusServerConfig config) {
        this.config = config;
        this.validatePage();
    }

    public PublishModelData getSelectedModel() {
        return this.selectedModel;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createProjectComposite(container);
        this.createDetailsGroup(container);
        this.createCommitGroup(container);
        this.selectedModel.addPropertyChangeListener((PropertyChangeListener)this);
        this.initDataBindings();
        this.validatePage();
    }

    private void createProjectComposite(Composite container) {
        Composite projectComposite = new Composite(container, 0);
        projectComposite.setLayout((Layout)new GridLayout(2, false));
        projectComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label lblModelURILabel = new Label(projectComposite, 0);
        lblModelURILabel.setText("Model URI: ");
        this.lblModelURI = new Label(projectComposite, 0);
        this.lblModelURI.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblModelURI.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
    }

    private void createCommitGroup(Composite container) {
        this.grpCommit = new Group(container, 0);
        this.grpCommit.setLayout((Layout)new GridLayout(2, false));
        this.grpCommit.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.grpCommit.setText("Commit");
        Label lblCommitMessage = new Label((Composite)this.grpCommit, 0);
        lblCommitMessage.setAlignment(131072);
        GridData gdLblCommitMessage = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdLblCommitMessage.widthHint = 100;
        gdLblCommitMessage.minimumWidth = 100;
        lblCommitMessage.setLayoutData((Object)gdLblCommitMessage);
        lblCommitMessage.setText("*Message:");
        this.txtCommitMessage = new Text((Composite)this.grpCommit, 2626);
        GridData gdTxtCommitMessage = new GridData(4, 4, true, true, 1, 1);
        gdTxtCommitMessage.minimumHeight = 80;
        this.txtCommitMessage.setLayoutData((Object)gdTxtCommitMessage);
    }

    private void createDetailsGroup(Composite container) {
        this.grpDetails = new Group(container, 0);
        this.grpDetails.setLayout((Layout)new GridLayout(2, false));
        this.grpDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.grpDetails.setText("Details");
        Label lblName = new Label((Composite)this.grpDetails, 0);
        lblName.setAlignment(131072);
        GridData gdLblName = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdLblName.minimumWidth = 100;
        gdLblName.widthHint = 100;
        lblName.setLayoutData((Object)gdLblName);
        lblName.setText("*Name:");
        this.txtName = new Text((Composite)this.grpDetails, 2048);
        GridData gdTxtName = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtName.minimumWidth = 240;
        this.txtName.setLayoutData((Object)gdTxtName);
        Label lblDescription = new Label((Composite)this.grpDetails, 0);
        lblDescription.setAlignment(131072);
        GridData gdLblDescription = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdLblDescription.minimumWidth = 100;
        gdLblDescription.widthHint = 100;
        lblDescription.setLayoutData((Object)gdLblDescription);
        lblDescription.setText("Description:");
        this.txtDescription = new Text((Composite)this.grpDetails, 2626);
        GridData gdTxtDescription = new GridData(4, 4, true, true, 1, 1);
        gdTxtDescription.minimumHeight = 80;
        this.txtDescription.setLayoutData((Object)gdTxtDescription);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.selectedModel.setName(((PublishToPerseusWizard)this.getWizard()).getSessionProjectName());
            ModelURI modelURI = ((PublishToPerseusWizard)this.getWizard()).getModelURI();
            this.selectedModel.setProjectId(UUID.fromString(modelURI.getProjectId()));
            this.selectedModel.setModelId(Long.valueOf(modelURI.getModelId()));
            this.lblModelURI.setText(modelURI.toString());
            this.fetchModel();
            this.validatePage();
        }
    }

    private void validatePage() {
        this.setMessage(null);
        ArrayList<String> errors = new ArrayList<String>();
        if (this.modelFetchingError != null) {
            errors.add(this.modelFetchingError);
        }
        if (this.getModelDataProvider() == null) {
            errors.add("The selected file is not supported. Close the wizard, select a *.aird file in the workspace and restart the publication.");
        }
        if (this.selectedModel.getName() == null || this.selectedModel.getName().trim().isEmpty()) {
            errors.add("The name is mandatory.");
        }
        if (this.selectedModel.getCommitMessage() == null || this.selectedModel.getCommitMessage().trim().isEmpty()) {
            errors.add("The commit message is mandatory.");
        }
        if (this.selectedModel.getDescription() == null || this.selectedModel.getDescription().trim().isEmpty()) {
            this.setMessage("It is recommended to enter a description for the model to publish.", 2);
        }
        if (errors.isEmpty()) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(errors.stream().collect(Collectors.joining("\n")));
        }
        this.setPageComplete(errors.isEmpty());
    }

    private SessionModelDataProvider getModelDataProvider() {
        return ((PublishToPerseusWizard)this.getWizard()).getModelDataProvider();
    }

    private void fetchModel() {
        Long modelId = this.getSelectedModel().getModelId();
        String projectId = String.valueOf(this.getSelectedModel().getProjectId());
        try {
            this.loadModel(this.getContainer(), projectId, modelId);
            this.modelFetchingError = null;
        }
        catch (InvocationTargetException e) {
            PerseusClientUIPlugin.getPlugin().logError(e.getMessage(), e);
            this.modelFetchingError = e.getCause().getMessage();
        }
        catch (InterruptedException e) {
            PerseusClientUIPlugin.getPlugin().logError(e.getMessage(), e);
            this.modelFetchingError = "Fetch of models or login canceled. Go back or close this wizard.";
        }
    }

    private void loadModel(IWizardContainer container, String projectId, Long modelId) throws InvocationTargetException, InterruptedException {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
        progressDialog.run(true, true, monitor -> {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                try {
                    progress.subTask("Fetching available models from Publication server...");
                    final ModelDTO model = this.dataFetcher.getModel((IPerseusServerConfig)this.getConfig(), projectId, modelId, ProjectAccessLevel.WRITE, (IProgressMonitor)progress.split(80));
                    this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            KnownModelPage.this.getSelectedModel().setDescription(model.getDescription());
                            KnownModelPage.this.getSelectedModel().setName(model.getName());
                        }
                    });
                }
                catch (PerseusServerException | IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                progress.setWorkRemaining(0);
            }
        });
    }

    protected void initDataBindings() {
        this.bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextNameObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtName);
        IObservableValue selectionNameConfigObserveValue = BeanProperties.value((String)"name").observe((Object)this.selectedModel);
        this.bindingContext.bindValue((IObservableValue)observeTextNameObserveWidget, selectionNameConfigObserveValue);
        ISWTObservableValue observeTextCommitMessageObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtCommitMessage);
        IObservableValue selectionCommitMessageConfigObserveValue = BeanProperties.value((String)"commitMessage").observe((Object)this.selectedModel);
        this.bindingContext.bindValue((IObservableValue)observeTextCommitMessageObserveWidget, selectionCommitMessageConfigObserveValue);
        ISWTObservableValue observeTextDescriptionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtDescription);
        IObservableValue selectionDescriptionConfigObserveValue = BeanProperties.value((String)"description").observe((Object)this.selectedModel);
        this.bindingContext.bindValue((IObservableValue)observeTextDescriptionObserveWidget, selectionDescriptionConfigObserveValue);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.validatePage();
    }
}

