/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.wizards;

import fr.obeo.dsl.traceability.Publication;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilityFactory;
import fr.obeo.dsl.traceability.TraceabilitySnapshot;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.api.IModelUpdateDTOFactory;
import fr.obeo.perseus.client.api.IPerseusDataFetcher;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.IPerseusServerModelInput;
import fr.obeo.perseus.client.api.IPerseusServerPublisher;
import fr.obeo.perseus.client.api.IPublicationResultJobRegistry;
import fr.obeo.perseus.client.api.IPublicationSettings;
import fr.obeo.perseus.client.dto.ProjectRefDTO;
import fr.obeo.perseus.client.dto.model.ModelDTO;
import fr.obeo.perseus.client.dto.model.ModelUpdateDTO;
import fr.obeo.perseus.client.impl.PerseusModelPublisher;
import fr.obeo.perseus.client.impl.PublicationSettingsProvider;
import fr.obeo.perseus.client.impl.PublishModelData;
import fr.obeo.perseus.client.impl.PublishModelInput;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.impl.traceability.SessionTraceabilityStrategy;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.preferences.PerseusPreferences;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.util.PerseusConfigSupport;
import fr.obeo.perseus.client.ui.wizards.KnownModelPage;
import fr.obeo.perseus.client.ui.wizards.SelectModelPage;
import fr.obeo.perseus.client.ui.wizards.SelectProjectPage;
import fr.obeo.perseus.client.ui.wizards.SelectServerPage;
import fr.obeo.perseus.client.util.ModelURI;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.SiriusReferenceFinder;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.SiriusReferenceFinderImpl;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class PublishToPerseusWizard
extends Wizard {
    private final Session session;
    private final IPerseusDataFetcher dataFetcher;
    private final IPublicationResultJobRegistry publicationResultJobRegistry;
    private SessionModelDataProvider modelDataProvider;
    private String sessionProjectName;
    private PublishModelInput<ModelDTO> publishModelInput;
    private SelectServerPage selectServerPage;
    private SelectProjectPage selectProjectPage;
    private SelectModelPage selectModelPage;
    private KnownModelPage knownModelPage;
    private IPublicationSettings publicationSettings;
    private List<PerseusServerConfig> serverConfigs;
    private PerseusServerConfig modelConfig;

    public PublishToPerseusWizard(Session session, IPerseusDataFetcher dataFetcher, IPublicationResultJobRegistry publicationResultJobRegistry) {
        this.setWindowTitle(Messages.PublishToPerseusWizard_title);
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
        this.session = Objects.requireNonNull(session);
        this.dataFetcher = Objects.requireNonNull(dataFetcher);
        this.publicationResultJobRegistry = publicationResultJobRegistry;
        ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)session, ITraceabilityStrategy.class);
        PublicationSettingsProvider publicationSettingsProvider = new PublicationSettingsProvider((Traceability)traceabilityStrategy.findTraceability().orElse(null));
        this.publicationSettings = publicationSettingsProvider.getPublicationSettings();
    }

    public void addPages() {
        ModelURI modelURI = this.initServerConfigs();
        this.selectServerPage = new SelectServerPage(this.serverConfigs, modelURI, this.modelConfig, this.publicationSettings);
        this.addPage((IWizardPage)this.selectServerPage);
        this.selectProjectPage = new SelectProjectPage();
        this.addPage((IWizardPage)this.selectProjectPage);
        this.selectModelPage = new SelectModelPage(this.dataFetcher);
        this.addPage((IWizardPage)this.selectModelPage);
        this.knownModelPage = new KnownModelPage(this.dataFetcher);
        this.addPage((IWizardPage)this.knownModelPage);
    }

    private ModelURI initServerConfigs() {
        PerseusPreferences perseusPreferences = new PerseusPreferences();
        PerseusConfigSupport configSupport = new PerseusConfigSupport();
        this.serverConfigs = perseusPreferences.getServerConfigs();
        this.loadSession();
        ModelURI modelURI = this.getModelDataProvider().getPerseusModelURI().orElse(null);
        if (modelURI != null) {
            this.modelConfig = this.serverConfigs.stream().filter(psc -> psc.matches(modelURI)).findFirst().orElseGet(() -> {
                PerseusServerConfig enforcedConfig = configSupport.getConfigFromModelURI(modelURI);
                this.serverConfigs.add(0, enforcedConfig);
                return enforcedConfig;
            });
        }
        return modelURI;
    }

    public ProjectRefDTO getSelectedProject() {
        return this.selectProjectPage.getSelectedProject();
    }

    public ModelURI getModelURI() {
        return this.getModelDataProvider().getPerseusModelURI().orElse(null);
    }

    protected void loadSession() {
        if (this.publishModelInput != null) {
            return;
        }
        URI sessionResourceURI = this.session.getSessionResource().getURI();
        this.sessionProjectName = URI.decode((String)sessionResourceURI.segment(1));
        if (sessionResourceURI.isPlatformResource()) {
            SessionModelTranslationScope translationScope = new SessionModelTranslationScope(this.session);
            this.modelDataProvider = new SessionModelDataProvider(this.session, (IModelTranslationScope)translationScope);
            ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)this.session, ITraceabilityStrategy.class);
            PublicationSettingsProvider publicationSettingsProvider = new PublicationSettingsProvider((Traceability)traceabilityStrategy.findTraceability().orElse(null));
            this.publishModelInput = new PublishModelInput((IModelDataProvider)this.modelDataProvider, traceabilityStrategy, publicationSettingsProvider, (IModelUpdateDTOFactory)new IModelUpdateDTOFactory<ModelDTO>(){

                public ModelUpdateDTO newModelUpdateDTO() {
                    return new ModelUpdateDTO();
                }

                public ModelDTO newModelDTO() {
                    return new ModelDTO();
                }
            });
        } else {
            WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
            page.setErrorMessage(String.format(Messages.PublishToPerseusWizard_InvalidSession, sessionResourceURI));
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        WizardPage result = page == this.selectServerPage ? (this.selectServerPage.isUseKnownModelURI() ? this.knownModelPage : this.selectProjectPage) : (page == this.selectModelPage || page == this.knownModelPage ? null : super.getNextPage(page));
        return result;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        WizardPage result = page == this.selectModelPage ? this.selectProjectPage : (page == this.knownModelPage ? this.selectServerPage : super.getPreviousPage(page));
        return result;
    }

    public boolean canFinish() {
        if (this.selectServerPage.isUseKnownModelURI()) {
            return this.selectServerPage.isPageComplete() && this.knownModelPage.isPageComplete();
        }
        return this.selectServerPage.isPageComplete() && this.selectProjectPage.isPageComplete() && this.selectModelPage.isPageComplete();
    }

    public boolean performFinish() {
        boolean result = false;
        PerseusServerConfig selectedConfig = this.selectServerPage.getSelectedConfig();
        PerseusModelPublisher publisher = new PerseusModelPublisher((IPerseusServerConfig)selectedConfig, PerseusClientPlugin.getPlugin().getHttpSupportFactory());
        try {
            this.getContainer().run(true, true, arg_0 -> this.lambda$2(selectedConfig, (IPerseusServerPublisher)publisher, arg_0));
            result = true;
        }
        catch (InvocationTargetException e) {
            PerseusClientUIPlugin.getPlugin().logError(e.getCause().getMessage(), e.getCause());
            WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
            page.setErrorMessage(e.getCause().getMessage());
        }
        catch (InterruptedException e) {
            PerseusClientUIPlugin.getPlugin().logError(e.getMessage(), e);
            WizardPage page = (WizardPage)this.getContainer().getCurrentPage();
            page.setErrorMessage(e.getMessage());
        }
        return result;
    }

    private void doPublish(PerseusServerConfig selectedConfig, IPerseusServerPublisher publisher, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.publishModelInput != null) {
            PublishModelData modelData;
            IPerseusServerModelInput.ModelOperation modelOp = IPerseusServerModelInput.ModelOperation.UPDATE;
            if (this.selectServerPage.isUseKnownModelURI()) {
                modelData = this.knownModelPage.getSelectedModel();
            } else {
                modelData = this.selectModelPage.getSelectedModel();
                if (modelData.getModelId() == null) {
                    modelOp = IPerseusServerModelInput.ModelOperation.CREATE;
                }
            }
            publisher.addListener((IPerseusServerPublisher.PerseusPublicationListener)new OnModelCreated(this.publishModelInput, selectedConfig, this.modelDataProvider, modelData, (IProgressMonitor)progress));
            publisher.addListener((IPerseusServerPublisher.PerseusPublicationListener)new OnPublishComplete(this.modelDataProvider, this.publishModelInput, selectedConfig, modelData, this.publicationResultJobRegistry, () -> ((PublishToPerseusWizard)this).getShell(), (IProgressMonitor)progress));
            this.publishModelInput.setOperation(modelOp);
            this.publishModelInput.setPublishModelData(modelData);
            if (this.publicationSettings.isPublishSemanticBrowser()) {
                this.publishModelInput.getEnabledTranslationParticipantIDList().add("capella.semantic.browser");
            }
            IStatus status = Status.OK_STATUS;
            boolean needToRestoreReqIFSBEnablement = false;
            try {
                this.freezeSiriusReferenceFinder();
                needToRestoreReqIFSBEnablement = this.enableReqIFSemanticBrowserIfInstalled();
                status = publisher.publish(this.publishModelInput, (IProgressMonitor)progress.setWorkRemaining(100).split(90));
            }
            finally {
                this.unfreezeSiriusReferenceFinder();
                if (needToRestoreReqIFSBEnablement) {
                    this.deactivateReqIFSemanticBrowserIfInstalled();
                }
            }
            if (status.matches(8)) {
                return;
            }
            if (!status.isOK()) {
                String msg;
                PerseusClientUIPlugin.getPlugin().log(status);
                if (status.isMultiStatus()) {
                    StringBuilder sb = new StringBuilder();
                    IStatus[] iStatusArray = status.getChildren();
                    int n = iStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus subStatus = iStatusArray[n2];
                        if (!subStatus.isOK()) {
                            sb.append(subStatus.getMessage()).append("\n");
                        }
                        ++n2;
                    }
                    msg = sb.toString();
                } else {
                    msg = status.getMessage();
                }
                throw new RuntimeException(msg);
            }
        } else {
            throw new RuntimeException(String.format(Messages.PublishToPerseusServerHandler_FailedSession, this.session.getSessionResource().getURI()));
        }
    }

    private boolean enableReqIFSemanticBrowserIfInstalled() {
        boolean needToRestoreReqIFSBEnablement = false;
        Bundle bundle = Platform.getBundle((String)"org.polarsys.capella.vp.requirements.semantic.browser");
        if (bundle != null) {
            try {
                Class queriesStateProviderClass = bundle.loadClass("org.polarsys.capella.vp.requirements.semantic.browser.queries.QueriesStateProvider");
                if (queriesStateProviderClass != null) {
                    Object queriesStateProvider;
                    Boolean enabled;
                    Method getInstanceMethod = queriesStateProviderClass.getMethod("getInstance", new Class[0]);
                    Method areQueriesEnabledMethod = queriesStateProviderClass.getMethod("areQueriesEnabled", new Class[0]);
                    Method updateQueriesEnablementStateMethod = queriesStateProviderClass.getMethod("updateQueriesEnablementState", Boolean.TYPE);
                    if (getInstanceMethod != null && !(enabled = (Boolean)areQueriesEnabledMethod.invoke(queriesStateProvider = getInstanceMethod.invoke(null, new Object[0]), new Object[0])).booleanValue()) {
                        needToRestoreReqIFSBEnablement = true;
                        updateQueriesEnablementStateMethod.invoke(queriesStateProvider, true);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return needToRestoreReqIFSBEnablement;
    }

    private void deactivateReqIFSemanticBrowserIfInstalled() {
        Bundle bundle = Platform.getBundle((String)"org.polarsys.capella.vp.requirements.semantic.browser");
        if (bundle != null) {
            try {
                Class queriesStateProviderClass = bundle.loadClass("org.polarsys.capella.vp.requirements.semantic.browser.queries.QueriesStateProvider");
                if (queriesStateProviderClass != null) {
                    Method getInstanceMethod = queriesStateProviderClass.getMethod("getInstance", new Class[0]);
                    Method updateQueriesEnablementStateMethod = queriesStateProviderClass.getMethod("updateQueriesEnablementState", Boolean.TYPE);
                    if (getInstanceMethod != null) {
                        Object queriesStateProvider = getInstanceMethod.invoke(null, new Object[0]);
                        updateQueriesEnablementStateMethod.invoke(queriesStateProvider, false);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected SessionModelDataProvider getModelDataProvider() {
        return this.modelDataProvider;
    }

    protected PublishModelInput<ModelDTO> getPublishModelInput() {
        return this.publishModelInput;
    }

    protected String getSessionProjectName() {
        return this.sessionProjectName;
    }

    private void freezeSiriusReferenceFinder() {
        DAnalysisSessionImpl dAnalysisSession = (DAnalysisSessionImpl)this.session;
        this.setSiriusReferenceFinder(dAnalysisSession, (SiriusReferenceFinder)new FrozenSiriusReferenceFinder(dAnalysisSession));
    }

    private void unfreezeSiriusReferenceFinder() {
        DAnalysisSessionImpl dAnalysisSession = (DAnalysisSessionImpl)this.session;
        this.setSiriusReferenceFinder(dAnalysisSession, null);
    }

    private void setSiriusReferenceFinder(DAnalysisSessionImpl dAnalysisSession, SiriusReferenceFinder siriusReferenceFinder) {
        try {
            Field field = DAnalysisSessionImpl.class.getDeclaredField("siriusReferenceFinder");
            field.setAccessible(true);
            field.set(dAnalysisSession, siriusReferenceFinder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ void lambda$2(PerseusServerConfig perseusServerConfig, IPerseusServerPublisher iPerseusServerPublisher, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.doPublish(perseusServerConfig, iPerseusServerPublisher, monitor);
    }

    private static abstract class AbstractPublicationListener
    implements IPerseusServerPublisher.PerseusPublicationListener {
        protected final PublishModelInput<ModelDTO> publishModelInput;
        protected final SessionModelDataProvider modelDataProvider;
        protected final IProgressMonitor monitor;

        protected AbstractPublicationListener(PublishModelInput<ModelDTO> publishModelInput, SessionModelDataProvider modelDataProvider, IProgressMonitor monitor) {
            this.publishModelInput = Objects.requireNonNull(publishModelInput);
            this.modelDataProvider = Objects.requireNonNull(modelDataProvider);
            this.monitor = monitor;
        }

        protected void storeModelURI(PerseusServerConfig selectedConfig, PublishModelData modelData, long modelId, IProgressMonitor aMonitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)aMonitor, (int)100);
            ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)this.getSession(), ITraceabilityStrategy.class);
            traceabilityStrategy.findTraceability().orElseGet(() -> {
                try {
                    return traceabilityStrategy.createTraceability((IProgressMonitor)progress.split(100));
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            });
            ModelURI modelURI = ModelURI.of((URI)URI.createURI((String)selectedConfig.getUri().toString()), (UUID)modelData.getProjectId(), (long)modelId);
            this.modelDataProvider.storePerseusModelURI(modelURI);
        }

        protected Session getSession() {
            return this.modelDataProvider.getSession();
        }
    }

    private class FrozenSiriusReferenceFinder
    extends SiriusReferenceFinderImpl {
        FrozenSiriusReferenceFinder(DAnalysisSessionImpl dAnalysisSessionImpl) {
            super(dAnalysisSessionImpl);
            DialectManager.INSTANCE.getAllRepresentationDescriptors((Session)dAnalysisSessionImpl).stream().forEach(repDesc -> {
                DRepresentation dRepresentation = repDesc.getRepresentation();
            });
        }

        public Map<EObject, Collection<EObject>> getReferencingSiriusElements(Collection<EObject> semanticObjects, SiriusReferenceFinder.SearchScope searchScope) {
            return super.getReferencingSiriusElements(semanticObjects, null);
        }
    }

    private static final class OnModelCreated
    extends AbstractPublicationListener {
        private final PerseusServerConfig selectedConfig;
        private final PublishModelData modelData;

        private OnModelCreated(PublishModelInput<ModelDTO> publishModelInput, PerseusServerConfig selectedConfig, SessionModelDataProvider modelDataProvider, PublishModelData modelData, IProgressMonitor monitor) {
            super(publishModelInput, modelDataProvider, monitor);
            this.selectedConfig = Objects.requireNonNull(selectedConfig);
            this.modelData = Objects.requireNonNull(modelData);
        }

        public void onPublishEvent(IPerseusServerPublisher.PublishEvent evt) {
            if (evt instanceof IPerseusServerPublisher.PublishModelCreatedEvent) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)this.monitor, (int)100);
                this.storeModelURI(this.selectedConfig, this.modelData, evt.getTargetModelID(), (IProgressMonitor)progress.split(100));
                PublishModelData updatedPMDWithModelID = new PublishModelData();
                updatedPMDWithModelID.setModelId(Long.valueOf(evt.getTargetModelID()));
                updatedPMDWithModelID.setProjectId(this.modelData.getProjectId());
                updatedPMDWithModelID.setName(this.modelData.getName());
                updatedPMDWithModelID.setCommitMessage(this.modelData.getCommitMessage());
                updatedPMDWithModelID.setDescription(this.modelData.getDescription());
                this.publishModelInput.setPublishModelData(updatedPMDWithModelID);
            }
        }
    }

    private static final class OnPublishComplete
    extends AbstractPublicationListener {
        private final PerseusServerConfig selectedConfig;
        private final PublishModelData modelData;
        private final IPublicationResultJobRegistry publicationResultJobRegistry;
        private final Supplier<Shell> shellSupplier;

        private OnPublishComplete(SessionModelDataProvider modelDataProvider, PublishModelInput<ModelDTO> publishModelInput, PerseusServerConfig selectedConfig, PublishModelData modelData, IPublicationResultJobRegistry publicationResultJobRegistry, Supplier<Shell> shellSupplier, IProgressMonitor monitor) {
            super(publishModelInput, modelDataProvider, monitor);
            this.selectedConfig = Objects.requireNonNull(selectedConfig);
            this.modelData = Objects.requireNonNull(modelData);
            this.publicationResultJobRegistry = Objects.requireNonNull(publicationResultJobRegistry);
            this.shellSupplier = Objects.requireNonNull(shellSupplier);
        }

        public void onPublishEvent(IPerseusServerPublisher.PublishEvent evt) {
            if (evt instanceof IPerseusServerPublisher.PublishCompleteEvent) {
                final SubMonitor progress = SubMonitor.convert((IProgressMonitor)this.monitor, (int)3);
                final IPerseusServerPublisher.PublishCompleteEvent publishCompleteEvent = (IPerseusServerPublisher.PublishCompleteEvent)evt;
                this.storeModelURI(this.selectedConfig, this.modelData, evt.getTargetModelID(), (IProgressMonitor)progress.split(1));
                final Instant instantOfPublish = Instant.now();
                this.getSession().getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getSession().getTransactionalEditingDomain()){

                    protected void doExecute() {
                        this.createPublication(publishCompleteEvent.getPublicationJobId(), instantOfPublish, (IProgressMonitor)progress.split(1));
                    }
                });
                this.getSession().save((IProgressMonitor)progress.split(1));
                String publicationJobId = publishCompleteEvent.getPublicationJobId();
                this.publicationResultJobRegistry.trySchedulingPublicationResultJob(this.modelDataProvider.getSession(), (IPerseusServerConfig)this.selectedConfig, this.modelData.getName(), publicationJobId, this.shellSupplier.get());
            }
        }

        private void createPublication(String jobId, Instant instantOfPublish, IProgressMonitor monitor) {
            ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)this.getSession(), ITraceabilityStrategy.class);
            Traceability traceability = traceabilityStrategy.findTraceability().orElseGet(() -> {
                try {
                    return traceabilityStrategy.createTraceability(monitor);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            });
            Publication publication = TraceabilityFactory.eINSTANCE.createPublication();
            publication.setJobId(jobId);
            publication.setName(String.format("Publication at %s", instantOfPublish));
            traceability.getRepositories().stream().filter(SessionTraceabilityStrategy::isValid).forEach(repo -> {
                TraceabilitySnapshot traceabilitySnapshot = Optional.ofNullable((TraceabilitySnapshot)this.publishModelInput.getNewSnapshotsByRepositoryUrl().get(repo.getUrl().toString())).orElseGet(() -> traceabilityStrategy.getRepositoryStrategy(repo.getUrl()).computeSnapshot());
                repo.getSnapshots().add((Object)traceabilitySnapshot);
                publication.getTraceabilitySnapshots().add((Object)traceabilitySnapshot);
            });
            traceability.setPendingPublication(publication);
        }
    }
}

