/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.wizards;

import fr.obeo.perseus.client.api.IPerseusDataFetcher;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.dto.ProjectRefDTO;
import fr.obeo.perseus.client.dto.model.AbstractModelObject;
import fr.obeo.perseus.client.dto.model.ModelDTO;
import fr.obeo.perseus.client.impl.PublishModelData;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.labels.ModelLabelProvider;
import fr.obeo.perseus.client.ui.labels.ModelSimilarityLabelProvider;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.wizards.IServerConfigPage;
import fr.obeo.perseus.client.ui.wizards.PublishToPerseusWizard;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SelectModelPage
extends WizardPage
implements PropertyChangeListener,
IServerConfigPage {
    private final IPerseusDataFetcher dataFetcher;
    private Table table;
    private Text txtDescription;
    private Text txtCommitMessage;
    private Button btnUpdateExisting;
    private Button btnPublishNew;
    private TableViewer tableViewer;
    private Group grpDetails;
    private Group grpCommit;
    private Text txtName;
    private DataBindingContext bindingContext;
    private final PublishModelData publishAsNewModelData = new PublishModelData();
    private final PublishModelData selectedModelData = new PublishModelData();
    private final PublishModelData modelDataToPublish = new PublishModelData();
    private PerseusServerConfig config;
    private ModelDTOMatcher modelMatcher;
    private TableViewerColumn tvColSimilar;
    private Label lblProjectName;

    public SelectModelPage(IPerseusDataFetcher dataFetcher) {
        super("SelectModelPage");
        this.dataFetcher = Objects.requireNonNull(dataFetcher);
        this.setTitle("Select Model");
        this.setDescription("Decide whether you want to update an existing model or publish a new one");
    }

    public PerseusServerConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(PerseusServerConfig config) {
        this.config = config;
        this.validatePage();
    }

    public PublishModelData getSelectedModel() {
        return this.modelDataToPublish;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.modelMatcher = new ModelDTOMatcher(this.getModelDataProvider().getRootUids());
            this.tvColSimilar.setLabelProvider((CellLabelProvider)new ModelSimilarityLabelProvider(this.modelMatcher::similar));
            this.modelDataToPublish.setProjectId(this.getSelectedProject().getId());
            this.getContainer().getShell().getDisplay().asyncExec(() -> {
                this.initPublishAsNewModelData();
                this.fetchExistingModels();
                this.updateTableEnablement();
                this.validatePage();
            });
        } else {
            this.setPageComplete(false);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createProjectComposite(container);
        this.createNewOrUpdateBtnContainer(container);
        this.createTableViewer(container);
        this.createDetailsGroup(container);
        this.createCommitGroup(container);
        this.modelDataToPublish.addPropertyChangeListener((PropertyChangeListener)this);
        this.initDataBindings();
        this.validatePage();
    }

    private void createProjectComposite(Composite container) {
        Composite projectComposite = new Composite(container, 0);
        projectComposite.setLayout((Layout)new GridLayout(2, false));
        projectComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label projectLabel = new Label(projectComposite, 0);
        projectLabel.setText("Selected project : ");
        this.lblProjectName = new Label(projectComposite, 0);
        this.lblProjectName.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.lblProjectName.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
    }

    private void createNewOrUpdateBtnContainer(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.btnPublishNew = new Button(composite, 16);
        this.btnPublishNew.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnPublishNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectModelPage.this.btnPublishNew.getSelection()) {
                    SelectModelPage.this.updateForAdd();
                    SelectModelPage.this.validatePage();
                }
            }
        });
        this.btnPublishNew.setSelection(true);
        this.btnPublishNew.setText("Publish new model");
        this.btnUpdateExisting = new Button(composite, 16);
        this.btnUpdateExisting.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnUpdateExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectModelPage.this.btnUpdateExisting.getSelection()) {
                    SelectModelPage.this.publishAsNewModelData.setName(SelectModelPage.this.modelDataToPublish.getName());
                    SelectModelPage.this.publishAsNewModelData.setDescription(SelectModelPage.this.modelDataToPublish.getDescription());
                    SelectModelPage.this.updateForUpdate();
                    SelectModelPage.this.validatePage();
                }
            }
        });
        this.btnUpdateExisting.setSelection(false);
        this.btnUpdateExisting.setText("Update existing model (migration from older version)");
    }

    private void createTableViewer(Composite container) {
        this.tableViewer = new TableViewer(container, 67584);
        this.table = this.tableViewer.getTable();
        this.table.setEnabled(false);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gdTable = new GridData(4, 4, true, false, 1, 1);
        gdTable.minimumHeight = 100;
        gdTable.heightHint = 100;
        this.table.setLayoutData((Object)gdTable);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn tvColModelId = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnId = tvColModelId.getColumn();
        tblclmnId.setWidth(50);
        tblclmnId.setText("Id");
        tvColModelId.setLabelProvider((CellLabelProvider)new ModelLabelProvider(ModelLabelProvider.ModelField.ID));
        TableViewerColumn tvColName = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnName = tvColName.getColumn();
        tblclmnName.setWidth(200);
        tblclmnName.setText("Name");
        tvColName.setLabelProvider((CellLabelProvider)new ModelLabelProvider(ModelLabelProvider.ModelField.NAME));
        this.tvColSimilar = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnSimilar = this.tvColSimilar.getColumn();
        tblclmnSimilar.setWidth(57);
        tblclmnSimilar.setText("Similar?");
    }

    private void createDetailsGroup(Composite container) {
        this.grpDetails = new Group(container, 0);
        this.grpDetails.setLayout((Layout)new GridLayout(2, false));
        this.grpDetails.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpDetails.setText("Details");
        Label lblName = new Label((Composite)this.grpDetails, 0);
        lblName.setAlignment(131072);
        GridData gdLblName = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdLblName.minimumWidth = 100;
        gdLblName.widthHint = 100;
        lblName.setLayoutData((Object)gdLblName);
        lblName.setText("*Name:");
        this.txtName = new Text((Composite)this.grpDetails, 2048);
        GridData gdTxtName = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtName.minimumWidth = 240;
        this.txtName.setLayoutData((Object)gdTxtName);
        Label lblDescription = new Label((Composite)this.grpDetails, 0);
        lblDescription.setAlignment(131072);
        GridData gdLblDescription = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdLblDescription.minimumWidth = 100;
        gdLblDescription.widthHint = 100;
        lblDescription.setLayoutData((Object)gdLblDescription);
        lblDescription.setText("Description:");
        this.txtDescription = new Text((Composite)this.grpDetails, 2626);
        GridData gdTxtDescription = new GridData(4, 0x1000000, true, true, 1, 1);
        gdTxtDescription.minimumHeight = 80;
        this.txtDescription.setLayoutData((Object)gdTxtDescription);
    }

    private void createCommitGroup(Composite container) {
        this.grpCommit = new Group(container, 0);
        this.grpCommit.setLayout((Layout)new GridLayout(2, false));
        GridData gdGrpCommit = new GridData(4, 4, true, true, 1, 1);
        gdGrpCommit.minimumHeight = 140;
        gdGrpCommit.heightHint = 140;
        this.grpCommit.setLayoutData((Object)gdGrpCommit);
        this.grpCommit.setText("Commit");
        Label lblCommitMessage = new Label((Composite)this.grpCommit, 0);
        lblCommitMessage.setAlignment(131072);
        GridData gdLblCommitMessage = new GridData(131072, 0x1000000, false, false, 1, 1);
        gdLblCommitMessage.minimumWidth = 100;
        gdLblCommitMessage.widthHint = 100;
        lblCommitMessage.setLayoutData((Object)gdLblCommitMessage);
        lblCommitMessage.setText("*Message:");
        this.txtCommitMessage = new Text((Composite)this.grpCommit, 2626);
        GridData gdTxtCommitMessage = new GridData(4, 4, true, true, 1, 1);
        gdTxtCommitMessage.minimumHeight = 80;
        this.txtCommitMessage.setLayoutData((Object)gdTxtCommitMessage);
    }

    private void initPublishAsNewModelData() {
        this.publishAsNewModelData.setName(((PublishToPerseusWizard)this.getWizard()).getSessionProjectName());
        this.modelDataToPublish.setName(this.publishAsNewModelData.getName());
    }

    private void fetchExistingModels() {
        ProjectRefDTO project = this.getSelectedProject();
        this.lblProjectName.setText(project.getName());
        this.lblProjectName.requestLayout();
        String projectId = String.valueOf(project.getId());
        try {
            this.getExistingModels(this.getContainer(), projectId);
        }
        catch (InvocationTargetException e) {
            PerseusClientUIPlugin.getPlugin().logError(e.getMessage(), e);
            this.setErrorMessage("Failed to retrieve available models from the selected Perseus Server: " + e.getCause().getMessage());
            this.setPageComplete(false);
        }
        catch (InterruptedException e) {
            PerseusClientUIPlugin.getPlugin().logError(e.getMessage(), e);
            this.setErrorMessage("Interrupted. " + e.getMessage());
            this.setPageComplete(false);
        }
    }

    private void getExistingModels(IWizardContainer container, String projectId) throws InvocationTargetException, InterruptedException {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
        progressDialog.run(true, true, monitor -> {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                try {
                    progress.subTask("Fetching available models from Perseus...");
                    progress.worked(20);
                    List models = this.dataFetcher.getAvailableModels((IPerseusServerConfig)this.getConfig(), projectId, (IProgressMonitor)progress.split(60));
                    progress.subTask("Comparing available models with model to publish...");
                    models.sort(this.modelMatcher);
                    this.getContainer().getShell().getDisplay().syncExec(() -> this.setAvailableModels(models));
                }
                catch (PerseusServerException | IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                progress.setWorkRemaining(0);
            }
        });
    }

    private ProjectRefDTO getSelectedProject() {
        return ((PublishToPerseusWizard)this.getWizard()).getSelectedProject();
    }

    private void updateTableEnablement() {
        boolean enabled = this.btnUpdateExisting.getSelection();
        if (this.tableViewer.getTable().isEnabled() != enabled) {
            this.table.setEnabled(enabled);
        }
    }

    private void validatePage() {
        this.setPageComplete(true);
        this.setMessage(null);
        this.setErrorMessage(null);
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getModelDataProvider() == null) {
            errors.add("The selected file is not supported. Close the wizard, select a *.aird file in the workspace and restart the publication.");
            this.setPageComplete(false);
        }
        if (this.modelDataToPublish.getName() == null || this.modelDataToPublish.getName().trim().isEmpty()) {
            this.setPageComplete(false);
            errors.add("The name is mandatory.");
        }
        if (this.modelDataToPublish.getCommitMessage() == null || this.modelDataToPublish.getCommitMessage().trim().isEmpty()) {
            this.setPageComplete(false);
            errors.add("The commit message is mandatory.");
        }
        if (this.modelDataToPublish.getDescription() == null || this.modelDataToPublish.getDescription().trim().isEmpty()) {
            this.setMessage("It is recommended to enter a description for the model to publish.", 2);
        }
        if (this.btnUpdateExisting != null && this.btnUpdateExisting.getSelection() && (this.modelDataToPublish == null || this.modelDataToPublish.getModelId() == null)) {
            errors.add("A model must be selected for update.");
        }
        if (!errors.isEmpty()) {
            this.setErrorMessage(errors.stream().collect(Collectors.joining("\n")));
        }
    }

    private void updateForAdd() {
        this.updateTableEnablement();
        this.modelDataToPublish.setName(this.publishAsNewModelData.getName());
        this.modelDataToPublish.setDescription(this.publishAsNewModelData.getDescription());
        this.modelDataToPublish.setModelId(null);
    }

    private void updateForUpdate() {
        this.updateTableEnablement();
        this.modelDataToPublish.setName(this.selectedModelData.getName());
        this.modelDataToPublish.setDescription(this.selectedModelData.getDescription());
        this.modelDataToPublish.setModelId(this.selectedModelData.getModelId());
    }

    private SessionModelDataProvider getModelDataProvider() {
        return ((PublishToPerseusWizard)this.getWizard()).getModelDataProvider();
    }

    protected void initDataBindings() {
        this.bindingContext = new DataBindingContext();
        IViewerObservableValue selection = ViewerProperties.singleSelection(ModelDTO.class).observe((Viewer)this.tableViewer);
        selection.addValueChangeListener(event -> {
            boolean enabled;
            boolean bl = enabled = !this.tableViewer.getStructuredSelection().isEmpty();
            if (enabled) {
                ModelDTO dto = (ModelDTO)this.tableViewer.getStructuredSelection().getFirstElement();
                this.selectedModelData.setModelId(Long.valueOf(dto.getId()));
                String name = dto.getName();
                this.selectedModelData.setName(name);
                String description = dto.getDescription();
                this.selectedModelData.setDescription(description);
                this.txtName.setText(name != null ? name : "");
                this.txtDescription.setText(description != null ? description : "");
                this.updateForUpdate();
            } else {
                this.selectedModelData.setModelId(null);
                this.selectedModelData.setName("");
                this.selectedModelData.setDescription("");
            }
        });
        ISWTObservableValue observeTextNameObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtName);
        IObservableValue selectionNameConfigObserveValue = BeanProperties.value((String)"name").observe((Object)this.modelDataToPublish);
        this.bindingContext.bindValue((IObservableValue)observeTextNameObserveWidget, selectionNameConfigObserveValue);
        ISWTObservableValue observeTextCommitMessageObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtCommitMessage);
        IObservableValue selectionCommitMessageConfigObserveValue = BeanProperties.value((String)"commitMessage").observe((Object)this.modelDataToPublish);
        this.bindingContext.bindValue((IObservableValue)observeTextCommitMessageObserveWidget, selectionCommitMessageConfigObserveValue);
        ISWTObservableValue observeTextDescriptionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtDescription);
        IObservableValue selectionDescriptionConfigObserveValue = BeanProperties.value((String)"description").observe((Object)this.modelDataToPublish);
        this.bindingContext.bindValue((IObservableValue)observeTextDescriptionObserveWidget, selectionDescriptionConfigObserveValue);
    }

    private void setAvailableModels(List<ModelDTO> models) {
        this.getContainer().getShell().getDisplay().syncExec(() -> this.tableViewer.setInput((Object)models));
        if (models == null || models.isEmpty()) {
            this.updateForAdd();
        } else {
            ModelDTO sel = models.get(0);
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)sel));
            if (this.modelMatcher.similar(sel)) {
                this.btnPublishNew.setSelection(false);
                this.btnUpdateExisting.setSelection(true);
                this.selectedModelData.setName(sel.getName());
                this.selectedModelData.setDescription(sel.getDescription());
                this.selectedModelData.setModelId(Long.valueOf(sel.getId()));
                this.updateForUpdate();
            } else {
                this.btnUpdateExisting.setSelection(false);
                this.btnPublishNew.setSelection(true);
                this.updateForAdd();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.validatePage();
    }

    private static final class ModelDTOMatcher
    implements Comparator<ModelDTO> {
        private List<String> uids;

        private ModelDTOMatcher(List<String> uids) {
            this.uids = uids;
        }

        @Override
        public int compare(ModelDTO o1, ModelDTO o2) {
            int result = 0;
            result = this.similar(o1) ? -1 : (this.similar(o2) ? 1 : (o1.getName() == null ? 1 : (o2.getName() == null ? -1 : o2.getName().compareTo(o1.getName()))));
            return result;
        }

        public boolean similar(ModelDTO dto) {
            Set candidateUids = dto.getRoots().stream().map(AbstractModelObject::getUid).collect(Collectors.toSet());
            return candidateUids.containsAll(this.uids);
        }
    }
}

