/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.wizards;

import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.IProjectSearchParams;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.api.SearchWindow;
import fr.obeo.perseus.client.dto.ProjectRefDTO;
import fr.obeo.perseus.client.impl.project.BasicProjectSearchParams;
import fr.obeo.perseus.client.impl.project.ProjectSearchPageParam;
import fr.obeo.perseus.client.impl.project.SearchPageMode;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.PerseusClientUIPlugin;
import fr.obeo.perseus.client.ui.labels.ProjectLabelProvider;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.wizards.IServerConfigPage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class SelectProjectPage
extends WizardPage
implements IServerConfigPage,
PropertyChangeListener {
    private ProjectRefDTO selectedProject;
    private PerseusServerConfig config;
    private Table table;
    private CheckboxTableViewer tableViewer;
    private Text txtProjectNameContains;
    private SearchWindow<ProjectRefDTO> projectsWindow;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Button btnFilter;
    private Button btnPrevPage;
    private Button btnNextPage;

    public SelectProjectPage() {
        super("selectProjectPage");
        this.setPageComplete(false);
        this.setTitle(Messages.SelectProjectPage_Title);
        this.setDescription(Messages.SelectProjectPage_Desc);
    }

    public PerseusServerConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(PerseusServerConfig config) {
        this.config = config;
        this.validatePage();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.pcs.addPropertyChangeListener(this);
            this.fetchExistingProjects(null);
        } else {
            this.pcs.removePropertyChangeListener(this);
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setText("Project name contains:");
        this.createFilterComposite(container);
        this.createTableContainer(container);
    }

    private void createFilterComposite(Composite container) {
        Composite compFilter = new Composite(container, 0);
        compFilter.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        compFilter.setLayout((Layout)new GridLayout(2, false));
        this.txtProjectNameContains = new Text(compFilter, 2048);
        this.txtProjectNameContains.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnFilter = new Button(compFilter, 0);
        this.btnFilter.setText("Filter");
        this.btnFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectPage.this.fetchExistingProjects(null);
            }
        });
    }

    private void createTableContainer(Composite container) {
        Composite tableContainer = new Composite(container, 0);
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        tableContainer.setLayout((Layout)new FillLayout(256));
        this.table = new Table(tableContainer, 67620);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableViewerColumn tableViewerColName = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn tblclmnName = tableViewerColName.getColumn();
        tblclmnName.setWidth(300);
        tblclmnName.setText(Messages.SelectProjectPage_ColLbl_Name);
        tableViewerColName.setLabelProvider((CellLabelProvider)new ProjectLabelProvider(ProjectLabelProvider.ProjectField.NAME));
        TableViewerColumn tableViewerColId = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        TableColumn tblclmnId = tableViewerColId.getColumn();
        tblclmnId.setWidth(261);
        tblclmnId.setText(Messages.SelectProjectPage_ColLbl_Visibility);
        tableViewerColId.setLabelProvider((CellLabelProvider)new ProjectLabelProvider(ProjectLabelProvider.ProjectField.VISIBILITY));
        new Label(container, 0);
        Composite tableButtons = new Composite(container, 0);
        tableButtons.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        tableButtons.setLayout((Layout)new FillLayout(256));
        this.btnPrevPage = new Button(tableButtons, 0);
        this.btnPrevPage.setText("< Previous");
        this.btnPrevPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectPage.this.fetchExistingProjects(SearchPageMode.before);
            }
        });
        this.btnNextPage = new Button(tableButtons, 0);
        this.btnNextPage.setText("Next >");
        this.btnNextPage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectPage.this.fetchExistingProjects(SearchPageMode.after);
            }
        });
        this.tableViewer.addCheckStateListener(evt -> this.tableViewer.setSelection((ISelection)new StructuredSelection(evt.getElement())));
        this.tableViewer.addSelectionChangedListener(evt -> {
            this.tableViewer.setAllChecked(false);
            if (this.tableViewer.getStructuredSelection().isEmpty()) {
                this.setSelectedProject(null);
            } else {
                ProjectRefDTO project = (ProjectRefDTO)this.tableViewer.getStructuredSelection().getFirstElement();
                this.tableViewer.setChecked((Object)project, true);
                this.setSelectedProject(project);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    public ProjectRefDTO getSelectedProject() {
        return this.selectedProject;
    }

    public void setSelectedProject(ProjectRefDTO project) {
        this.selectedProject = project;
        this.validatePage();
    }

    private void validatePage() {
        if (this.selectedProject == null) {
            this.setPageComplete(false);
            this.setErrorMessage(Messages.SelectProjectPage_MissingProject);
        } else {
            this.setPageComplete(true);
            this.setErrorMessage(null);
        }
    }

    private void fetchExistingProjects(SearchPageMode pageMode) {
        BasicProjectSearchParams searchParams = this.computeSearchparams(pageMode);
        this.setProjectsWindow(null);
        try {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
            progressDialog.run(true, true, monitor -> {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        progress.subTask(Messages.SelectProjectPage_Fetching);
                        progress.worked(20);
                        final SearchWindow newWindow = PerseusClientPlugin.getPlugin().getPerseusDataFetcher().getWritableProjects((IPerseusServerConfig)this.getConfig(), (IProjectSearchParams)searchParams, (IProgressMonitor)progress.split(60));
                        this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                SelectProjectPage.this.setProjectsWindow((SearchWindow<ProjectRefDTO>)newWindow);
                            }
                        });
                    }
                    catch (PerseusServerException | IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    progress.setWorkRemaining(0);
                }
            });
        }
        catch (InvocationTargetException e) {
            PerseusClientUIPlugin.getPlugin().logError(e.getMessage(), e);
            this.setErrorMessage(e.getCause().getMessage());
        }
        catch (InterruptedException e) {
            this.setErrorMessage(Messages.SelectProjectPage_Interrupted);
        }
    }

    private BasicProjectSearchParams computeSearchparams(SearchPageMode pageMode) {
        ProjectSearchPageParam pageParam = null;
        if (pageMode != null && this.tableViewer.getInput() instanceof List) {
            switch (pageMode) {
                case after: {
                    pageParam = new ProjectSearchPageParam(pageMode, this.projectsWindow.getPageInfo().getEndCursor());
                    break;
                }
                case before: {
                    pageParam = new ProjectSearchPageParam(pageMode, this.projectsWindow.getPageInfo().getEndCursor());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        String projectNameFilter = Optional.ofNullable(this.txtProjectNameContains.getText().trim()).filter(s -> !s.isEmpty()).orElse(null);
        return new BasicProjectSearchParams(pageParam, projectNameFilter);
    }

    public void setProjectsWindow(SearchWindow<ProjectRefDTO> projectsWindow) {
        SearchWindow<ProjectRefDTO> oldWindow = this.projectsWindow;
        this.projectsWindow = projectsWindow;
        this.pcs.firePropertyChange("projectsWindow", oldWindow, projectsWindow);
    }

    protected void onProjectWindowChange(PropertyChangeEvent evt) {
        SearchWindow newWindow = (SearchWindow)evt.getNewValue();
        if (newWindow != null) {
            List projects = newWindow.getResults();
            this.getShell().getDisplay().syncExec(() -> this.tableViewer.setInput((Object)projects));
            if (projects != null && !projects.isEmpty()) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection(projects.iterator().next()));
            }
            this.btnFilter.setEnabled(true);
            this.btnNextPage.setEnabled(newWindow.getPageInfo().isHasNextPage());
            this.btnPrevPage.setEnabled(newWindow.getPageInfo().isHasPreviousPage());
        } else {
            this.tableViewer.setInput(null);
            this.btnFilter.setEnabled(false);
            this.btnNextPage.setEnabled(false);
            this.btnPrevPage.setEnabled(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("projectsWindow".equals(evt.getPropertyName())) {
            this.onProjectWindowChange(evt);
        }
    }
}

