/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.ui.wizards;

import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.IPublicationSettings;
import fr.obeo.perseus.client.ui.Messages;
import fr.obeo.perseus.client.ui.labels.ServerUrlLabelProvider;
import fr.obeo.perseus.client.ui.preferences.BooleanConverter;
import fr.obeo.perseus.client.ui.preferences.PerseusServerConfig;
import fr.obeo.perseus.client.ui.wizards.IServerConfigPage;
import fr.obeo.perseus.client.util.ModelURI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SelectServerPage
extends WizardPage
implements PropertyChangeListener {
    public static final String PROP_USE_KNOWN_MODEL_URI = "useKnownModelURI";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final List<PerseusServerConfig> serverConfigs;
    private PerseusServerConfig selectedConfig;
    private IPublicationSettings publicationSettings;
    private final ModelURI modelURI;
    private final IPerseusServerConfig modelConfig;
    private DataBindingContext bindingContext;
    private Table table;
    private TableViewer tableViewer;
    private Group grpSelectServer;
    private Group grpUpdateExistingModel;
    private Button btnUpdate;
    private Button btnPublish;
    private boolean useKnownModelURI;
    private Label lblModelURI;
    private Group authGroup;
    private ComboViewer authModeCombo;
    private Composite loginGroup;
    private Composite oauth2Group;
    private Text txtUsername;
    private Text txtPassword;
    private Text txtServerAuthorizationUrl;
    private Text txtServerTokenUrl;
    private Text txtOAuth2ClientId;
    private Text txtOAuth2Scope;

    public SelectServerPage(List<PerseusServerConfig> serverConfigs, ModelURI modelURI, IPerseusServerConfig modelConfig, IPublicationSettings publicationSettings) {
        super("selectServerPage");
        this.setPageComplete(false);
        this.setTitle(Messages.SelectServerPage_Title);
        this.setDescription(Messages.SelectServerPage_Desc);
        this.serverConfigs = Objects.requireNonNull(serverConfigs);
        this.modelURI = modelURI;
        this.modelConfig = modelConfig;
        if (modelURI == null != (modelConfig == null)) {
            throw new IllegalArgumentException();
        }
        this.publicationSettings = Objects.requireNonNull(publicationSettings);
        this.addPropertyChangeListener(this);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.modelURI != null) {
                this.lblModelURI.setText(this.modelURI.toString());
                this.setUseKnownModelURI(true);
            } else {
                this.btnUpdate.setEnabled(false);
            }
        }
        super.setVisible(visible);
    }

    public boolean isUseKnownModelURI() {
        return this.useKnownModelURI;
    }

    public void setUseKnownModelURI(boolean useKnownModelURI) {
        boolean old = this.useKnownModelURI;
        this.useKnownModelURI = useKnownModelURI;
        this.pcs.firePropertyChange(PROP_USE_KNOWN_MODEL_URI, old, useKnownModelURI);
    }

    public ModelURI getModelURI() {
        return this.modelURI;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createActionGroup(container);
        this.createOptionGroup(container);
        this.createAuthGroup(container);
        this.initDataBindings();
        if (this.serverConfigs.size() > 0) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.serverConfigs.get(0)));
        }
    }

    private void createActionGroup(Composite parent) {
        this.grpUpdateExistingModel = new Group(parent, 0);
        this.grpUpdateExistingModel.setText("Action");
        this.grpUpdateExistingModel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.grpUpdateExistingModel.setLayout((Layout)new GridLayout(2, false));
        this.btnUpdate = new Button((Composite)this.grpUpdateExistingModel, 16);
        this.btnUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.btnUpdate.setText(Messages.SelectServerPage_BtnUpdate);
        this.lblModelURI = new Label((Composite)this.grpUpdateExistingModel, 0);
        this.lblModelURI.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblModelURI.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        this.btnPublish = new Button((Composite)this.grpUpdateExistingModel, 16);
        this.btnPublish.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnPublish.setText(Messages.SelectServerPage_BtnPublish);
        new Label((Composite)this.grpUpdateExistingModel, 0);
        this.grpSelectServer = new Group((Composite)this.grpUpdateExistingModel, 0);
        this.grpSelectServer.setText("Select server");
        this.grpSelectServer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.grpSelectServer.setLayout((Layout)new GridLayout(2, false));
        this.tableViewer = new TableViewer((Composite)this.grpSelectServer, 67584);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.tableViewer.addSelectionChangedListener(evt -> {
            if (this.tableViewer.getStructuredSelection().isEmpty()) {
                this.setSelectedConfig(null);
            } else {
                this.setSelectedConfig((PerseusServerConfig)this.tableViewer.getStructuredSelection().getFirstElement());
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnUrl = tableViewerColumn.getColumn();
        tblclmnUrl.setWidth(340);
        tblclmnUrl.setText(Messages.SelectServerPage_LblColURL);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ServerUrlLabelProvider());
        this.tableViewer.setInput(this.serverConfigs);
    }

    private void createOptionGroup(Composite parent) {
        Group optionGroup = new Group(parent, 0);
        optionGroup.setText(Messages.SelectServerPage_GrpOptions);
        optionGroup.setLayout((Layout)new GridLayout(2, true));
        optionGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Button publishDiagramsBtn = new Button((Composite)optionGroup, 32);
        publishDiagramsBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        publishDiagramsBtn.setText(Messages.SelectServerPage_LblBtnPublishDiag);
        publishDiagramsBtn.setSelection(this.publicationSettings.isPublishDiagrams());
        publishDiagramsBtn.setEnabled(false);
        Button refreshDiagramsBtn = new Button((Composite)optionGroup, 32);
        refreshDiagramsBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        refreshDiagramsBtn.setText(Messages.SelectServerPage_LblBtnRefreshDiag);
        refreshDiagramsBtn.setSelection(this.publicationSettings.isRefreshDiagrams());
        refreshDiagramsBtn.setEnabled(false);
        Button filterDiagramsBtn = new Button((Composite)optionGroup, 32);
        filterDiagramsBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        filterDiagramsBtn.setText(String.format(Messages.SelectServerPage_LblBtnFiterDiagrams, this.publicationSettings.getDiagramExcludePrefix()));
        filterDiagramsBtn.setSelection(this.publicationSettings.isFilterDiagramsToPublish());
        filterDiagramsBtn.setEnabled(false);
        Button publishSemanticBrowserBtn = new Button((Composite)optionGroup, 32);
        publishSemanticBrowserBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        publishSemanticBrowserBtn.setText(Messages.SelectServerPage_LblBtnPublishSB);
        publishSemanticBrowserBtn.setSelection(this.publicationSettings.isPublishSemanticBrowser());
        publishSemanticBrowserBtn.setEnabled(false);
    }

    private void createAuthGroup(Composite parent) {
        this.authGroup = new Group(parent, 0);
        this.authGroup.setText(Messages.SelectServerPage_GrpAuthentication);
        this.authGroup.setLayout((Layout)new GridLayout(2, false));
        this.authGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label authModeLbl = new Label((Composite)this.authGroup, 0);
        authModeLbl.setEnabled(false);
        authModeLbl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        authModeLbl.setText(Messages.LblAuthMode);
        this.authModeCombo = new ComboViewer((Composite)this.authGroup);
        this.authModeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.authModeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String result = null;
                switch ((IPerseusServerConfig.AuthMode)element) {
                    case LOGIN: {
                        result = Messages.LblBtnAuthModeLogin;
                        break;
                    }
                    case OAUTH2: {
                        result = Messages.LblBtnAuthModeOAuth2;
                    }
                }
                return result;
            }
        });
        this.authModeCombo.setInput((Object)IPerseusServerConfig.AuthMode.values());
        this.authModeCombo.getCombo().setEnabled(false);
        this.authModeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectServerPage.this.validateForm();
            }
        });
        this.createLoginGroup((Composite)this.authGroup);
        this.createOAuth2Group((Composite)this.authGroup);
    }

    private void createLoginGroup(Composite parent) {
        this.loginGroup = new Group(parent, 0);
        this.loginGroup.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        GridLayout layout = new GridLayout(2, false);
        this.loginGroup.setLayout((Layout)layout);
        Label lblUserName = new Label(this.loginGroup, 0);
        lblUserName.setEnabled(false);
        lblUserName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUserName.setText(Messages.LblUserName);
        this.txtUsername = new Text(this.loginGroup, 2048);
        this.txtUsername.setEnabled(false);
        this.txtUsername.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label(this.loginGroup, 0);
        lblPassword.setEnabled(false);
        lblPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPassword.setText(Messages.LblPassword);
        this.txtPassword = new Text(this.loginGroup, 0x400800);
        this.txtPassword.setEnabled(false);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void createOAuth2Group(Composite parent) {
        this.oauth2Group = new Group(parent, 0);
        this.oauth2Group.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        GridLayout layout = new GridLayout(2, false);
        this.oauth2Group.setLayout((Layout)layout);
        Label lblServerAuthorizationUrl = new Label(this.oauth2Group, 0);
        lblServerAuthorizationUrl.setEnabled(false);
        lblServerAuthorizationUrl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblServerAuthorizationUrl.setText(Messages.LblAuthorizationUrl);
        this.txtServerAuthorizationUrl = new Text(this.oauth2Group, 2048);
        this.txtServerAuthorizationUrl.setEnabled(false);
        this.txtServerAuthorizationUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtServerAuthorizationUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectServerPage.this.validateForm();
            }
        });
        Label lblServerTokenUrl = new Label(this.oauth2Group, 0);
        lblServerTokenUrl.setEnabled(false);
        lblServerTokenUrl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblServerTokenUrl.setText(Messages.LblTokenUrl);
        this.txtServerTokenUrl = new Text(this.oauth2Group, 2048);
        this.txtServerTokenUrl.setEnabled(false);
        this.txtServerTokenUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtServerTokenUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectServerPage.this.validateForm();
            }
        });
        Label lblOAuth2ClientId = new Label(this.oauth2Group, 0);
        lblOAuth2ClientId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOAuth2ClientId.setText(Messages.LblOAuth2ClientId);
        this.txtOAuth2ClientId = new Text(this.oauth2Group, 2048);
        this.txtOAuth2ClientId.setEnabled(false);
        this.txtOAuth2ClientId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtOAuth2ClientId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectServerPage.this.validateForm();
            }
        });
        Label lblOAuth2Scope = new Label(this.oauth2Group, 0);
        lblOAuth2Scope.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOAuth2Scope.setText(Messages.LblOAuth2Scope);
        this.txtOAuth2Scope = new Text(this.oauth2Group, 2048);
        this.txtOAuth2Scope.setEnabled(false);
        this.txtOAuth2Scope.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtOAuth2Scope.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectServerPage.this.validateForm();
            }
        });
    }

    public PerseusServerConfig getSelectedConfig() {
        return this.selectedConfig;
    }

    public void setSelectedConfig(PerseusServerConfig config) {
        if (this.selectedConfig != null) {
            this.selectedConfig.removePropertyChangeListener(this);
        }
        this.selectedConfig = config;
        if (this.selectedConfig != null) {
            this.selectedConfig.addPropertyChangeListener(this);
        }
        IWizardPage[] iWizardPageArray = this.getWizard().getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof IServerConfigPage) {
                ((IServerConfigPage)page).setConfig(config);
            }
            ++n2;
        }
        this.validateForm();
    }

    private void refreshAuthGroups() {
        IPerseusServerConfig.AuthMode currentMode = this.selectedConfig != null ? this.selectedConfig.getAuthMode() : IPerseusServerConfig.AuthMode.LOGIN;
        this.loginGroup.setVisible(currentMode == IPerseusServerConfig.AuthMode.LOGIN);
        ((GridData)this.loginGroup.getLayoutData()).exclude = currentMode != IPerseusServerConfig.AuthMode.LOGIN;
        this.oauth2Group.setVisible(currentMode == IPerseusServerConfig.AuthMode.OAUTH2);
        ((GridData)this.oauth2Group.getLayoutData()).exclude = currentMode != IPerseusServerConfig.AuthMode.OAUTH2;
        this.oauth2Group.requestLayout();
        this.loginGroup.requestLayout();
        this.authGroup.layout();
    }

    protected void initDataBindings() {
        this.bindingContext = new DataBindingContext();
        IViewerObservableValue selection = ViewerProperties.singleSelection(PerseusServerConfig.class).observe((Viewer)this.tableViewer);
        selection.addValueChangeListener((IValueChangeListener)new IValueChangeListener<PerseusServerConfig>(){

            public void handleValueChange(ValueChangeEvent<? extends PerseusServerConfig> event) {
                Control ctl;
                boolean enabled = !SelectServerPage.this.tableViewer.getStructuredSelection().isEmpty();
                Control[] controlArray = SelectServerPage.this.authGroup.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ctl = controlArray[n2];
                    ctl.setEnabled(enabled);
                    ++n2;
                }
                controlArray = SelectServerPage.this.loginGroup.getChildren();
                n = controlArray.length;
                n2 = 0;
                while (n2 < n) {
                    ctl = controlArray[n2];
                    ctl.setEnabled(enabled);
                    ++n2;
                }
                controlArray = SelectServerPage.this.oauth2Group.getChildren();
                n = controlArray.length;
                n2 = 0;
                while (n2 < n) {
                    ctl = controlArray[n2];
                    ctl.setEnabled(enabled);
                    ++n2;
                }
                SelectServerPage.this.refreshAuthGroups();
            }
        });
        UpdateValueStrategy boolUpdateStrategy = UpdateValueStrategy.create((IConverter)new BooleanConverter());
        ISWTObservableValue observeBtnUpdateWidget = WidgetProperties.buttonSelection().observe((Widget)this.btnUpdate);
        IObservableValue observeUseKnownModelURIField = BeanProperties.value((String)PROP_USE_KNOWN_MODEL_URI).observe((Object)this);
        this.bindingContext.bindValue((IObservableValue)observeBtnUpdateWidget, observeUseKnownModelURIField, boolUpdateStrategy, boolUpdateStrategy);
        ISWTObservableValue observeBtnPublishNewWidget = WidgetProperties.buttonSelection().observe((Widget)this.btnPublish);
        ISWTObservableValue observeTableEnabled = WidgetProperties.enabled().observe((Widget)this.table);
        this.bindingContext.bindValue((IObservableValue)observeBtnPublishNewWidget, (IObservableValue)observeTableEnabled);
        this.configureAuthBindings((IObservableValue<PerseusServerConfig>)selection);
    }

    private void configureAuthBindings(IObservableValue<PerseusServerConfig> selection) {
        IBeanValueProperty authModeValue = BeanProperties.value((String)"authMode");
        IObservableValue selectionAuthModeObserveValue = authModeValue.observeDetail(selection);
        IViewerObservableValue authModeSelection = ViewerProperties.singleSelection(IPerseusServerConfig.AuthMode.class).observe((Viewer)this.authModeCombo);
        this.bindingContext.bindValue((IObservableValue)authModeSelection, selectionAuthModeObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> ValidationStatus.ok()), null);
        ISWTObservableValue observeTextUsernameObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtUsername);
        IObservableValue selectionUsernameObserveValue = BeanProperties.value((String)"username").observeDetail(selection);
        this.bindingContext.bindValue((IObservableValue)observeTextUsernameObserveWidget, selectionUsernameObserveValue);
        ISWTObservableValue observeTextPasswordObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPassword);
        IObservableValue selectionPasswordObserveValue = BeanProperties.value((String)"password").observeDetail(selection);
        this.bindingContext.bindValue((IObservableValue)observeTextPasswordObserveWidget, selectionPasswordObserveValue);
        ISWTObservableValue observeTextAuthorizationUrlObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtServerAuthorizationUrl);
        IObservableValue selectionAuthorizationUrlConfigObserveValue = BeanProperties.value((String)"authorizationServerUrl").observeDetail(selection);
        Binding authUrlBinding = this.bindingContext.bindValue((IObservableValue)observeTextAuthorizationUrlObserveWidget, selectionAuthorizationUrlConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateUrl((String)value, Messages.MsgInvalidAuthServerURL)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)authUrlBinding, (int)16512);
        ISWTObservableValue observeTextTokenUrlObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtServerTokenUrl);
        IObservableValue selectionTokenUrlConfigObserveValue = BeanProperties.value((String)"tokenServerUrl").observeDetail(selection);
        Binding tokenUrlBinding = this.bindingContext.bindValue((IObservableValue)observeTextTokenUrlObserveWidget, selectionTokenUrlConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateUrl((String)value, Messages.MsgInvalidTokenServerURL)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)tokenUrlBinding, (int)16512);
        ISWTObservableValue observeTextClientIdObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtOAuth2ClientId);
        IObservableValue selectionClientIdConfigObserveValue = BeanProperties.value((String)"clientId").observeDetail(selection);
        Binding clientIdBinding = this.bindingContext.bindValue((IObservableValue)observeTextClientIdObserveWidget, selectionClientIdConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateMandatoryValue((String)value, Messages.MsgInvalidClientId)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)clientIdBinding, (int)16512);
        ISWTObservableValue observeTextScopeObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtOAuth2Scope);
        IObservableValue selectionScopeConfigObserveValue = BeanProperties.value((String)"scope").observeDetail(selection);
        Binding scopeBinding = this.bindingContext.bindValue((IObservableValue)observeTextScopeObserveWidget, selectionScopeConfigObserveValue, new UpdateValueStrategy().setAfterConvertValidator(value -> this.validateScopeValue((String)value, Messages.MsgInvalidScope)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)scopeBinding, (int)16512);
    }

    private void validateForm() {
        String errorMessage = null;
        if (this.selectedConfig == null && !this.useKnownModelURI) {
            errorMessage = Messages.SelectServerPage_MissingServer;
        } else if (this.useKnownModelURI) {
            if (this.lblModelURI.getText().isEmpty()) {
                errorMessage = "The model URI is empty";
            } else {
                try {
                    URI.createURI((String)this.lblModelURI.getText());
                }
                catch (Exception e) {
                    errorMessage = "The model URI is invalid";
                }
            }
        }
        if (this.authModeCombo.getStructuredSelection().getFirstElement() == IPerseusServerConfig.AuthMode.OAUTH2) {
            IStatus status = this.validateUrl(this.txtServerAuthorizationUrl.getText(), Messages.MsgInvalidAuthServerURL);
            if (status.isOK()) {
                status = this.validateUrl(this.txtServerTokenUrl.getText(), Messages.MsgInvalidTokenServerURL);
            }
            if (status.isOK()) {
                status = this.validateMandatoryValue(this.txtOAuth2ClientId.getText(), Messages.MsgInvalidClientId);
            }
            if (status.isOK()) {
                status = this.validateScopeValue(this.txtOAuth2Scope.getText(), Messages.MsgInvalidScope);
            }
            if (!status.isOK()) {
                errorMessage = status.getMessage();
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private IStatus validateMandatoryValue(String value, String message) {
        IStatus status = ValidationStatus.ok();
        if (value == null || value.isEmpty() || value.indexOf(" ") >= 0) {
            status = ValidationStatus.error((String)message);
        }
        return status;
    }

    private IStatus validateScopeValue(String value, String message) {
        IStatus status = ValidationStatus.ok();
        if (value == null || value.isEmpty()) {
            status = ValidationStatus.error((String)message);
        }
        return status;
    }

    private IStatus validateUrl(String value, String message) {
        IStatus status = ValidationStatus.ok();
        if (value == null) {
            status = ValidationStatus.error((String)message);
        } else {
            try {
                java.net.URI uri = java.net.URI.create(value);
                if (!PerseusServerConfig.isValidForServer(uri)) {
                    status = ValidationStatus.error((String)message);
                }
            }
            catch (Exception e) {
                status = ValidationStatus.error((String)message);
            }
        }
        return status;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (PROP_USE_KNOWN_MODEL_URI.equals(evt.getPropertyName())) {
            this.btnPublish.setSelection(!this.useKnownModelURI);
            this.table.setEnabled(!this.useKnownModelURI);
            this.btnUpdate.setSelection(this.useKnownModelURI);
            this.lblModelURI.setEnabled(this.useKnownModelURI);
            if (this.useKnownModelURI) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.modelConfig));
            }
        } else if ("authMode".equals(evt.getPropertyName())) {
            this.refreshAuthGroups();
        }
    }

    public void dispose() {
        if (this.selectedConfig != null) {
            this.selectedConfig.removePropertyChangeListener(this);
        }
        super.dispose();
    }
}

