/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.capella;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.obeo.perseus.client.api.IModelTranslationParticipant;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.capella.BasicSemanticBrowserModel;
import fr.obeo.perseus.client.capella.SemanticBrowserModelConverter;
import fr.obeo.perseus.client.capella.model.SemanticBrowser;
import fr.obeo.perseus.client.capella.model.SemanticBrowserNode;
import fr.obeo.perseus.client.capella.util.SemanticBrowserNodeComparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ui.toolkit.browser.model.ISemanticBrowserModel;
import org.polarsys.capella.core.ui.semantic.browser.content.provider.SemanticBrowserContentProviderFactory;

public class PerseusServerModelTranslationParticipant
implements IModelTranslationParticipant {
    public static final String CAPELLA_SEMANTIC_BROWSER_PARTICIPANT_ID = "capella.semantic.browser";
    private final SemanticBrowserContentProviderFactory factory = new SemanticBrowserContentProviderFactory();
    private SemanticBrowserModelConverter outgoingConverter;
    private SemanticBrowserModelConverter incomingConverter;
    private SemanticBrowserModelConverter currentConverter;
    private IModelTranslationScope modelTranslationScope;

    public PerseusServerModelTranslationParticipant() {
        this.factory.setModel((ISemanticBrowserModel)new BasicSemanticBrowserModel());
    }

    public void setModelTranslationScope(IModelTranslationScope modelTranslationScope) {
        this.modelTranslationScope = modelTranslationScope;
    }

    public String getParticipantId() {
        return CAPELLA_SEMANTIC_BROWSER_PARTICIPANT_ID;
    }

    public JsonNode apply(EObject object) {
        if (this.outgoingConverter == null) {
            this.outgoingConverter = new SemanticBrowserModelConverter(this.factory.getReferencedContentProvider(), this.modelTranslationScope);
        }
        if (this.incomingConverter == null) {
            this.incomingConverter = new SemanticBrowserModelConverter(this.factory.getReferencingContentProvider(), this.modelTranslationScope);
        }
        if (this.currentConverter == null) {
            this.currentConverter = new SemanticBrowserModelConverter(this.factory.getCurrentContentProvider(), this.modelTranslationScope);
        }
        if (this.modelTranslationScope.test(object)) {
            ObjectMapper om = new ObjectMapper();
            SemanticBrowser sb = new SemanticBrowser();
            List<SemanticBrowserNode> outgoing = this.outgoingConverter.apply(object);
            this.sort(outgoing);
            sb.setOutgoing(outgoing);
            List<SemanticBrowserNode> current = this.currentConverter.apply(object);
            this.sort(current);
            sb.setCurrent(current);
            List<SemanticBrowserNode> incoming = this.incomingConverter.apply(object);
            this.sort(incoming);
            sb.setIncoming(incoming);
            return om.valueToTree((Object)sb);
        }
        return null;
    }

    private void sort(List<SemanticBrowserNode> nodes) {
        nodes.sort(SemanticBrowserNodeComparator.INSTANCE);
        for (SemanticBrowserNode node : nodes) {
            List<SemanticBrowserNode> children = node.getChildren();
            if (children == null) continue;
            this.sort(children);
        }
    }
}

