/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.capella;

import fr.obeo.perseus.client.api.EObjectWrapperMetamodel;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.capella.browser.wrapper.SemanticBrowserCapellaWrap;
import fr.obeo.perseus.client.capella.model.Category;
import fr.obeo.perseus.client.capella.model.ModelObjectRef;
import fr.obeo.perseus.client.capella.model.Primitive;
import fr.obeo.perseus.client.capella.model.SemanticBrowserNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.BrowserElementWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.CategoryWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.PrimitiveWrapper;

public class SemanticBrowserModelConverter
implements Function<EObject, List<SemanticBrowserNode>> {
    private final ITreeContentProvider contentProvider;
    private final IModelTranslationScope translationScope;
    private final SemanticBrowserCapellaWrap.ModelEdit.WrapperItemProviderAdapterFactory wrapperAdapterFactory;

    public SemanticBrowserModelConverter(ITreeContentProvider contentProvider, IModelTranslationScope translationScope) {
        this.contentProvider = Objects.requireNonNull(contentProvider);
        this.translationScope = Objects.requireNonNull(translationScope);
        this.wrapperAdapterFactory = new SemanticBrowserCapellaWrap.ModelEdit.WrapperItemProviderAdapterFactory();
    }

    @Override
    public List<SemanticBrowserNode> apply(EObject object) {
        Object[] children;
        ArrayList<SemanticBrowserNode> result = new ArrayList<SemanticBrowserNode>();
        this.contentProvider.inputChanged(null, null, (Object)object);
        Object[] objectArray = children = this.contentProvider.getChildren((Object)object);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof BrowserElementWrapper) {
                this.getJsonObjet((BrowserElementWrapper)child).ifPresent(node -> {
                    result.add((SemanticBrowserNode)node);
                    this.collectChildren(child, (SemanticBrowserNode)node);
                });
            }
            ++n2;
        }
        return result;
    }

    private void collectChildren(Object o, SemanticBrowserNode node) {
        Object[] children;
        Object[] objectArray = children = this.contentProvider.getChildren(o);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof BrowserElementWrapper) {
                this.getJsonObjet((BrowserElementWrapper)child).ifPresent(childNode -> {
                    node.ensureChildren().add((SemanticBrowserNode)childNode);
                    this.collectChildren(child, (SemanticBrowserNode)childNode);
                });
            }
            ++n2;
        }
    }

    private Optional<SemanticBrowserNode> getJsonObjet(BrowserElementWrapper wrapper) {
        SemanticBrowserNode result = null;
        if (wrapper instanceof CategoryWrapper) {
            CategoryWrapper cw = (CategoryWrapper)wrapper;
            Category c = new Category();
            c.setName(cw.getElement().getName());
            result = c;
        } else if (wrapper instanceof EObjectWrapper) {
            EObjectWrapper ow = (EObjectWrapper)wrapper;
            EObject o = ow.getElement();
            if (EObjectWrapperMetamodel.INSTANCE.getEClass().isInstance((Object)o)) {
                Primitive p = new Primitive();
                IItemLabelProvider labelProvider = (IItemLabelProvider)this.wrapperAdapterFactory.adapt((Notifier)o, IItemLabelProvider.class);
                p.setName(labelProvider.getText((Object)o));
                result = p;
            } else if (this.translationScope.test(o)) {
                ModelObjectRef mor = new ModelObjectRef();
                mor.setUid(this.translationScope.getId(o));
                result = mor;
            }
        } else if (wrapper instanceof PrimitiveWrapper) {
            PrimitiveWrapper pw = (PrimitiveWrapper)wrapper;
            Primitive p = new Primitive();
            p.setName(pw.getElement().toString());
            result = p;
        }
        return Optional.ofNullable(result);
    }
}

