/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.capella.browser.wrapper;

import fr.obeo.perseus.client.api.EObjectWrapperMetamodel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.StringPropertyValue;

public final class SemanticBrowserCapellaWrap {
    private SemanticBrowserCapellaWrap() {
    }

    public static EObject wrap(AbstractPropertyValue propertyValue) {
        Objects.requireNonNull(propertyValue);
        EPackage ePackage = EObjectWrapperMetamodel.INSTANCE.getEPackage();
        EObject wrapper = ePackage.getEFactoryInstance().create(EObjectWrapperMetamodel.INSTANCE.getEClass());
        wrapper.eSet((EStructuralFeature)EObjectWrapperMetamodel.INSTANCE.getEReference(), (Object)propertyValue);
        return wrapper;
    }

    public static Optional<AbstractPropertyValue> unwrap(Object candidate) {
        if (candidate instanceof EObject) {
            EObject wrapped;
            EObject eObject = (EObject)candidate;
            if (EObjectWrapperMetamodel.INSTANCE.getEClass().isInstance((Object)eObject) && (wrapped = (EObject)eObject.eGet((EStructuralFeature)EObjectWrapperMetamodel.INSTANCE.getEReference())) instanceof AbstractPropertyValue) {
                return Optional.of((AbstractPropertyValue)wrapped);
            }
        }
        return Optional.empty();
    }

    public static class ModelEdit {

        public static class AbstractPropertyValueWrapperItemProvider
        extends ReflectiveItemProvider {
            private final ILabelProvider defaultLabelProvider = new MDEAdapterFactoryLabelProvider();

            public AbstractPropertyValueWrapperItemProvider(AdapterFactory adapterFactory) {
                super(adapterFactory);
            }

            public Object getImage(Object object) {
                return SemanticBrowserCapellaWrap.unwrap(object).map(propertyValue -> this.getImageDefault((AbstractPropertyValue)propertyValue)).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported: %s", object)));
            }

            public String getText(Object object) {
                return SemanticBrowserCapellaWrap.unwrap(object).map(propertyValue -> AbstractPropertyValueWrapperItemProvider.getCustomText(propertyValue, this.getTextDefault((AbstractPropertyValue)propertyValue))).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported: %s", object)));
            }

            private Object getImageDefault(AbstractPropertyValue propertyValue) {
                return this.defaultLabelProvider.getImage((Object)propertyValue);
            }

            private String getTextDefault(AbstractPropertyValue propertyValue) {
                return this.defaultLabelProvider.getText((Object)propertyValue);
            }

            private static String getCustomText(AbstractPropertyValue propertyValue, String originalText) {
                List<StringPropertyValue> unitSpecifications = AbstractPropertyValueWrapperItemProvider.getPvmtUnitSpecifications(propertyValue);
                String unitText = unitSpecifications.stream().map(StringPropertyValue::getValue).collect(Collectors.joining("|"));
                return String.format("%s %s", originalText, unitText);
            }

            private static List<StringPropertyValue> getPvmtUnitSpecifications(AbstractPropertyValue propertyValue) {
                EObject container = propertyValue.eContainer();
                if (container instanceof PropertyValueGroup) {
                    PropertyValueGroup propertyValueGroup = (PropertyValueGroup)container;
                    ArrayList<StringPropertyValue> unitSpecifications = new ArrayList<StringPropertyValue>();
                    propertyValueGroup.getAppliedPropertyValueGroups().stream().forEach(metaPropertyValueGroup -> metaPropertyValueGroup.getOwnedPropertyValues().stream().forEach(metaPropertyValue -> {
                        boolean typeMatches = metaPropertyValue.getClass().isAssignableFrom(propertyValue.getClass());
                        boolean nameMatches = metaPropertyValue.getName().equals(propertyValue.getName());
                        boolean isApplied = propertyValue.getAppliedPropertyValues().contains(metaPropertyValue);
                        if (isApplied && typeMatches && nameMatches) {
                            metaPropertyValue.getOwnedPropertyValues().stream().filter(StringPropertyValue.class::isInstance).map(StringPropertyValue.class::cast).filter(stringPropertyValue -> stringPropertyValue.getName().equals("__UNIT__") && stringPropertyValue.getValue() != null).forEach(unitSpecifications::add);
                        }
                    }));
                    return unitSpecifications;
                }
                return new ArrayList<StringPropertyValue>();
            }
        }

        public static class WrapperItemProviderAdapterFactory
        extends ReflectiveItemProviderAdapterFactory {
            public Adapter createAdapter(Notifier target) {
                EObject eObject;
                if (target instanceof EObject && (eObject = (EObject)target).eClass() == EObjectWrapperMetamodel.INSTANCE.getEClass()) {
                    return new AbstractPropertyValueWrapperItemProvider((AdapterFactory)this);
                }
                return super.createAdapter(target);
            }
        }
    }
}

