/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.capella.traceability;

import fr.obeo.dsl.traceability.Traceability;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class TraceabilityResourceChangeListener
implements ResourceSetListener {
    private static final String CAPELLA_TRACEABILITY_VP_NAME = "fr.obeo.dsl.traceability.capella.vp";
    private final Session session;
    private final NotificationFilter filter = NotificationFilter.createFeatureFilter((EStructuralFeature)ViewpointPackage.eINSTANCE.getDAnalysis_SemanticResources());

    public TraceabilityResourceChangeListener(Session session) {
        this.session = session;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        Optional<ResourceDescriptor> resourceDescriptor = event.getNotifications().stream().filter(arg_0 -> ((NotificationFilter)this.filter).matches(arg_0)).filter(notif -> notif.getNewValue() instanceof ResourceDescriptor).map(notif -> (ResourceDescriptor)notif.getNewValue()).filter(this::isTraceabilityResource).findFirst();
        if (this.session.getSelectedViews().stream().noneMatch(v -> v.getViewpoint() != null && CAPELLA_TRACEABILITY_VP_NAME.equals(v.getViewpoint().getName()))) {
            return resourceDescriptor.map(rd -> new RecordingCommand(event.getEditingDomain()){

                protected void doExecute() {
                    if (TraceabilityResourceChangeListener.this.session.getOwnedViews().stream().anyMatch(v -> v.getViewpoint() != null && TraceabilityResourceChangeListener.CAPELLA_TRACEABILITY_VP_NAME.equals(v.getViewpoint().getName()))) {
                        DView view = TraceabilityResourceChangeListener.this.session.getOwnedViews().stream().filter(v -> v.getViewpoint() != null && TraceabilityResourceChangeListener.CAPELLA_TRACEABILITY_VP_NAME.equals(v.getViewpoint().getName())).findFirst().get();
                        TraceabilityResourceChangeListener.this.session.addSelectedView(view, (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        Viewpoint viewpoint = ViewpointRegistry.getInstance().getViewpoint(URI.createURI((String)"viewpoint://plugin/fr.obeo.dsl.traceability.capella.design/fr.obeo.dsl.traceability.capella.vp"));
                        List traceabilityRoots = TraceabilityResourceChangeListener.this.session.getSemanticResources().stream().filter(this::isTraceabilityResource).flatMap(res -> res.getContents().stream().filter(Traceability.class::isInstance)).collect(Collectors.toList());
                        TraceabilityResourceChangeListener.this.session.createView(viewpoint, traceabilityRoots, (IProgressMonitor)new NullProgressMonitor());
                    }
                }

                private boolean isTraceabilityResource(Resource res) {
                    return res.getURI() != null && "traceability".equals(res.getURI().fileExtension());
                }
            }).orElse(null);
        }
        return null;
    }

    private boolean isTraceabilityResource(ResourceDescriptor desc) {
        return desc.getResourceURI() != null && "traceability".equals(desc.getResourceURI().fileExtension());
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public NotificationFilter getFilter() {
        return this.filter;
    }
}

