/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.clipboard;

import fr.obeo.dsl.traceability.clipboard.extension.TextClipboardPasterRegistry;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;

public class ClipboardPropertyTester
extends PropertyTester {
    public static final String VALID_CONTENT_PROP = "hasValidContent";
    private static final Clipboard CLIPBOARD = new Clipboard(PlatformUI.getWorkbench().getDisplay());

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.endsWith(VALID_CONTENT_PROP) && receiver instanceof EObject) {
            String clipboard = ClipboardPropertyTester.getClipboardText();
            return clipboard != null && !clipboard.trim().isEmpty() && ClipboardPropertyTester.hasPasterFor((EObject)receiver, clipboard);
        }
        return false;
    }

    private static boolean hasPasterFor(EObject target, String clipboard) {
        return TextClipboardPasterRegistry.findPaster(target, clipboard).isPresent();
    }

    static String getClipboardText() {
        Object contents = CLIPBOARD.getContents((Transfer)TextTransfer.getInstance());
        return contents instanceof String ? (String)contents : null;
    }
}

