/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.clipboard.action;

import fr.obeo.dsl.traceability.clipboard.action.AbstractCopyPasteAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public abstract class AbstractCopyPasteCommandHandler
extends AbstractHandler
implements IElementUpdater {
    protected static final String ACTIVE_PART_VARIABLE = "activePart";
    protected static final String ACTIVE_WORKBENCH_WINDOW = "activeWorkbenchWindow";

    private <T> T getAdapter(Object object, Class<T> expectedSelectionType) {
        T result = null;
        if (expectedSelectionType.isInstance(object)) {
            result = expectedSelectionType.cast(object);
        }
        if (result == null && object instanceof IAdaptable) {
            result = expectedSelectionType.cast(((IAdaptable)object).getAdapter(expectedSelectionType));
        }
        return result;
    }

    protected <T> List<T> getSelection(ExecutionEvent event, Class<T> expectedSelectionType) {
        ArrayList<T> result = new ArrayList<T>(0);
        if (event == null) {
            return result;
        }
        Object applicationContext = event.getApplicationContext();
        if (applicationContext == null) {
            return result;
        }
        if (!(applicationContext instanceof IEvaluationContext)) {
            return result;
        }
        IEvaluationContext evaluationContext = (IEvaluationContext)event.getApplicationContext();
        Object defaultVariable = evaluationContext.getDefaultVariable();
        if (defaultVariable == null) {
            return result;
        }
        if (defaultVariable instanceof Collection) {
            Collection variables = (Collection)evaluationContext.getDefaultVariable();
            for (Object currentVariable : variables) {
                T adapter = this.getAdapter(currentVariable, expectedSelectionType);
                if (adapter == null) continue;
                result.add(adapter);
            }
        }
        return result;
    }

    protected Object getVariableValue(ExecutionEvent event, String variableName) {
        Object result = null;
        if (event == null) {
            return result;
        }
        if (!(event.getApplicationContext() instanceof IEvaluationContext)) {
            return result;
        }
        IEvaluationContext applicationContext = (IEvaluationContext)event.getApplicationContext();
        if (applicationContext == null) {
            return result;
        }
        result = applicationContext.getVariable(variableName);
        return result;
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        AbstractCopyPasteAction action = this.getAction();
        action.setActivePart(null, this.getActivePart());
        action.selectionChanged(null, this.getSelection());
        action.run(null);
        return null;
    }

    protected abstract AbstractCopyPasteAction getAction();

    protected IWorkbenchPart getActivePart() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
    }

    protected ISelection getSelection() {
        ISelection result = null;
        try {
            IWorkbenchPart activePart = this.getActivePart();
            if (activePart != null) {
                result = activePart.getSite().getSelectionProvider().getSelection();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isEnabled() {
        boolean result = false;
        ISelection selection = this.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof EditPart) {
            AbstractCopyPasteAction action = this.getAction();
            action.selectionChanged(null, selection);
            result = action.isEnabled();
        }
        return result;
    }
}

