/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.clipboard.action;

import fr.obeo.dsl.traceability.clipboard.action.AbstractCopyPasteAction;
import fr.obeo.dsl.traceability.clipboard.action.AbstractCopyPasteCommandHandler;
import fr.obeo.dsl.traceability.clipboard.extension.TextClipboardPasterRegistry;
import fr.obeo.dsl.traceability.clipboard.util.SiriusDiagrams;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.osgi.framework.Bundle;

public class PasteUrlAction
extends AbstractCopyPasteAction {
    public void run(IAction action) {
        String content = this.getTextFromSystemClipboard();
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressDialog.run(false, true, monitor -> this.pasteLinkInSelection(content, monitor));
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Bundle bundle = Platform.getBundle((String)"fr.obeo.dsl.traceability.clipboard");
            ILog log = Platform.getLog((Bundle)bundle);
            log.log((IStatus)new Status(4, "fr.obeo.dsl.traceability.clipboard", String.format("Could not paste value '%s' as a link.", content), (Throwable)e));
        }
    }

    protected void pasteLinkInSelection(String content, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.beginTask("Pasting Traceability Link...", 100);
        monitor.worked(1);
        List<? extends View> selectedViews = this.getCopyPasteSelection();
        monitor.worked(1);
        DSemanticDecorator target = PasteUrlAction.getSelectedElement(selectedViews);
        if (target != null) {
            progress.worked(10);
            TextClipboardPasterRegistry.findPaster((EObject)target, content).ifPresent(paster -> paster.getPasteCommand((EObject)target, content, this.getShell(), (IProgressMonitor)progress.split(40)).filter(Command::canExecute).ifPresent(pasteCommand -> {
                EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)target);
                if (editingDomain != null) {
                    editingDomain.getCommandStack().execute(pasteCommand);
                } else {
                    pasteCommand.execute();
                }
            }));
        }
    }

    private static DSemanticDecorator getSelectedElement(List<? extends View> views) {
        return Optional.of(views).filter(v -> !v.isEmpty()).map(v -> SiriusDiagrams.getSiriusElement((View)v.get(0))).filter(semanticDecorator -> semanticDecorator.getTarget() != null).orElse(null);
    }

    @Override
    protected boolean isEnabled() {
        return !this.isInLabelEdition();
    }

    public static class Handler
    extends AbstractCopyPasteCommandHandler {
        @Override
        protected AbstractCopyPasteAction getAction() {
            return new PasteUrlAction();
        }
    }
}

