/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.clipboard.extension;

import fr.obeo.dsl.traceability.clipboard.extension.TextClipboardPaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public final class TextClipboardPasterRegistry {
    private static final String FIELD_SEPARATOR = "\\s*,\\s*";
    private static final String CLASS_PROPERTY = "class";
    private static final String OVERRIDE_PROPERTY = "override";
    private static TextClipboardPasterRegistry instance;
    private final ILog logger;
    private final IRegistryChangeListener cacheCleaner = event -> {
        List<? extends TextClipboardPaster> list = this.cache = null;
    };
    private volatile List<? extends TextClipboardPaster> cache;

    private TextClipboardPasterRegistry(Plugin context) {
        this.logger = context.getLog();
        Platform.getExtensionRegistry().addRegistryChangeListener(this.cacheCleaner, "fr.obeo.dsl.traceability.clipboard");
    }

    public static synchronized void activate(Plugin context) {
        if (instance == null) {
            instance = new TextClipboardPasterRegistry(context);
        }
    }

    public static synchronized void release() {
        if (instance != null) {
            Platform.getExtensionRegistry().removeRegistryChangeListener(TextClipboardPasterRegistry.instance.cacheCleaner);
            instance = null;
        }
    }

    private static List<? extends TextClipboardPaster> getPasters() {
        return instance.getCache();
    }

    public static Optional<? extends TextClipboardPaster> findPaster(EObject target, String content) {
        return TextClipboardPasterRegistry.getPasters().stream().filter(p -> p.canApply(target, content)).findFirst();
    }

    private synchronized List<? extends TextClipboardPaster> getCache() {
        if (this.cache == null) {
            this.cache = this.buildRegisteredPasters();
        }
        return this.cache;
    }

    private List<TextClipboardPaster> buildRegisteredPasters() {
        ArrayList<TextClipboardPaster> result = new ArrayList<TextClipboardPaster>();
        HashSet<String> dones = new HashSet<String>();
        for (Definition definition : this.getPasterDefinitions()) {
            if (dones.contains(definition.classname)) continue;
            TextClipboardPaster paster = definition.toInstance();
            if (paster != null) {
                result.add(paster);
            }
            dones.add(definition.classname);
        }
        return result;
    }

    private List<Definition> getPasterDefinitions() {
        ArrayList<Definition> result = new ArrayList<Definition>();
        HashSet overrides = new HashSet();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("fr.obeo.dsl.traceability.clipboard", "pasters");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            Definition element = new Definition(configurationElement);
            result.add(element);
            overrides.addAll(element.overrides);
            ++n2;
        }
        result.removeIf(it -> !((Definition)it).isEnabled(overrides));
        return result;
    }

    private final class Definition {
        private final String classname;
        private final List<String> overrides;
        private IConfigurationElement configurationElement;

        private Definition(IConfigurationElement cfg) {
            this.configurationElement = cfg;
            this.classname = cfg.getAttribute(TextClipboardPasterRegistry.CLASS_PROPERTY);
            String overridesValue = cfg.getAttribute(TextClipboardPasterRegistry.OVERRIDE_PROPERTY);
            this.overrides = overridesValue == null ? Collections.emptyList() : Arrays.asList(overridesValue.trim().split(TextClipboardPasterRegistry.FIELD_SEPARATOR));
        }

        private boolean isEnabled(Set<String> someOverrides) {
            return this.classname != null && !this.classname.isEmpty() && !someOverrides.contains(this.classname);
        }

        private TextClipboardPaster toInstance() {
            try {
                Object o = this.configurationElement.createExecutableExtension(TextClipboardPasterRegistry.CLASS_PROPERTY);
                if (o instanceof TextClipboardPaster) {
                    return (TextClipboardPaster)o;
                }
            }
            catch (CoreException e) {
                TextClipboardPasterRegistry.this.logger.log((IStatus)new Status(4, "fr.obeo.dsl.traceability.clipboard", e.getLocalizedMessage(), (Throwable)e));
            }
            return null;
        }

        public String toString() {
            return "TextClipboardPaster:" + this.classname;
        }
    }
}

