/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.sirius.texttransfer.drop.support;

import fr.obeo.sirius.texttransfer.drop.support.Messages;
import fr.obeo.sirius.texttransfer.drop.support.drop.DropUtils;
import fr.obeo.sirius.texttransfer.drop.support.drop.ITextTransferDropSupport;
import fr.obeo.sirius.texttransfer.drop.support.listeners.DropPartListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class SiriusTextTransferDropSupportPlugin
extends EMFPlugin {
    public static final SiriusTextTransferDropSupportPlugin INSTANCE = new SiriusTextTransferDropSupportPlugin();
    public static final String PLUGIN_ID = "fr.obeo.sirius.texttransfer.drop.support";
    private static final String CLASS_EXECUTABLE_EXTENSION = "class";
    private static final String ENABLED_WHEN_EXPRESSION = "enabledWhen";
    private static final String DROP_SUPPORT_ELEMENT_CONFIGURATION = "dropSupport";
    private static final String DROP_SUPPORT_EXTENSION_POINT = "fr.obeo.sirius.texttransfer.drop.support.DropSupport";
    private static Implementation plugin;

    public SiriusTextTransferDropSupportPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin
    implements BundleActivator {
        private List<ITextTransferDropSupport> textTransferDropSupports;
        private DropPartListener dropPartListener;
        private IWindowListener windowListener;

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            plugin = this;
            this.addListeners();
            this.registerTextTransferDropSupportExtensions();
        }

        public void stop(BundleContext context) throws Exception {
            this.textTransferDropSupports = null;
            plugin = null;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (this.windowListener != null) {
                workbench.removeWindowListener(this.windowListener);
            }
            if (this.dropPartListener != null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    window.getPartService().removePartListener((IPartListener2)this.dropPartListener);
                    ++n2;
                }
            }
            super.stop(context);
        }

        public void logError(String message, Throwable cause) {
            this.getLog().log((IStatus)new Status(4, SiriusTextTransferDropSupportPlugin.PLUGIN_ID, message, cause));
        }

        public void logError(String message) {
            this.getLog().log((IStatus)new Status(4, SiriusTextTransferDropSupportPlugin.PLUGIN_ID, message));
        }

        public List<ITextTransferDropSupport> getTextTransferDropSupportExtensions() {
            return this.textTransferDropSupports;
        }

        public void addListeners() {
            IWorkbenchWindow[] windows;
            this.dropPartListener = new DropPartListener();
            this.windowListener = new IWindowListener(){

                public void windowOpened(IWorkbenchWindow window) {
                    window.getPartService().addPartListener((IPartListener2)dropPartListener);
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                    window.getPartService().removePartListener((IPartListener2)dropPartListener);
                }

                public void windowActivated(IWorkbenchWindow window) {
                }
            };
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.addWindowListener(this.windowListener);
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.getPartService().addPartListener((IPartListener2)this.dropPartListener);
                IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n5 = iEditorReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        final IEditorReference editor = iEditorReferenceArray[n6];
                        if (editor.getEditor(false) instanceof DDiagramEditor) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DropUtils.addTransferDropTargetListener((DDiagramEditor)editor.getEditor(false));
                                }
                            });
                        }
                        ++n6;
                    }
                    iEditorReferenceArray = page.getViewReferences();
                    n5 = iEditorReferenceArray.length;
                    n6 = 0;
                    while (n6 < n5) {
                        IEditorReference viewReference = iEditorReferenceArray[n6];
                        final IViewPart view = viewReference.getView(false);
                        if (view instanceof CommonNavigator) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DropUtils.addTextTransferType((CommonNavigator)view);
                                }
                            });
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        private void registerTextTransferDropSupportExtensions() {
            this.textTransferDropSupports = new ArrayList<ITextTransferDropSupport>();
            IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint(SiriusTextTransferDropSupportPlugin.DROP_SUPPORT_EXTENSION_POINT).getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (SiriusTextTransferDropSupportPlugin.DROP_SUPPORT_ELEMENT_CONFIGURATION.equals(configurationElement.getName()) && this.isEnabled(configurationElement)) {
                        try {
                            ITextTransferDropSupport textTransferDropSupport = (ITextTransferDropSupport)configurationElement.createExecutableExtension(SiriusTextTransferDropSupportPlugin.CLASS_EXECUTABLE_EXTENSION);
                            this.textTransferDropSupports.add(textTransferDropSupport);
                        }
                        catch (CoreException e) {
                            SiriusTextTransferDropSupportPlugin.getPlugin().logError(Messages.DropUtils_ErrorReadingExtensionPoint, e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        private boolean isEnabled(IConfigurationElement configurationElement) {
            Expression expression = null;
            boolean isEnabled = true;
            try {
                IConfigurationElement[] expressionRoots;
                IConfigurationElement[] expressions = configurationElement.getChildren(SiriusTextTransferDropSupportPlugin.ENABLED_WHEN_EXPRESSION);
                if (expressions != null && expressions.length > 0) {
                    isEnabled = false;
                }
                if (expressions != null && expressions.length == 1 && (expressionRoots = expressions[0].getChildren()) != null && expressionRoots.length == 1) {
                    expression = ExpressionConverter.getDefault().perform(expressionRoots[0]);
                }
                if (expression != null) {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    EvaluationResult result = expression.evaluate(handlerService.getCurrentState());
                    isEnabled = result == EvaluationResult.TRUE;
                }
            }
            catch (CoreException e) {
                this.getLog().log(e.getStatus());
            }
            return isEnabled;
        }
    }
}

