/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.sirius.texttransfer.drop.support.drop;

import fr.obeo.sirius.texttransfer.drop.support.SiriusTextTransferDropSupportPlugin;
import fr.obeo.sirius.texttransfer.drop.support.drop.EMFCommandProvider;
import fr.obeo.sirius.texttransfer.drop.support.drop.ITextTransferDropSupport;
import fr.obeo.sirius.texttransfer.drop.support.drop.SiriusDiagramTextTransferDropTargetListener;
import fr.obeo.sirius.texttransfer.drop.support.drop.TextTransferDropTargetAdapter;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public final class DropUtils {
    private DropUtils() {
    }

    public static boolean isTextTransferSupportedType(DropTarget dropTarget) {
        return Arrays.stream(dropTarget.getTransfer()).anyMatch(t -> DropUtils.isTextTransferSupportedType(t));
    }

    public static boolean isTextTransferSupportedType(Transfer transfer) {
        return Arrays.stream(transfer.getSupportedTypes()).anyMatch(arg_0 -> ((TextTransfer)TextTransfer.getInstance()).isSupportedType(arg_0));
    }

    public static void addTransferDropTargetListener(DDiagramEditor diagramEditor) {
        SiriusDiagramTextTransferDropTargetListener transferDropTargetListener = new SiriusDiagramTextTransferDropTargetListener((EditPartViewer)((DiagramEditor)diagramEditor).getDiagramGraphicalViewer(), (Transfer)TextTransfer.getInstance());
        ((DiagramEditor)diagramEditor).getDiagramGraphicalViewer().addDropTargetListener((TransferDropTargetListener)transferDropTargetListener);
    }

    public static void addTextTransferType(DropTarget dropTarget) {
        Transfer[] currentTransfers = dropTarget.getTransfer();
        int currentLength = currentTransfers.length;
        Transfer[] newTransfers = new Transfer[currentLength + 1];
        System.arraycopy(currentTransfers, 0, newTransfers, 0, currentLength);
        newTransfers[currentLength] = TextTransfer.getInstance();
        dropTarget.setTransfer(newTransfers);
    }

    public static void addTextTransferType(CommonNavigator commonNavigator) {
        CommonViewer commonViewer = commonNavigator.getCommonViewer();
        Control control = commonViewer.getControl();
        Object data = control.getData("DropTarget");
        if (data instanceof DropTarget) {
            DropTarget target = (DropTarget)data;
            if (!DropUtils.isTextTransferSupportedType(target)) {
                DropUtils.addTextTransferType(target);
            }
            DropTargetListener[] listeners = target.getDropListeners();
            if (!Arrays.stream(listeners).anyMatch(TextTransferDropTargetAdapter.class::isInstance)) {
                target.addDropListener((DropTargetListener)new TextTransferDropTargetAdapter());
            }
        }
    }

    public static void executeDrop(DropTargetEvent event) {
        List<ITextTransferDropSupport> textTransferDropSupportExtensions = SiriusTextTransferDropSupportPlugin.getPlugin().getTextTransferDropSupportExtensions();
        if (textTransferDropSupportExtensions.stream().anyMatch(e -> e.canHandle(event))) {
            textTransferDropSupportExtensions.stream().filter(e -> e.canHandle(event)).forEach(e -> e.execute(event));
        }
    }

    public static Command getEMFCommand(DropTargetEvent event) {
        CompoundCommand result = new CompoundCommand();
        SiriusTextTransferDropSupportPlugin.getPlugin().getTextTransferDropSupportExtensions().stream().filter(e -> e.canHandle(event) && e instanceof EMFCommandProvider).forEach(e -> ((EMFCommandProvider)e).getCommand(event).ifPresent(c -> result.append(c)));
        return result;
    }
}

