/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.edit.commands;

import fr.obeo.dsl.traceability.SynchronizationPoint;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilityFactory;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class SetTraceabilityLatestSynchronizationPoint
extends RecordingCommand {
    private final Instant timestamp;
    private final ITraceabilityStrategy traceabilityStrategy;

    public SetTraceabilityLatestSynchronizationPoint(TransactionalEditingDomain domain, String label, ITraceabilityStrategy traceabilityStrategy, Instant timestamp) {
        super(domain, label);
        this.timestamp = Objects.requireNonNull(timestamp);
        this.traceabilityStrategy = Objects.requireNonNull(traceabilityStrategy);
    }

    protected void doExecute() {
        Traceability traceability = (Traceability)this.traceabilityStrategy.findTraceability().get();
        SynchronizationPoint syncPoint = TraceabilityFactory.eINSTANCE.createSynchronizationPoint();
        syncPoint.setName(String.format("Update from Server at %s", this.timestamp));
        traceability.setLatestSynchronizationPoint(syncPoint);
    }
}

