/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.initializer;

import fr.obeo.dsl.traceability.initializer.Messages;
import fr.obeo.dsl.traceability.initializer.TraceabilityInitializerExtensionDescriptor;
import fr.obeo.dsl.traceability.initializer.TraceabilityInitializerPlugin;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class InitializerSelector {
    private final List<TraceabilityInitializerExtensionDescriptor> registeredInitializers = new ArrayList<TraceabilityInitializerExtensionDescriptor>();

    public InitializerSelector() {
        this.registeredInitializers.addAll(TraceabilityInitializerPlugin.getPlugin().getTraceabilityInitializers());
    }

    public void registerInitializer(TraceabilityInitializerExtensionDescriptor initializer) {
        this.registeredInitializers.add(initializer);
    }

    public void unregisterInitializer(TraceabilityInitializerExtensionDescriptor initializer) {
        this.registeredInitializers.remove(initializer);
    }

    public List<TraceabilityInitializerExtensionDescriptor> getInitializerSelection(ITraceabilityInitializerContext context, Shell shell) throws CoreException {
        ArrayList<TraceabilityInitializerExtensionDescriptor> initializersSelection = new ArrayList<TraceabilityInitializerExtensionDescriptor>();
        if (shell != null && !shell.isDisposed()) {
            List<TraceabilityInitializerExtensionDescriptor> relevantInitializers = this.registeredInitializers.stream().filter(initializer -> initializer.getInitializer().test(context)).collect(Collectors.toList());
            InitializerSelectionDialog dlg = new InitializerSelectionDialog(shell, relevantInitializers);
            int status = dlg.open();
            if (status == 0) {
                initializersSelection.addAll(Arrays.asList(dlg.getResult()).stream().map(elem -> (TraceabilityInitializerExtensionDescriptor)elem).collect(Collectors.toList()));
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "fr.obeo.dsl.traceability.initializer", "Failed to open  Initializers selection dialog: shell is disposed"));
        }
        return initializersSelection;
    }

    private static final class InitializerLabelProvider
    extends ColumnLabelProvider {
        private InitializerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TraceabilityInitializerExtensionDescriptor) {
                return ((TraceabilityInitializerExtensionDescriptor)element).getInitializerName();
            }
            return super.getText(element);
        }

        public String getToolTipText(Object element) {
            if (element instanceof TraceabilityInitializerExtensionDescriptor) {
                return ((TraceabilityInitializerExtensionDescriptor)element).getInitializerDescription();
            }
            return super.getToolTipText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof TraceabilityInitializerExtensionDescriptor) {
                return ((TraceabilityInitializerExtensionDescriptor)element).getInitializerIcon();
            }
            return super.getImage(element);
        }
    }

    private static final class InitializerSelectionDialog
    extends ListSelectionDialog {
        InitializerSelectionDialog(Shell shell, List<TraceabilityInitializerExtensionDescriptor> initializers) {
            super(shell, initializers, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new InitializerLabelProvider(), Messages.TraceabilityInitializer_SelectionDialogMessage);
        }

        protected Control createDialogArea(Composite parent) {
            Control result = super.createDialogArea(parent);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getViewer());
            return result;
        }
    }
}

