/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.dsl.traceability.initializer;

import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.initializer.api.ITraceabilityInitializerContext;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;

public class TraceabilityInitializerContext
implements ITraceabilityInitializerContext {
    private final Session session;
    private Traceability traceability;

    public TraceabilityInitializerContext(Session session, Traceability traceability) {
        this.session = Objects.requireNonNull(session);
        this.setTraceability(traceability);
    }

    public void setTraceability(Traceability traceability) {
        if (this.traceability != null) {
            throw new IllegalStateException("The initializer already has a traceability, it cannot be changed.");
        }
        this.traceability = traceability;
        if (traceability != null && Session.of((EObject)traceability).map(s -> s != this.session).orElse(true).booleanValue()) {
            throw new IllegalArgumentException("The given traceability must belong to the given session.");
        }
    }

    @Override
    public Optional<Traceability> getTraceability() {
        return Optional.ofNullable(this.traceability);
    }

    @Override
    public Session getSession() {
        return this.session;
    }
}

