/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client;

import fr.obeo.perseus.client.api.IOslcDataFetcher;
import fr.obeo.perseus.client.api.IPerseusDataFetcher;
import fr.obeo.perseus.client.api.IPerseusServerCredentialProvider;
import fr.obeo.perseus.client.api.IPublicationResultJobRegistry;
import fr.obeo.perseus.client.api.ISessionSupport;
import fr.obeo.perseus.client.impl.PerseusDataFetcher;
import fr.obeo.perseus.client.impl.jobs.PublicationJobRegistry;
import fr.obeo.perseus.client.impl.traceability.PerseusSessionManagerListener;
import fr.obeo.perseus.client.util.PerseusHttpSupport;
import fr.obeo.perseus.client.util.PerseusSessionUtil;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class PerseusClientPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "fr.obeo.perseus.client";
    public static final PerseusClientPlugin INSTANCE = new PerseusClientPlugin();
    private static Implementation plugin;

    public PerseusClientPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin
    implements BundleActivator {
        private static BundleContext context;
        private final PerseusSessionManagerListener sessionManagerListener;
        private final PerseusHttpSupport.Factory httpSupportFactory;
        private final PerseusDataFetcher perseusDataFetcher;
        private final PerseusSessionUtil sessionSupport;
        private final IPublicationResultJobRegistry publicationResultJobRegistry;
        private IPerseusServerCredentialProvider perseusServerCredentialProvider;

        public Implementation() {
            plugin = this;
            this.sessionManagerListener = new PerseusSessionManagerListener();
            this.sessionSupport = new PerseusSessionUtil();
            this.httpSupportFactory = new PerseusHttpSupport.Factory();
            this.perseusDataFetcher = new PerseusDataFetcher(this.httpSupportFactory);
            this.publicationResultJobRegistry = new PublicationJobRegistry();
        }

        static BundleContext getContext() {
            return context;
        }

        public void start(BundleContext bundleContext) throws Exception {
            context = bundleContext;
            SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)this.sessionManagerListener);
            for (Session session : SessionManager.INSTANCE.getSessions()) {
                this.sessionManagerListener.registerTraceabilityStrategy(session);
            }
        }

        public void stop(BundleContext bundleContext) throws Exception {
            SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this.sessionManagerListener);
            context = null;
        }

        public void register(IPerseusServerCredentialProvider aServerCredentialsProvider) {
            this.perseusServerCredentialProvider = Objects.requireNonNull(aServerCredentialsProvider);
        }

        public IPerseusServerCredentialProvider getPerseusServerCredentialProvider() {
            return this.perseusServerCredentialProvider;
        }

        public PerseusSessionManagerListener getSessionManagerListener() {
            return this.sessionManagerListener;
        }

        public IOslcDataFetcher getOslcDataFetcher() {
            return this.perseusDataFetcher;
        }

        public IPerseusDataFetcher getPerseusDataFetcher() {
            return this.perseusDataFetcher;
        }

        public ISessionSupport getSessionSupport() {
            return this.sessionSupport;
        }

        public PerseusHttpSupport.Factory getHttpSupportFactory() {
            return this.httpSupportFactory;
        }

        public void logError(String message, Throwable cause) {
            this.getLog().log((IStatus)new Status(4, PerseusClientPlugin.PLUGIN_ID, message, cause));
        }

        public IPublicationResultJobRegistry getPublicationJobRegistry() {
            return this.publicationResultJobRegistry;
        }
    }
}

