/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.obeo.perseus.client.api.IOAuth2Settings;
import fr.obeo.perseus.client.api.PerseusCredentialsException;
import fr.obeo.perseus.client.util.ModelURI;
import java.net.URI;
import java.util.Optional;
import org.apache.http.client.CredentialsProvider;

public interface IPerseusServerConfig {
    @JsonIgnore
    public static final URI API_GRAPHQL = URI.create("graphql");
    @JsonIgnore
    public static final URI API_TRANSACTION = URI.create("transaction/");
    @JsonIgnore
    public static final String PERSEUS_API_REALM = "Perseus API";

    public URI getApiURI();

    public URI getJobsURI();

    public AuthMode getAuthMode();

    public CredentialsProvider getCredentialsProvider() throws PerseusCredentialsException;

    public Optional<IOAuth2Settings> getOAuth2Settings();

    default public boolean matches(ModelURI modelURI) {
        if (modelURI == null) {
            return false;
        }
        URI lUri = this.getApiURI();
        return lUri != null && modelURI.getServerURI().authority().equals(lUri.getAuthority()) && modelURI.getServerURI().scheme().equals(lUri.getScheme());
    }

    public static enum AuthMode {
        LOGIN,
        OAUTH2;

    }
}

