/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.compatibility;

import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.Messages;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.compatibility.SelectPerseusModelURIDialog;
import fr.obeo.perseus.client.util.ModelURI;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.description.DAnnotationEntry;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PerseusModelMigrator
implements SessionManagerListener {
    private static final String ANN_PERSEUS_MODEL_URI = "http://www.obeo.fr/perseus/model/URI";

    private void migrateIfNecessary(final Session session) {
        final List<DAnnotationEntry> perseusModelURIAnnotations = this.getDAnalysisForPerseusData(session).map(dAnalysis -> dAnalysis.getEAnnotations().stream().filter(ann -> ANN_PERSEUS_MODEL_URI.equals(ann.getSource())).collect(Collectors.toList())).orElse(Collections.emptyList());
        if (!perseusModelURIAnnotations.isEmpty()) {
            ModelURI perseusModelUri;
            PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", String.format(Messages.Migrate_Perseus_Model, session.getID())));
            try {
                perseusModelUri = this.getPerseusModelUri(session, perseusModelURIAnnotations);
            }
            catch (OperationCanceledException e) {
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", String.format(Messages.Migrate_Perseus_Model_Canceled, session.getID())));
                return;
            }
            PerseusClientPlugin.getPlugin().getSessionManagerListener().registerTraceabilityStrategy(session);
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                try {
                    new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InterruptedException {
                            PerseusModelMigrator.this.migrateSession(session, perseusModelURIAnnotations, perseusModelUri, monitor);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    throw new OperationCanceledException();
                }
            });
        }
    }

    private Optional<DAnalysis> getDAnalysisForPerseusData(Session session) {
        DAnalysis analysis;
        List analysisRoots = session.getSessionResource().getContents().stream().filter(DAnalysis.class::isInstance).map(DAnalysis.class::cast).collect(Collectors.toList());
        Optional<DAnalysis> result = analysisRoots.size() > 0 ? (this.isSharedSession(analysis = (DAnalysis)analysisRoots.get(0)) ? Optional.of((DAnalysis)analysis.getReferencedAnalysis().get(0)) : Optional.of(analysis)) : Optional.empty();
        return result;
    }

    private boolean isSharedSession(DAnalysis analysis) {
        return analysis.getReferencedAnalysis().stream().findFirst().map(referencedAnalysis -> new URIQuery(referencedAnalysis.eResource().getURI()).isCDOURI()).orElse(Boolean.FALSE);
    }

    private ModelURI getPerseusModelUri(Session session, List<DAnnotationEntry> perseusModelURIAnnotations) throws OperationCanceledException {
        ModelURI selection;
        ArrayList<ModelURI> perseusModelUris = new ArrayList<ModelURI>();
        for (DAnnotationEntry dAnnotationEntry : perseusModelURIAnnotations) {
            perseusModelUris.addAll(dAnnotationEntry.getDetails().stream().map(ModelURI::of).collect(Collectors.toList()));
        }
        ModelURI perseusModelUri = perseusModelUris.size() > 1 ? ((selection = this.openChoosePerseusModelURIDialog(session, perseusModelUris)) != null ? selection : (ModelURI)perseusModelUris.get(0)) : (ModelURI)perseusModelUris.get(0);
        return perseusModelUri;
    }

    private ModelURI openChoosePerseusModelURIDialog(Session session, final List<ModelURI> perseusModelUris) {
        URI modelURI = session.getSessionResource().getURI();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().findMember(modelURI.toPlatformString(true)).getProject();
        final String projectName = project.getName();
        RunnableWithResult.Impl<ModelURI> runnable = new RunnableWithResult.Impl<ModelURI>(){

            public void run() {
                SelectPerseusModelURIDialog dialog = new SelectPerseusModelURIDialog(Display.getDefault().getActiveShell(), String.format(Messages.Migrate_Perseus_Model_SelectTitle, projectName), String.format(Messages.Migrate_Perseus_Model_SelectMessage, projectName));
                dialog.setModelURIs(perseusModelUris);
                dialog.open();
                this.setResult(dialog.getSelection());
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (ModelURI)runnable.getResult();
    }

    private void migrateSession(Session session, final List<DAnnotationEntry> perseusModelURIAnnotations, final ModelURI perseusModelUri, IProgressMonitor monitor) {
        Traceability traceability;
        try {
            traceability = this.getOrCreateTraceability(session, monitor);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        monitor.subTask(Messages.Migrate_Perseus_Model_MigrateSession);
        TransactionalEditingDomain ted = session.getTransactionalEditingDomain();
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                traceability.setModelUri(perseusModelUri.toString());
                perseusModelURIAnnotations.forEach(annotation -> EcoreUtil.delete((EObject)annotation));
            }
        });
        session.save(monitor);
    }

    private Traceability getOrCreateTraceability(Session session, IProgressMonitor monitor) throws CoreException {
        ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)session, ITraceabilityStrategy.class);
        Optional<Traceability> optTraceability = traceabilityStrategy.findTraceability();
        if (!optTraceability.isPresent()) {
            monitor.subTask(Messages.Migrate_Perseus_Model_InitializeTraceability);
            optTraceability = Optional.of(traceabilityStrategy.createTraceability(monitor));
        }
        Traceability traceability = (Traceability)optTraceability.get();
        return traceability;
    }

    public void notifyAddSession(Session newSession) {
        this.migrateIfNecessary(newSession);
    }

    public void notifyRemoveSession(Session removedSession) {
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }

    public void notify(Session updated, int notification) {
    }
}

