/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.compatibility;

import fr.obeo.perseus.client.util.ModelURI;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SelectPerseusModelURIDialog
extends MessageDialog {
    private List<ModelURI> modelURIs;
    private ModelURI selection;

    public SelectPerseusModelURIDialog(Shell parentShell, String dialogTitle, String dialogMessage) {
        super(parentShell, dialogTitle, Display.getCurrent().getSystemImage(8), dialogMessage, 2, 0, new String[]{IDialogConstants.OK_LABEL});
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setModelURIs(List<ModelURI> modelURIs) {
        this.modelURIs = modelURIs;
        this.selection = modelURIs.get(0);
    }

    public ModelURI getSelection() {
        return this.selection;
    }

    protected Control createCustomArea(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 2560);
        sc.setBackground(Display.getCurrent().getSystemColor(1));
        sc.setBackgroundMode(2);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 200;
        sc.setLayoutData((Object)layoutData);
        Composite composite = new Composite((Composite)sc, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        sc.setContent((Control)composite);
        for (ModelURI modelURI : this.modelURIs) {
            this.createModelURICard(composite, modelURI);
        }
        composite.setSize(composite.computeSize(-1, -1));
        return sc;
    }

    private void createModelURICard(Composite parent, final ModelURI modelURI) {
        Button radioButton = new Button(parent, 16);
        radioButton.setSelection(modelURI.equals(this.selection));
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                SelectPerseusModelURIDialog.this.selection = modelURI;
            }
        });
        Link link = new Link(parent, 0);
        link.setText("<a>" + modelURI.toString() + "</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(event.text));
                }
                catch (MalformedURLException | PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

