/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import fr.obeo.perseus.client.dto.PNameDeserializer;
import java.io.Serializable;
import java.util.Objects;

@JsonSerialize(using=ToStringSerializer.class)
@JsonDeserialize(using=PNameDeserializer.class)
public final class PName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String pName;
    private final int idx;

    private PName(String pName) {
        this.pName = pName;
        this.idx = pName.indexOf(58);
        if (this.idx <= 0 || this.idx >= pName.length() - 1) {
            throw new IllegalArgumentException();
        }
    }

    public static PName of(String pName) {
        return new PName(pName);
    }

    public static PName of(String prefix, String name) {
        return new PName(String.valueOf(prefix) + ':' + name);
    }

    public String getPrefix() {
        return this.pName.substring(0, this.idx);
    }

    public String getName() {
        return this.pName.substring(this.idx + 1);
    }

    public int hashCode() {
        return Objects.hash(this.pName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PName other = (PName)obj;
        return Objects.equals(this.pName, other.pName);
    }

    public String toString() {
        return this.pName;
    }
}

