/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import fr.obeo.perseus.client.dto.PName;
import fr.obeo.perseus.client.dto.RefNameDeserializer;
import java.io.Serializable;
import java.util.Objects;

@JsonSerialize(using=ToStringSerializer.class)
@JsonDeserialize(using=RefNameDeserializer.class)
public final class RefName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String first;
    private final String second;
    private final String third;

    private RefName(String refName) {
        int idx1 = refName.indexOf(58);
        if (idx1 < 1 || idx1 > refName.length() - 4) {
            throw new IllegalArgumentException();
        }
        int idx2 = refName.indexOf(58, idx1 + 2);
        if (idx2 < 0 || idx2 > refName.length() - 2) {
            throw new IllegalArgumentException();
        }
        this.first = refName.substring(0, idx1);
        this.second = refName.substring(idx1 + 1, idx2);
        this.third = refName.substring(idx2 + 1);
    }

    private RefName(String first, String second, String third) {
        if (first == null || second == null || third == null) {
            throw new IllegalArgumentException();
        }
        if (first.isEmpty() || second.isEmpty() || third.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static RefName of(String refName) {
        return new RefName(refName);
    }

    public static RefName of(PName classifierName, String third) {
        return new RefName(classifierName.getPrefix(), classifierName.getName(), third);
    }

    public static RefName of(String first, String second, String third) {
        return new RefName(first, second, third);
    }

    public PName getClassifierPName() {
        return PName.of(this.first, this.second);
    }

    public String getPrefix() {
        return this.first;
    }

    public String getMiddleName() {
        return this.second;
    }

    public String getName() {
        return this.third;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefName other = (RefName)obj;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second) && Objects.equals(this.third, other.third);
    }

    public String toString() {
        return String.valueOf(this.first) + ':' + this.second + ':' + this.third;
    }
}

