/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.dto;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public class URIRef {
    private final URI uri;
    private final String prefix;
    private final String localName;

    public URIRef(URI uri) {
        this.uri = Objects.requireNonNull(uri);
        this.localName = Optional.ofNullable(uri.getFragment()).orElseGet(() -> {
            String[] split = uri.getPath().split("/");
            return split[split.length - 1];
        });
        String uriStr = uri.toString();
        this.prefix = uriStr.substring(0, uriStr.length() - this.localName.length());
    }

    public URIRef(String prefix, String localName) {
        this.localName = Objects.requireNonNull(localName);
        this.prefix = Objects.requireNonNull(prefix);
        if (!prefix.endsWith("/") && !prefix.endsWith("#")) {
            throw new IllegalArgumentException("The NsURI prefix of a URI Reference must end with a slash '/' or a hash sign '#'");
        }
        this.uri = URI.create(String.valueOf(prefix) + localName);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }
}

