/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.dto.digest;

import fr.obeo.perseus.client.dto.IMetamodelVisitor;
import fr.obeo.perseus.client.dto.PName;
import fr.obeo.perseus.client.dto.RefName;
import fr.obeo.perseus.client.dto.meta.MAttributeDTO;
import fr.obeo.perseus.client.dto.meta.MDataTypeDTO;
import fr.obeo.perseus.client.dto.meta.MEnumDTO;
import fr.obeo.perseus.client.dto.meta.MEnumLiteralDTO;
import fr.obeo.perseus.client.dto.meta.MReferenceDTO;
import fr.obeo.perseus.client.dto.meta.MetaclassDTO;
import fr.obeo.perseus.client.dto.meta.MetamodelDTO;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class MetamodelDigest
implements IMetamodelVisitor {
    private MessageDigest md;
    private final Map<String, String> mmMappings;
    private String hash;

    public MetamodelDigest(Map<String, String> mmMappings) {
        this.mmMappings = Collections.unmodifiableMap(new HashMap<String, String>(Objects.requireNonNull(mmMappings)));
        HashSet<String> mmURIs = new HashSet<String>();
        for (String mmURI : mmMappings.values()) {
            if (mmURI != null && mmURIs.add(mmURI)) continue;
            throw new IllegalArgumentException("Duplicate NsURI: " + mmURI);
        }
    }

    public void init() {
        this.hash = null;
        try {
            this.md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void visit(MetamodelDTO metamodelDTO) {
        this.md.update(metamodelDTO.getUri().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void visit(MetaclassDTO dto, String name) {
        this.update("$Metaclass");
        this.update(name);
        this.update(dto.isAbstract());
        this.update(dto.isInterface());
        this.update("$superClasses[");
        for (PName superClass : dto.getSuperClasses()) {
            this.update(superClass);
        }
        this.update("]");
    }

    @Override
    public void visit(MDataTypeDTO dto, String name) {
        this.update("$MDataType");
        this.md.update(name.getBytes(StandardCharsets.UTF_8));
        this.update(dto.isSerializable());
    }

    @Override
    public void visit(MEnumDTO dto, String name) {
        this.update("$MEnum");
        this.md.update(name.getBytes(StandardCharsets.UTF_8));
        this.update(dto.isSerializable());
    }

    @Override
    public void visit(MAttributeDTO dto, String name) {
        this.update("$MAttribute");
        this.update(name);
        if (dto.getType() == null) {
            throw new IllegalArgumentException("Missing type of attribute " + name);
        }
        this.update(dto.getType());
        this.update(dto.isDerived());
        this.update(dto.isMany());
        this.update(dto.isOrdered());
        this.update(dto.isRequired());
        this.update(dto.isUnique());
        this.update(dto.getLowerBound());
        this.update(dto.getUpperBound());
    }

    @Override
    public void visit(MReferenceDTO dto, String name) {
        this.update("$MReference");
        this.update(name);
        if (dto.getType() == null) {
            throw new IllegalArgumentException("Missing type of reference " + name);
        }
        this.update(dto.getType());
        this.update(dto.isDerived());
        this.update(dto.isMany());
        this.update(dto.isOrdered());
        this.update(dto.isRequired());
        this.update(dto.isUnique());
        this.update(dto.getLowerBound());
        this.update(dto.getUpperBound());
        this.update(dto.isContainer());
        this.update(dto.isContainment());
        if (dto.getOpposite() != null) {
            this.update("$opposite{");
            this.update(dto.getOpposite());
            this.update("}");
        }
    }

    @Override
    public void visit(MEnumLiteralDTO dto) {
        this.update("$MEnumLiteral");
        this.update(dto.getLiteral());
        this.update(dto.getValue());
    }

    private void update(PName pname) {
        if (!this.mmMappings.containsKey(pname.getPrefix())) {
            throw new IllegalArgumentException(String.format("Undefined prefix for PName '%s'", pname));
        }
        String mmURI = this.mmMappings.get(pname.getPrefix());
        this.update(String.valueOf('{') + mmURI + ':' + pname.getName() + '}');
    }

    private void update(RefName refname) {
        if (!this.mmMappings.containsKey(refname.getPrefix())) {
            throw new IllegalArgumentException(String.format("Undefined prefix for RefName '%s'", refname));
        }
        String mmURI = this.mmMappings.get(refname.getPrefix());
        this.update(String.valueOf('{') + mmURI + ':' + refname.getMiddleName() + ':' + refname.getName() + '}');
    }

    private void update(String str) {
        this.md.update(str.getBytes(StandardCharsets.UTF_8));
    }

    private void update(int val) {
        this.update(Integer.toHexString(val));
    }

    private void update(boolean bool) {
        if (bool) {
            this.md.update((byte)1);
        } else {
            this.md.update((byte)0);
        }
    }

    public String getHash() {
        if (this.hash == null) {
            this.hash = MetamodelDigest.bytesToHex(this.md.digest());
        }
        return this.hash;
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hex = new StringBuilder();
        int i = 0;
        while (i < hash.length) {
            String hs = Integer.toHexString(0xFF & hash[i]);
            if (hs.length() == 1) {
                hex.append('0');
            }
            hex.append(hs);
            ++i;
        }
        return hex.toString();
    }
}

