/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.dto.meta;

import com.fasterxml.jackson.annotation.JsonFormat;
import fr.obeo.perseus.client.dto.IMetamodelVisitor;
import fr.obeo.perseus.client.dto.meta.MClassifierDTO;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MetamodelDTO {
    private long id;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Instant createdOn;
    private String uri;
    private String name;
    private String nsPrefix;
    private String hash;
    private Map<String, String> mappings;
    private Map<String, MClassifierDTO> classifiers;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Instant getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Instant createdOn) {
        this.createdOn = createdOn;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNsPrefix() {
        return this.nsPrefix;
    }

    public void setNsPrefix(String nsPrefix) {
        this.nsPrefix = nsPrefix;
    }

    public Map<String, String> getMappings() {
        if (this.mappings == null) {
            this.mappings = new LinkedHashMap<String, String>();
        }
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Map<String, MClassifierDTO> getClassifiers() {
        if (this.classifiers == null) {
            this.classifiers = new LinkedHashMap<String, MClassifierDTO>();
        }
        return this.classifiers;
    }

    public void setClassifiers(Map<String, MClassifierDTO> metaclasses) {
        this.classifiers = metaclasses;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void accept(IMetamodelVisitor visitor) {
        visitor.visit(this);
        ArrayList<String> keys = new ArrayList<String>(this.getClassifiers().keySet());
        keys.sort(Comparator.naturalOrder());
        for (String key : keys) {
            this.getClassifiers().get(key).accept(visitor, key);
        }
    }
}

