/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl;

import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.perseus.client.Messages;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.dto.model.ImageDTO;
import fr.obeo.perseus.client.dto.model.ImageMapAreaDTO;
import fr.obeo.perseus.client.impl.ConvertedRepresentation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.command.FileModificationValidator;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.image.PartPositionInfo;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.SVGImageConverter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.part.DiagramEditPartService;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusDiagramSVGGenerator;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DRepresentationConverter {
    private final File imageFolder;
    private final Session session;
    private final IModelTranslationScope translationScope;
    private final boolean refreshRepresentations;

    public DRepresentationConverter(File imageFolder, Session session, IModelTranslationScope translationScope, boolean refreshRepresentations) {
        this.imageFolder = Objects.requireNonNull(imageFolder);
        Assert.isLegal((boolean)imageFolder.exists());
        Assert.isLegal((boolean)imageFolder.isDirectory());
        this.session = Objects.requireNonNull(session);
        this.translationScope = Objects.requireNonNull(translationScope);
        this.refreshRepresentations = refreshRepresentations;
    }

    public ConvertedRepresentation convert(final DDiagram diagram, IProgressMonitor monitor) {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.refreshRepresentations) {
            TransactionalEditingDomain editingDomain = this.session.getTransactionalEditingDomain();
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    DialectManager.INSTANCE.refresh((DRepresentation)diagram, false, (IProgressMonitor)progress.split(50));
                }
            });
        }
        progress.setWorkRemaining(50);
        String imageName = diagram.getUid();
        File imageFile = new File(this.imageFolder, String.valueOf(imageName) + ".jpg");
        imageFile.deleteOnExit();
        ImageDTO imageDTO = this.exportDiagramAndReturnImageMap(diagram, imageFile, (IProgressMonitor)progress.split(50));
        return new ConvertedRepresentation(imageFile, imageDTO);
    }

    private ImageDTO exportDiagramAndReturnImageMap(DDiagram diagram, File imageFile, IProgressMonitor monitor) {
        Path path = new Path(imageFile.getAbsolutePath());
        Diagram gmfDiagram = this.getGmfDiagram(diagram);
        ImageDTO result = new ImageDTO();
        result.setMimeType("image/jpeg");
        final PerseusDiagramEditPartService imageUtil = new PerseusDiagramEditPartService(this.translationScope, this.session, result);
        imageUtil.setAutoScalingEnabled(false);
        TransactionalEditingDomain editingDomain = this.session.getTransactionalEditingDomain();
        final Diagram realOne = (Diagram)editingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)gmfDiagram), true);
        Runnable runnable = new Runnable((IPath)path, imageFile){
            private final /* synthetic */ IPath val$path;
            private final /* synthetic */ File val$imageFile;
            {
                this.val$path = iPath;
                this.val$imageFile = file;
            }

            @Override
            public void run() {
                try {
                    imageUtil.copyToImage(realOne, this.val$path, ImageFileFormat.JPEG, (IProgressMonitor)new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
                }
                catch (SizeTooLargeException e) {
                    Status message = new Status(4, "fr.obeo.perseus.client", String.format(Messages.DRepresentationConverter_TooLarge, realOne.getName()), (Throwable)e);
                    PerseusClientPlugin.getPlugin().getLog().log((IStatus)message);
                    this.exportHardcodedImage(this.val$imageFile, "TooLarge.jpeg");
                }
                catch (Exception e) {
                    Status message = new Status(4, "fr.obeo.perseus.client", String.format(Messages.DRepresentationConverter_ExportFailed, realOne.getName(), e.getMessage()), (Throwable)e);
                    PerseusClientPlugin.getPlugin().getLog().log((IStatus)message);
                    this.exportHardcodedImage(this.val$imageFile, "ExportFailed.jpeg");
                }
            }

            private void exportHardcodedImage(File imageFile, String hardcodedFilePath) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(hardcodedFilePath);){
                        Files.copy(is, imageFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e1) {
                    Status st2 = new Status(4, "fr.obeo.perseus.client", e1.getMessage(), (Throwable)e1);
                    PerseusClientPlugin.getPlugin().getLog().log((IStatus)st2);
                }
            }
        };
        Display.getDefault().syncExec(runnable);
        return result;
    }

    private Diagram getGmfDiagram(DDiagram diagram) {
        for (AnnotationEntry annotation : new DDiagramQuery(diagram).getAnnotation("GMF_DIAGRAMS")) {
            Diagram diagramInResource;
            EObject semanticElement;
            EObject eObject = annotation.getData();
            if (!(eObject instanceof Diagram) || !(semanticElement = ViewUtil.resolveSemanticElement((View)(diagramInResource = (Diagram)eObject))).equals(diagram)) continue;
            return diagramInResource;
        }
        return null;
    }

    private static class PerseusDiagramEditPartService
    extends DiagramEditPartService {
        private static final String SHARP = "#";
        private final IModelTranslationScope translationScope;
        private final Session session;
        private final ImageDTO imageDTO;

        PerseusDiagramEditPartService(IModelTranslationScope translationScope, Session session, ImageDTO imageDTO) {
            this.translationScope = Objects.requireNonNull(translationScope);
            this.session = Objects.requireNonNull(session);
            this.imageDTO = Objects.requireNonNull(imageDTO);
        }

        public byte[] copyToImageByteArray(DiagramEditPart diagramEP, List editParts, int maxWidth, int maxHeight, ImageFileFormat format, IProgressMonitor monitor, boolean useMargins) throws CoreException {
            Assert.isNotNull((Object)diagramEP);
            byte[] result = null;
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    DiagramGenerator gen = this.getDiagramGenerator(diagramEP, format);
                    List safeParts = editParts;
                    if (safeParts == null || safeParts.isEmpty()) {
                        safeParts = diagramEP.getPrimaryEditParts();
                    }
                    if (format.equals((Object)ImageFileFormat.SVG) || format.equals((Object)ImageFileFormat.PDF)) {
                        gen.createConstrainedSWTImageDecriptorForParts(safeParts, maxWidth, maxHeight, useMargins);
                        monitor.worked(1);
                        this.saveToOutputStream((OutputStream)stream, (SiriusDiagramSVGGenerator)gen, format, monitor);
                    } else {
                        Image image = gen.createConstrainedSWTImageDecriptorForParts(safeParts, maxWidth, maxHeight, useMargins).createImage();
                        monitor.worked(1);
                        this.saveToOutputStream((OutputStream)stream, image, format, monitor);
                        image.dispose();
                    }
                    result = stream.toByteArray();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "fr.obeo.perseus.client", e.getMessage(), (Throwable)e));
            }
            monitor.worked(1);
            return result;
        }

        public List copyToImage(Diagram diagram, IPath destination, ImageFileFormat format, IProgressMonitor monitor, PreferencesHint preferencesHint) throws CoreException {
            Trace.trace((Plugin)DiagramUIRenderPlugin.getInstance(), (String)("Copy diagram to Image " + destination + " as " + format));
            List partInfo = Collections.EMPTY_LIST;
            Shell shell = new Shell();
            try {
                DiagramEditPart diagramEditPart = this.createDiagramEditPart(diagram, shell, preferencesHint);
                Assert.isNotNull((Object)diagramEditPart);
                DiagramGenerator generator = this.copyToImage(diagramEditPart, destination, format, monitor);
                partInfo = generator.getDiagramPartInfo(diagramEditPart);
                EditPartViewer viewer = diagramEditPart.getViewer();
                viewer.flush();
                Map registry = viewer.getEditPartRegistry();
                LinkedHashMap<String, ImageMapAreaDTO> areas = new LinkedHashMap<String, ImageMapAreaDTO>();
                for (PartPositionInfo part : partInfo) {
                    EObject semanticElement = part.getSemanticElement();
                    if (semanticElement instanceof DEdge) {
                        GraphicalEditPart gep;
                        View edgeView = part.getView();
                        if (edgeView == null || !this.edgeHasCenterLabel(edgeView, registry) || !((gep = (GraphicalEditPart)registry.get(edgeView)) instanceof DEdgeNameEditPart)) continue;
                        ImageMapAreaDTO area = this.createArea(part.getSemanticElement(), part.getPartX(), part.getPartY(), part.getPartWidth(), part.getPartHeight());
                        this.addArea(area, areas);
                        continue;
                    }
                    if (!(semanticElement instanceof DDiagramElement) && !(semanticElement instanceof DRepresentationDescriptor)) continue;
                    ImageMapAreaDTO area = this.createArea(part.getSemanticElement(), part.getPartX(), part.getPartY(), part.getPartWidth(), part.getPartHeight());
                    this.addArea(area, areas);
                }
                this.imageDTO.setImageMap(new ArrayList<ImageMapAreaDTO>(areas.values()));
            }
            finally {
                shell.dispose();
            }
            return partInfo;
        }

        private void saveToOutputStream(OutputStream stream, SiriusDiagramSVGGenerator generator, ImageFileFormat format, IProgressMonitor monitor) throws CoreException {
            if (format == ImageFileFormat.PDF) {
                SVGImageConverter.exportToPDF((SVGImage)((SVGImage)generator.getRenderedImage()), (OutputStream)stream);
            } else if (format == ImageFileFormat.SVG) {
                generator.stream(stream);
            } else {
                throw new IllegalArgumentException("Unexpected format: " + format.getName());
            }
            monitor.worked(1);
        }

        protected void saveToFile(IPath destination, Image image, ImageFileFormat imageFormat, IProgressMonitor monitor) throws CoreException {
            IStatus fileModificationStatus = this.createFile(destination);
            if (!fileModificationStatus.isOK()) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileOutputStream stream = new FileOutputStream(destination.toOSString());){
                    this.saveToOutputStream((OutputStream)stream, image, imageFormat, monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "exportToFile", e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            this.refreshLocal(destination);
        }

        private void saveToOutputStream(OutputStream stream, Image image, ImageFileFormat imageFormat, IProgressMonitor monitor) {
            monitor.worked(1);
            ImageData imageData = image.getImageData();
            if (imageFormat.equals((Object)ImageFileFormat.GIF)) {
                imageData = this.createImageData(image);
            }
            monitor.worked(1);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{imageData};
            imageLoader.logicalScreenHeight = image.getBounds().width;
            imageLoader.logicalScreenHeight = image.getBounds().height;
            if (ImageFileFormat.JPEG.equals((Object)imageFormat) || ImageFileFormat.JPG.equals((Object)imageFormat)) {
                imageLoader.compression = 90;
            }
            imageLoader.save(stream, imageFormat.getOrdinal());
            monitor.worked(1);
        }

        private ImageData createImageData(Image image) {
            ImageData imageData = image.getImageData();
            if (imageData.depth <= 8) {
                return imageData;
            }
            ImageData newImageData = this.get8BitPaletteImageData(imageData);
            if (newImageData == null) {
                newImageData = this.getWebSafePaletteImageData(imageData);
            }
            return newImageData;
        }

        private IStatus createFile(IPath destination) throws CoreException {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
            if (file != null && !file.exists()) {
                File osFile = new File(destination.toOSString());
                if (osFile.exists()) {
                    file.refreshLocal(0, null);
                } else {
                    ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                    ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
                    file.create((InputStream)input, false, null);
                }
            }
            if (file != null) {
                return FileModificationValidator.approveFileModification((IFile[])new IFile[]{file});
            }
            return Status.OK_STATUS;
        }

        private ImageData get8BitPaletteImageData(ImageData imageData) {
            PaletteData palette = imageData.palette;
            RGB[] colours = new RGB[256];
            PaletteData newPaletteData = new PaletteData(colours);
            ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
            int lastPixel = -1;
            int newPixel = -1;
            int i = 0;
            while (i < imageData.width) {
                int j = 0;
                while (j < imageData.height) {
                    int pixel = imageData.getPixel(i, j);
                    if (pixel != lastPixel) {
                        lastPixel = pixel;
                        RGB colour = palette.getRGB(pixel);
                        newPixel = 0;
                        while (newPixel < 256) {
                            if (colours[newPixel] == null) {
                                colours[newPixel] = colour;
                                break;
                            }
                            if (colours[newPixel].equals((Object)colour)) break;
                            ++newPixel;
                        }
                        if (newPixel >= 256) {
                            return null;
                        }
                    }
                    newImageData.setPixel(i, j, newPixel);
                    ++j;
                }
                ++i;
            }
            RGB colour = new RGB(0, 0, 0);
            int k = 0;
            while (k < 256) {
                if (colours[k] == null) {
                    colours[k] = colour;
                }
                ++k;
            }
            return newImageData;
        }

        private ImageData getWebSafePaletteImageData(ImageData imageData) {
            PaletteData palette = imageData.palette;
            RGB[] webSafePallette = this.getWebSafePalette();
            PaletteData newPaletteData = new PaletteData(webSafePallette);
            ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
            int lastPixel = -1;
            int newPixel = -1;
            int i = 0;
            while (i < imageData.width) {
                int j = 0;
                while (j < imageData.height) {
                    int pixel = imageData.getPixel(i, j);
                    if (pixel != lastPixel) {
                        lastPixel = pixel;
                        RGB colour = palette.getRGB(pixel);
                        RGB webSafeColour = this.getWebSafeColour(colour);
                        newPixel = 0;
                        while (newPixel < 256) {
                            if (webSafePallette[newPixel].equals((Object)webSafeColour)) break;
                            ++newPixel;
                        }
                        Assert.isTrue((newPixel < 216 ? 1 : 0) != 0);
                    }
                    newImageData.setPixel(i, j, newPixel);
                    ++j;
                }
                ++i;
            }
            return newImageData;
        }

        private RGB getWebSafeColour(RGB colour) {
            int red = Math.round((colour.red + 25) / 51) * 51;
            int green = Math.round((colour.green + 25) / 51) * 51;
            int blue = Math.round((colour.blue + 25) / 51) * 51;
            return new RGB(red, green, blue);
        }

        private RGB[] getWebSafePalette() {
            RGB[] colours = new RGB[256];
            int i = 0;
            int red = 0;
            while (red <= 255) {
                int green = 0;
                while (green <= 255) {
                    int blue = 0;
                    while (blue <= 255) {
                        RGB colour = new RGB(red, green, blue);
                        colours[i++] = colour;
                        blue += 51;
                    }
                    green += 51;
                }
                red += 51;
            }
            RGB colour = new RGB(0, 0, 0);
            int k = 0;
            while (k < 256) {
                if (colours[k] == null) {
                    colours[k] = colour;
                }
                ++k;
            }
            return colours;
        }

        private void refreshLocal(IPath destination) throws CoreException {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(destination);
            if (file != null) {
                file.refreshLocal(0, null);
            }
        }

        private boolean edgeHasCenterLabel(View view, Map<?, ?> registry) {
            EObject element = view.getElement();
            if (element instanceof DEdge) {
                String name = ((DEdge)element).getName();
                return name != null && name.trim().length() > 0;
            }
            return false;
        }

        private ImageMapAreaDTO createArea(EObject semanticElement, int x, int y, int width, int height) {
            ImageMapAreaDTO area = new ImageMapAreaDTO();
            area.setShape(ImageMapAreaDTO.Shape.RECT);
            area.setCoords(new int[]{x, y, x + width, y + height});
            area.getUris().addAll(this.getTargetURIs(semanticElement));
            return area;
        }

        private void addArea(ImageMapAreaDTO area, Map<String, ImageMapAreaDTO> areas) {
            if (area != null) {
                String coordsAsString = String.valueOf(Arrays.stream(area.getCoords()).boxed().collect(Collectors.toList()));
                if (areas.containsKey(coordsAsString)) {
                    ImageMapAreaDTO existing = areas.get(coordsAsString);
                    HashSet<URI> mergedUris = new HashSet<URI>(existing.getUris());
                    mergedUris.addAll(area.getUris());
                    existing.setUris(new ArrayList<URI>(mergedUris));
                } else {
                    areas.put(coordsAsString, area);
                }
            }
        }

        private List<URI> getTargetURIs(EObject semanticElement) {
            ArrayList<URI> uris = new ArrayList<URI>();
            if (semanticElement instanceof DDiagramElement) {
                DDiagramElement element = (DDiagramElement)semanticElement;
                element.getSemanticElements().stream().forEach(elt -> {
                    if (this.translationScope.isInModel((EObject)elt)) {
                        uris.add(URI.create(SHARP + this.translationScope.getId((EObject)elt)));
                    } else if (elt instanceof IArtifact) {
                        IArtifact artifact = (IArtifact)elt;
                        uris.add(URI.create(artifact.getUrl()));
                    }
                    DialectManager.INSTANCE.getRepresentationDescriptors(elt, this.session).stream().forEach(representationDescriptor -> {
                        if (this.translationScope.isInModel((EObject)representationDescriptor)) {
                            uris.add(URI.create(SHARP + this.translationScope.getId((EObject)representationDescriptor)));
                        }
                    });
                });
            } else if (semanticElement instanceof DRepresentationDescriptor && this.translationScope.isInModel(semanticElement)) {
                uris.add(URI.create(SHARP + this.translationScope.getId(semanticElement)));
            }
            return uris;
        }
    }
}

