/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import fr.obeo.perseus.client.Messages;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IArtifactID;
import fr.obeo.perseus.client.api.IOslcDataFetcher;
import fr.obeo.perseus.client.api.IPerseusDataFetcher;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.IProjectSearchParams;
import fr.obeo.perseus.client.api.PageInfo;
import fr.obeo.perseus.client.api.PerseusAuthException;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.api.SearchWindow;
import fr.obeo.perseus.client.dto.ProjectRefDTO;
import fr.obeo.perseus.client.dto.model.ModelDTO;
import fr.obeo.perseus.client.impl.graphql.GQLJob;
import fr.obeo.perseus.client.impl.graphql.GQLOAuthFriend;
import fr.obeo.perseus.client.impl.graphql.GQLOslcArtifactDescriptor;
import fr.obeo.perseus.client.impl.graphql.GQLOslcConfiguration;
import fr.obeo.perseus.client.impl.graphql.GQLOslcLinkDescriptorsByFriend;
import fr.obeo.perseus.client.impl.graphql.ProjectAccessLevel;
import fr.obeo.perseus.client.impl.graphql.QueryAvailableModels;
import fr.obeo.perseus.client.impl.graphql.QueryAvailableProjects;
import fr.obeo.perseus.client.impl.graphql.QueryJobById;
import fr.obeo.perseus.client.impl.graphql.QueryModelAssignedGlobalConf;
import fr.obeo.perseus.client.impl.graphql.QueryModelById;
import fr.obeo.perseus.client.impl.graphql.QueryModelOslcLinks;
import fr.obeo.perseus.client.impl.graphql.QueryOAuthFriendByRootServicesURI;
import fr.obeo.perseus.client.impl.graphql.QueryOAuthFriends;
import fr.obeo.perseus.client.impl.graphql.QueryProjectArtifact;
import fr.obeo.perseus.client.impl.graphql.RefreshOslcArtifacts;
import fr.obeo.perseus.client.util.ModelURI;
import fr.obeo.perseus.client.util.PerseusHttpSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;

public class PerseusDataFetcher
implements IOslcDataFetcher,
IPerseusDataFetcher {
    private static final String NAME = "name";
    private static final String FRIEND_DESCRIPTOR = "friendDescriptor";
    private static final String MODEL = "model";
    private static final String PROJECTS = "projects";
    private static final String VIEWER = "viewer";
    private static final String DATA = "data";
    private final PerseusHttpSupport.Factory perseusHttpSupportFactory;

    public PerseusDataFetcher(PerseusHttpSupport.Factory perseusHttpSupportFactory) {
        this.perseusHttpSupportFactory = Objects.requireNonNull(perseusHttpSupportFactory);
    }

    @Override
    public SearchWindow<ProjectRefDTO> getWritableProjects(IPerseusServerConfig config, IProjectSearchParams searchParams, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        QueryAvailableProjects.QueryAvailableProjectsBuilder newQuery = QueryAvailableProjects.newQuery();
        searchParams.getProjectNameContainsParam().ifPresent(newQuery::withProjectNameContains);
        searchParams.getPageParam().ifPresent(pageParam -> newQuery.withPage(pageParam.getPageMode(), pageParam.getProjectId()));
        StringEntity entity = PerseusHttpSupport.createStringEntity(newQuery.build());
        progress.setWorkRemaining(90);
        try {
            SearchWindow<ProjectRefDTO> searchWindow;
            block13: {
                Throwable throwable = null;
                Object var9_9 = null;
                PerseusHttpSupport httpSupport = this.perseusHttpSupportFactory.create(config);
                try {
                    JsonNode tree = httpSupport.postHttpEntity(config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
                    ObjectReader projectRefReader = PerseusHttpSupport.createObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readerFor((TypeReference)new TypeReference<ProjectRefDTO>(){});
                    ObjectReader pageInfoReader = PerseusHttpSupport.createObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readerFor(PageInfo.class);
                    JsonNode projectsNode = tree.get(DATA).get(VIEWER).get(PROJECTS);
                    List projects = projectsNode.get("edges").findValues("node").stream().map(o -> {
                        try {
                            return (ProjectRefDTO)projectRefReader.readValue(o);
                        }
                        catch (IOException e) {
                            PerseusClientPlugin.getPlugin().logError("Project received from server could not be parsed", e);
                            return null;
                        }
                    }).filter(Objects::nonNull).filter(ProjectRefDTO::canWrite).collect(Collectors.toList());
                    PageInfo pageInfo = (PageInfo)pageInfoReader.readValue(projectsNode.get("pageInfo"));
                    searchWindow = new SearchWindow<ProjectRefDTO>(projects, pageInfo);
                    if (httpSupport == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (httpSupport != null) {
                            httpSupport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                httpSupport.close();
            }
            return searchWindow;
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    @Override
    public List<ModelDTO> getAvailableModels(IPerseusServerConfig config, String projectId, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringEntity entity = PerseusHttpSupport.createStringEntity(new QueryAvailableModels(projectId));
        progress.setWorkRemaining(90);
        try {
            List list;
            block13: {
                Throwable throwable = null;
                Object var7_8 = null;
                PerseusHttpSupport httpSupport = this.perseusHttpSupportFactory.create(config);
                try {
                    List result;
                    JsonNode tree = httpSupport.postHttpEntity(config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
                    JsonNode jsonNode = this.getCheckedProjectNode(projectId, tree).get("models");
                    list = result = (List)PerseusHttpSupport.createObjectMapper().readerFor((TypeReference)new TypeReference<List<ModelDTO>>(){}).readValue(jsonNode);
                    if (httpSupport == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (httpSupport != null) {
                            httpSupport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                httpSupport.close();
            }
            return list;
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    @Override
    public ModelDTO getModel(IPerseusServerConfig config, String projectId, Long modelId, ProjectAccessLevel minAccessLevel, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringEntity entity = PerseusHttpSupport.createStringEntity(new QueryModelById(projectId, modelId));
        progress.setWorkRemaining(90);
        try {
            ModelDTO modelDTO;
            block17: {
                Throwable throwable = null;
                Object var9_10 = null;
                PerseusHttpSupport httpSupport = this.perseusHttpSupportFactory.create(config);
                try {
                    ModelDTO result;
                    ProjectAccessLevel actualAccessLevel;
                    JsonNode tree = httpSupport.postHttpEntity(config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
                    JsonNode projectNode = this.getCheckedProjectNode(projectId, tree);
                    String accessLevel = projectNode.get("accessLevel").asText();
                    try {
                        actualAccessLevel = ProjectAccessLevel.valueOf(accessLevel);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        PerseusClientPlugin.getPlugin().logError("Publication server returned invalid AccessLevel value", e);
                        throw new PerseusServerException(e);
                    }
                    if (!actualAccessLevel.matches(minAccessLevel)) {
                        throw new PerseusServerException(String.format("You do not have a permission '%s' on this project. Please contact the project administrator. This may be due to your Publication account not being in the required Team, or not having the necessary license token.", new Object[]{minAccessLevel}));
                    }
                    JsonNode modelNode = projectNode.get(MODEL);
                    if (modelNode.isNull()) {
                        throw new PerseusServerException(String.format("The model with id '%s' does not exist or is not accessible by the current user.", modelId));
                    }
                    modelDTO = result = (ModelDTO)PerseusHttpSupport.createObjectMapper().readerFor(ModelDTO.class).readValue(modelNode);
                    if (httpSupport == null) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (httpSupport != null) {
                            httpSupport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                httpSupport.close();
            }
            return modelDTO;
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    @Override
    public GQLJob getJob(IPerseusServerConfig config, long jobId, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringEntity entity = PerseusHttpSupport.createStringEntity(new QueryJobById(jobId));
        progress.setWorkRemaining(90);
        try {
            GQLJob gQLJob;
            block14: {
                Throwable throwable = null;
                Object var8_8 = null;
                PerseusHttpSupport httpSupport = this.perseusHttpSupportFactory.create(config);
                try {
                    JsonNode tree = httpSupport.postHttpEntity(config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
                    JsonNode jsonNode = tree.get(DATA).get(VIEWER).get("job");
                    if (jsonNode.isNull()) {
                        throw new PerseusServerException(String.format("The job with id '%d' does not exist or is not accessible by the current user.", jobId));
                    }
                    gQLJob = (GQLJob)PerseusHttpSupport.createObjectMapper().readerFor(GQLJob.class).readValue(jsonNode);
                    if (httpSupport == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        if (httpSupport != null) {
                            httpSupport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                httpSupport.close();
            }
            return gQLJob;
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    @Override
    public GQLOslcArtifactDescriptor getOslcArtifactDescriptor(IPerseusServerConfig config, String projectId, IArtifactID artifactID, Optional<String> optConfigurationUri, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        QueryProjectArtifact.QueryProjectArtifactBuilder queryBuilder = QueryProjectArtifact.newQueryProjectArtifact().projectId(projectId).artifactUrl(artifactID.getArtifactURL());
        optConfigurationUri.ifPresent(configurationUri -> {
            QueryProjectArtifact.QueryProjectArtifactBuilder queryProjectArtifactBuilder2 = queryBuilder.configurationUri((String)configurationUri);
        });
        StringEntity entity = PerseusHttpSupport.createStringEntity(queryBuilder.build());
        progress.setWorkRemaining(90);
        try {
            GQLOslcArtifactDescriptor gQLOslcArtifactDescriptor;
            block13: {
                Throwable throwable = null;
                Object var10_11 = null;
                PerseusHttpSupport httpSupport = this.perseusHttpSupportFactory.create(config);
                try {
                    GQLOslcArtifactDescriptor result;
                    JsonNode tree = httpSupport.postHttpEntity(config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
                    JsonNode node = this.getCheckedProjectNode(projectId, tree).get("oslcArtifactDescriptor");
                    gQLOslcArtifactDescriptor = result = (GQLOslcArtifactDescriptor)PerseusHttpSupport.createObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readerFor(GQLOslcArtifactDescriptor.class).readValue(node);
                    if (httpSupport == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (httpSupport != null) {
                            httpSupport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                httpSupport.close();
            }
            return gQLOslcArtifactDescriptor;
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    @Override
    public Collection<GQLOslcLinkDescriptorsByFriend> getOslcLinkDescriptors(IPerseusServerConfig config, String projectId, Long modelId, List<String> friendURLs, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringEntity entity = PerseusHttpSupport.createStringEntity(new QueryModelOslcLinks(projectId, modelId, friendURLs));
        progress.setWorkRemaining(90);
        try {
            Collection collection;
            block13: {
                Throwable throwable = null;
                Object var9_10 = null;
                PerseusHttpSupport httpSupport = this.perseusHttpSupportFactory.create(config);
                try {
                    Collection result;
                    JsonNode tree = httpSupport.postHttpEntity(config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
                    JsonNode jsonNode = this.getCheckedProjectNode(projectId, tree).get(MODEL).get("linkDescriptorsByFriend");
                    collection = result = (Collection)PerseusHttpSupport.createObjectMapper().readerFor((TypeReference)new TypeReference<Collection<GQLOslcLinkDescriptorsByFriend>>(){}).readValue(jsonNode);
                    if (httpSupport == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (httpSupport != null) {
                            httpSupport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                httpSupport.close();
            }
            return collection;
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    @Override
    public List<GQLOAuthFriend> getOAuthFriends(IPerseusServerConfig config, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringEntity entity = PerseusHttpSupport.createStringEntity(new QueryOAuthFriends());
        progress.setWorkRemaining(90);
        try {
            List list;
            block13: {
                Throwable throwable = null;
                Object var6_7 = null;
                PerseusHttpSupport httpSupport = this.perseusHttpSupportFactory.create(config);
                try {
                    List result;
                    JsonNode tree = httpSupport.postHttpEntity(config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
                    JsonNode jsonNode = tree.get(DATA).get(VIEWER).get("oauthFriends");
                    list = result = (List)PerseusHttpSupport.createObjectMapper().readerFor((TypeReference)new TypeReference<List<GQLOAuthFriend>>(){}).readValue(jsonNode);
                    if (httpSupport == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        if (httpSupport != null) {
                            httpSupport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                httpSupport.close();
            }
            return list;
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    @Override
    public GQLOAuthFriend getOAuthFriend(IPerseusServerConfig config, String rootServicesURI, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringEntity entity = PerseusHttpSupport.createStringEntity(new QueryOAuthFriendByRootServicesURI(rootServicesURI));
        progress.setWorkRemaining(90);
        try {
            GQLOAuthFriend gQLOAuthFriend;
            block14: {
                Throwable throwable = null;
                Object var7_8 = null;
                PerseusHttpSupport httpSupport = this.perseusHttpSupportFactory.create(config);
                try {
                    JsonNode tree = httpSupport.postHttpEntity(config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
                    JsonNode jsonNode = tree.get(DATA).get(VIEWER).get("oauthFriendByRootServicesURI");
                    if (jsonNode.isNull()) {
                        throw new PerseusServerException(String.format("The friend with url '%s' does not exist or is not accessible by the current user.", rootServicesURI));
                    }
                    gQLOAuthFriend = (GQLOAuthFriend)PerseusHttpSupport.createObjectMapper().readerFor(GQLOAuthFriend.class).readValue(jsonNode);
                    if (httpSupport == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        if (httpSupport != null) {
                            httpSupport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                httpSupport.close();
            }
            return gQLOAuthFriend;
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    @Override
    public List<GQLOslcArtifactDescriptor> refreshOslcArtifactDescriptors(IPerseusServerConfig config, String projectId, Collection<String> artifactUrls, Optional<String> optConfigurationUri, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringEntity entity = PerseusHttpSupport.createStringEntity(new RefreshOslcArtifacts(artifactUrls, projectId, optConfigurationUri));
        progress.setWorkRemaining(90);
        Throwable throwable = null;
        Object var9_10 = null;
        try (PerseusHttpSupport httpSupport = this.perseusHttpSupportFactory.create(config);){
            JsonNode tree;
            block30: {
                tree = httpSupport.postHttpEntity(config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
                Optional<JsonNode> optNode = Optional.ofNullable(tree.get(DATA)).map(n -> n.get("refreshOslcArtifacts")).filter(n -> n.isObject());
                Optional<JsonNode> optTypenameNode = optNode.map(n -> n.get("__typename")).filter(n -> n.isTextual());
                if (!optTypenameNode.isPresent()) break block30;
                JsonNode typename = optTypenameNode.get();
                JsonNode refreshOslcArtifacts = optNode.get();
                switch (typename.asText()) {
                    case "RefreshOslcArtifactsSuccessPayload": {
                        JsonNode artifactDescriptors = refreshOslcArtifacts.get("artifactDescriptors");
                        List result = (List)PerseusHttpSupport.createObjectMapper().readerFor((TypeReference)new TypeReference<List<GQLOslcArtifactDescriptor>>(){}).readValue(artifactDescriptors);
                        progress.setWorkRemaining(0);
                        return result;
                    }
                    case "OAuthUserAuthorizationPayload": {
                        throw new PerseusAuthException(String.format("You must allow access to '%s'", refreshOslcArtifacts.get(FRIEND_DESCRIPTOR).get(NAME).asText()), refreshOslcArtifacts.get("userAuthorizationURL").asText());
                    }
                    case "BasicUserAuthorizationPayload": {
                        throw new PerseusAuthException(String.format("You must provide your credentials to access the friend server '%s'", refreshOslcArtifacts.get(FRIEND_DESCRIPTOR).get(NAME).asText()), config.getApiURI().resolve(String.format("../user/settings/friend/credentials?f=%s&r=%s", URI.encodeQuery((String)refreshOslcArtifacts.get(FRIEND_DESCRIPTOR).get("key").asText(), (boolean)false), URI.encodeQuery((String)refreshOslcArtifacts.get("realm").asText(), (boolean)false))).toString());
                    }
                    case "ApiKeyUserAuthorizationPayload": {
                        throw new PerseusAuthException(String.format("You must provide your API Key to access the friend server '%s'", refreshOslcArtifacts.get(FRIEND_DESCRIPTOR).get(NAME).asText()), config.getApiURI().resolve(String.format("../user/settings/friend/apikey?f=%s&h=%s", URI.encodeQuery((String)refreshOslcArtifacts.get(FRIEND_DESCRIPTOR).get("key").asText(), (boolean)false), URI.encodeQuery((String)refreshOslcArtifacts.get("hostName").asText(), (boolean)false))).toString());
                    }
                    case "ErrorPayload": {
                        if (refreshOslcArtifacts.get("message") != null) {
                            throw new IOException(refreshOslcArtifacts.get("message").asText());
                        }
                        throw new IOException(String.format(Messages.PerseusModelPublisher_MissingServerMessage, tree.toString()));
                    }
                }
            }
            throw new IOException(String.format(Messages.PerseusModelPublisher_UnexpectedFormat, tree.toString()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Optional<GQLOslcConfiguration> getModelAssignedGlobalConf(IPerseusServerConfig config, ModelURI modelURI, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringEntity entity = PerseusHttpSupport.createStringEntity(new QueryModelAssignedGlobalConf(modelURI));
        progress.setWorkRemaining(90);
        try {
            Optional<Object> optional;
            block14: {
                Throwable throwable = null;
                Object var7_8 = null;
                PerseusHttpSupport httpSupport = this.perseusHttpSupportFactory.create(config);
                try {
                    JsonNode tree = httpSupport.postHttpEntity(config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
                    JsonNode jsonNode = this.getCheckedProjectNode(modelURI.getProjectId(), tree).get(MODEL).get("assignedGlobalConf");
                    GQLOslcConfiguration res = null;
                    if (!jsonNode.isNull()) {
                        res = new GQLOslcConfiguration();
                        res.setUri(jsonNode.get("uri").asText());
                        res.setTitle(jsonNode.get("title").asText());
                        res.setFriendUrl(jsonNode.get("friendURL").asText());
                    }
                    optional = Optional.ofNullable(res);
                    if (httpSupport == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        if (httpSupport != null) {
                            httpSupport.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                httpSupport.close();
            }
            return optional;
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    private JsonNode getCheckedProjectNode(String projectId, JsonNode tree) throws PerseusServerException {
        JsonNode jsonNode = tree.get(DATA).get(VIEWER).get("project");
        if (jsonNode.isNull()) {
            throw new PerseusServerException(String.format("The project with id '%s' does not exist or is not accessible by the current user.", projectId));
        }
        return jsonNode;
    }
}

