/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.obeo.perseus.client.Messages;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.IPerseusServerModelInput;
import fr.obeo.perseus.client.api.IPerseusServerPublisher;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.InputStreamTransactionDataProvider;
import fr.obeo.perseus.client.impl.PerseusTransactionRunner;
import fr.obeo.perseus.client.impl.graphql.CreateModel;
import fr.obeo.perseus.client.impl.graphql.QueryCheckIcons;
import fr.obeo.perseus.client.impl.graphql.QueryRegisteredMetamodels;
import fr.obeo.perseus.client.impl.graphql.UploadIcons;
import fr.obeo.perseus.client.util.PerseusHttpSupport;
import fr.obeo.perseus.client.util.PerseusProperties;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class PerseusModelPublisher
implements IPerseusServerPublisher {
    public static final String PROP_MODEL_ID = "modelID";
    private static final String DATA = "data";
    private static final String PUBLISH_TYPE = "publish";
    private static final String ERROR_CONCURRENT_MM_CREATION_MSG = "ERR_CONCURRENT_MM";
    private final IPerseusServerConfig config;
    private final PerseusHttpSupport.Factory httpSupportFactory;
    private final List<IPerseusServerPublisher.PerseusPublicationListener> listeners = new ArrayList<IPerseusServerPublisher.PerseusPublicationListener>();

    public PerseusModelPublisher(IPerseusServerConfig config, PerseusHttpSupport.Factory httpSupportFactory) {
        this.config = Objects.requireNonNull(config);
        this.httpSupportFactory = Objects.requireNonNull(httpSupportFactory);
    }

    @Override
    public IStatus publish(IPerseusServerModelInput input, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PerseusHttpSupport httpSupport = this.httpSupportFactory.create(this.config);){
                return this.doPublish(input, httpSupport, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return new Status(1, "fr.obeo.perseus.client", String.format("Publication OK but an exception happened while closing the HTTP client: ", e.getMessage()), (Throwable)e);
        }
    }

    protected IStatus doPublish(IPerseusServerModelInput input, PerseusHttpSupport httpSupport, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PerseusModelPublisher_Publishing, (int)100);
        long modelId = -1L;
        MultiStatus result = new MultiStatus("fr.obeo.perseus.client", 0, null, null);
        if (input.getOperation() == IPerseusServerModelInput.ModelOperation.CREATE) {
            try {
                modelId = this.createModel(input, httpSupport, (IProgressMonitor)progress.split(10));
                this.firePublishEvent(new IPerseusServerPublisher.PublishModelCreatedEvent(modelId));
            }
            catch (OperationCanceledException e2) {
                result.add(Status.CANCEL_STATUS);
            }
            catch (PerseusServerException | IOException e) {
                result.add((IStatus)new Status(4, "fr.obeo.perseus.client", e.getMessage(), (Throwable)e));
            }
        } else {
            modelId = input.getPublishModelData().getModelId();
        }
        if (result.isOK() && modelId >= 0L) {
            IStatus mmStatus = this.doRegisterMetamodels(input, httpSupport, (IProgressMonitor)progress.split(10));
            result.add(mmStatus);
            if (result.isOK()) {
                IStatus iconStatus = this.doUploadIcons(input, httpSupport, (IProgressMonitor)progress.split(10));
                result.add(iconStatus);
                progress.setWorkRemaining(100);
                if (result.isOK()) {
                    IStatus modelStatus = this.doPublishModelData(input, httpSupport, modelId, (IProgressMonitor)progress.split(100));
                    result.add(modelStatus);
                }
            }
        }
        return result;
    }

    private IStatus doRegisterMetamodels(IPerseusServerModelInput input, PerseusHttpSupport httpSupport, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IStatus status = Status.OK_STATUS;
        try {
            this.tryRegisterRequiredMetamodels(input, httpSupport, (IProgressMonitor)progress.split(80));
        }
        catch (PerseusServerException e) {
            if (ERROR_CONCURRENT_MM_CREATION_MSG.equals(e.getMessage())) {
                try {
                    this.tryRegisterRequiredMetamodels(input, httpSupport, (IProgressMonitor)progress.split(20));
                }
                catch (OperationCanceledException e2) {
                    status = Status.CANCEL_STATUS;
                }
                catch (Exception e2) {
                    status = new Status(4, "fr.obeo.perseus.client", e.getMessage(), (Throwable)e);
                }
            } else {
                status = new Status(4, "fr.obeo.perseus.client", e.getMessage(), (Throwable)e);
            }
        }
        catch (OperationCanceledException e) {
            status = Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            status = new Status(4, "fr.obeo.perseus.client", e.getMessage(), (Throwable)e);
        }
        return status;
    }

    private IStatus doUploadIcons(IPerseusServerModelInput input, PerseusHttpSupport httpSupport, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IStatus status = Status.OK_STATUS;
        try {
            Map<String, Map<String, Object>> iconsByHash = input.getRequiredIcons((IProgressMonitor)progress.split(20));
            if (!iconsByHash.isEmpty()) {
                this.uploadMissingIcons((IProgressMonitor)progress.split(80), httpSupport, iconsByHash);
            }
        }
        catch (PerseusServerException | IOException e) {
            status = new Status(4, "fr.obeo.perseus.client", e.getMessage(), (Throwable)e);
        }
        return status;
    }

    private IStatus doPublishModelData(IPerseusServerModelInput input, PerseusHttpSupport httpSupport, long modelId, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IStatus status = Status.OK_STATUS;
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (BufferedInputStream is = new BufferedInputStream(input.getModelJsonAsInputStream((IProgressMonitor)progress.split(1)));){
                InputStreamTransactionDataProvider dataProvider = new InputStreamTransactionDataProvider(is, PUBLISH_TYPE, String.format(Messages.PerseusModelPublisher_PublishModel, input.getPublishModelData().getName()), String.valueOf(UUID.randomUUID().toString()) + ".json");
                PerseusTransactionRunner trn = new PerseusTransactionRunner(this.config, httpSupport, dataProvider);
                status = trn.run((IProgressMonitor)progress.split(99));
                if (status.isOK()) {
                    this.firePublishEvent(new IPerseusServerPublisher.PublishCompleteEvent(modelId, status, String.valueOf(trn.getJobId())));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (OperationCanceledException e) {
            status = Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            status = new Status(4, "fr.obeo.perseus.client", e.getMessage(), (Throwable)e);
        }
        return status;
    }

    private void tryRegisterRequiredMetamodels(IPerseusServerModelInput input, PerseusHttpSupport httpSupport, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Registering required meta-models", (int)100);
        Set<String> registeredHashes = this.getRegisteredMetamodelHashes(httpSupport, (IProgressMonitor)progress.split(5));
        Set<String> missingMetamodelHashes = input.getRequiredMetamodelHashes((IProgressMonitor)progress.split(80));
        missingMetamodelHashes.removeAll(registeredHashes);
        String mmAsJson = input.getMetamodelsAsJson(missingMetamodelHashes, (IProgressMonitor)progress.split(5));
        if (PerseusProperties.isDebug()) {
            try {
                Path tempFile = Files.createTempFile("pers_mm", ".json", new FileAttribute[0]);
                Files.write(tempFile, mmAsJson.getBytes(StandardCharsets.UTF_8), StandardOpenOption.DELETE_ON_CLOSE);
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", "DEBUG - JSON payload of metamodels to publish temporarily saved to file " + tempFile));
            }
            catch (Exception e) {
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", "DEBUG - Could not persis JSON payload of metamodels to publish to temporary file", (Throwable)e));
            }
        }
        if (!missingMetamodelHashes.isEmpty()) {
            StringEntity metamodelsEntity = new StringEntity(mmAsJson, ContentType.create((String)"application/json", (String)"UTF-8"));
            this.registerMetamodels(metamodelsEntity, httpSupport, (IProgressMonitor)progress.split(10));
        }
    }

    protected Set<String> getRegisteredMetamodelHashes(PerseusHttpSupport httpSupport, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        progress.subTask(Messages.PerseusServerModelPublisher_queryRegisteredMetamodels);
        try {
            JsonNode node = httpSupport.postHttpEntity(this.config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)PerseusHttpSupport.createStringEntity(new QueryRegisteredMetamodels()), (IProgressMonitor)progress.split(100));
            JsonNode viewer = node.get(DATA).get("viewer");
            JsonNode mmNode = viewer.get("metamodels");
            if (mmNode.isArray()) {
                ArrayNode mmListNode = (ArrayNode)mmNode;
                HashSet<String> result = new HashSet<String>(mmListNode.size());
                mmListNode.iterator().forEachRemaining(jn -> {
                    boolean bl = result.add(jn.findValue("hash").asText());
                });
                HashSet<String> hashSet = result;
                return hashSet;
            }
            throw new IOException(String.format(Messages.PerseusServerModelPublisher_expectedArray, new Object[0]));
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    private void registerMetamodels(StringEntity entity, PerseusHttpSupport httpSupport, IProgressMonitor monitor) throws IOException, JsonGenerationException, JsonMappingException, ClientProtocolException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PerseusServerModelPublisher_registeringMetamodels, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            JsonNode node = httpSupport.postHttpEntity(this.config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(100));
            httpSupport.checkGraphQLSuccess(node, "RegisterMetamodelsSuccessPayload");
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    private void uploadMissingIcons(IProgressMonitor monitor, PerseusHttpSupport httpSupport, Map<String, Map<String, Object>> iconsByHash) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringEntity entity = PerseusHttpSupport.createStringEntity(new QueryCheckIcons(iconsByHash.keySet()));
        progress.setWorkRemaining(90);
        try {
            JsonNode tree = httpSupport.postHttpEntity(this.config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(40));
            ArrayNode node = (ArrayNode)tree.get(DATA).get("viewer").get("checkIcons");
            List missingHashes = StreamSupport.stream(node.spliterator(), false).map(JsonNode::asText).collect(Collectors.toList());
            progress.setWorkRemaining(70);
            if (!missingHashes.isEmpty()) {
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", String.format("Uploading %s missing icons to the server", missingHashes.size())));
                List<Map<String, Object>> missingIconsData = iconsByHash.entrySet().stream().filter(entry -> missingHashes.contains(entry.getKey())).map(entry -> (Map)entry.getValue()).collect(Collectors.toList());
                entity = PerseusHttpSupport.createStringEntity(new UploadIcons(missingIconsData));
                tree = httpSupport.postHttpEntity(this.config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(50));
                httpSupport.checkGraphQLSuccess(tree, "UploadIconsSuccessPayload");
            }
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    public long createModel(IPerseusServerModelInput input, PerseusHttpSupport httpSupport, IProgressMonitor monitor) throws IOException, PerseusServerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StringEntity entity = PerseusHttpSupport.createStringEntity(new CreateModel(input.getPublishModelData().getProjectId(), input.getPublishModelData().getName()));
        progress.setWorkRemaining(90);
        try {
            long modelId;
            JsonNode tree = httpSupport.postHttpEntity(this.config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(90));
            httpSupport.checkGraphQLSuccess(tree, "CreateModelSuccessPayload");
            JsonNode jsonNode = tree.get(DATA).get("createModel").get("modelId");
            long l = modelId = jsonNode.asLong();
            return l;
        }
        finally {
            progress.setWorkRemaining(0);
        }
    }

    private void firePublishEvent(IPerseusServerPublisher.PublishEvent evt) {
        for (IPerseusServerPublisher.PerseusPublicationListener listener : this.listeners) {
            listener.onPublishEvent(evt);
        }
    }

    @Override
    public void addListener(IPerseusServerPublisher.PerseusPublicationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IPerseusServerPublisher.PerseusPublicationListener listener) {
        this.listeners.remove(listener);
    }
}

