/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl;

import com.fasterxml.jackson.databind.JsonNode;
import fr.obeo.perseus.client.Messages;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.ITransactionDataProvider;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.impl.graphql.CancelTransaction;
import fr.obeo.perseus.client.impl.graphql.CloseTransaction;
import fr.obeo.perseus.client.impl.graphql.OpenTransaction;
import fr.obeo.perseus.client.util.PerseusHttpSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class PerseusTransactionRunner {
    private final ITransactionDataProvider dataProvider;
    private final IPerseusServerConfig config;
    private final PerseusHttpSupport perseusHttpSupport;
    private String transactionId;
    private long jobId;

    public PerseusTransactionRunner(IPerseusServerConfig config, PerseusHttpSupport perseusHttpSupport, ITransactionDataProvider dataProvider) {
        this.config = Objects.requireNonNull(config);
        this.perseusHttpSupport = Objects.requireNonNull(perseusHttpSupport);
        this.dataProvider = Objects.requireNonNull(dataProvider);
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        MultiStatus ms = new MultiStatus("fr.obeo.perseus.client", 100, "", null);
        try {
            progress.subTask(Messages.PerseusTransactionRunner_Opening);
            StringEntity entity = PerseusHttpSupport.createStringEntity(new OpenTransaction(this.dataProvider.getTransactionType(), this.dataProvider.getLabel()));
            JsonNode node = this.perseusHttpSupport.postHttpEntity(this.config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, (IProgressMonitor)progress.split(10));
            this.perseusHttpSupport.checkGraphQLSuccess(node, "OpenTransactionSuccessPayload");
            this.transactionId = this.getTransactionId(node);
            progress.subTask(String.format(Messages.PerseusTransactionRunner_Uploading, new Object[0]));
            Throwable throwable = null;
            Object var7_11 = null;
            try (InputStream is = this.dataProvider.getInputStream();){
                this.perseusHttpSupport.uploadStream(this.config.getApiURI().resolve(IPerseusServerConfig.API_TRANSACTION).resolve(this.transactionId), is, this.dataProvider.getFileName(), (IProgressMonitor)progress.split(90));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            progress.subTask(Messages.PerseusTransactionRunner_Closing);
            ms.merge(this.commitTransaction());
        }
        catch (OperationCanceledException e) {
            ms.merge(this.cancelTransaction());
        }
        catch (PerseusServerException | IOException e) {
            IStatus cancelStatus;
            if (this.transactionId != null && !(cancelStatus = this.cancelTransaction()).matches(8)) {
                ms.merge(cancelStatus);
            }
            ms.merge((IStatus)new Status(4, "fr.obeo.perseus.client", e.getMessage()));
        }
        return ms;
    }

    private IStatus cancelTransaction() {
        try {
            StringEntity entity = PerseusHttpSupport.createStringEntity(new CancelTransaction(this.transactionId));
            JsonNode node = this.perseusHttpSupport.postHttpEntity(this.config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, null);
            this.perseusHttpSupport.checkGraphQLSuccess(node, "CancelTransactionSuccessPayload");
        }
        catch (PerseusServerException | IOException e) {
            return new Status(4, "fr.obeo.perseus.client", String.format(Messages.PerseusTransactionRunner_CancelFailed, e.getMessage()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private IStatus commitTransaction() throws PerseusServerException, IOException {
        Status status;
        try {
            StringEntity entity = PerseusHttpSupport.createStringEntity(new CloseTransaction(this.transactionId));
            JsonNode node = this.perseusHttpSupport.postHttpEntity(this.config.getApiURI().resolve(IPerseusServerConfig.API_GRAPHQL), (HttpEntity)entity, null);
            this.perseusHttpSupport.checkGraphQLSuccess(node, "CloseTransactionSuccessPayload");
            this.jobId = this.getJobId(node);
            URI jobsURI = this.config.getJobsURI();
            status = new Status(0, "fr.obeo.perseus.client", jobsURI.toString());
        }
        catch (PerseusServerException | IOException e) {
            status = new Status(4, "fr.obeo.perseus.client", String.format(Messages.PerseusTransactionRunner_CommitFailed, e.getMessage()), (Throwable)e);
        }
        return status;
    }

    private String getTransactionId(JsonNode node) throws PerseusServerException {
        if (node == null) {
            throw new PerseusServerException(Messages.PerseusTransactionRunner_ErrNullNode);
        }
        JsonNode jsonNode = node.findPath("data").findPath("openTransaction").findPath("transactionId");
        if (!jsonNode.isValueNode()) {
            throw new PerseusServerException(Messages.PerseusTransactionRunner_ErrAcceptedInvalidFormat);
        }
        return jsonNode.asText();
    }

    private long getJobId(JsonNode node) throws PerseusServerException {
        if (node == null) {
            throw new PerseusServerException(Messages.PerseusTransactionRunner_ErrNullNode);
        }
        JsonNode jsonNode = node.findPath("data").findPath("closeTransaction").findPath("jobId");
        if (!jsonNode.isValueNode()) {
            throw new PerseusServerException(Messages.PerseusTransactionRunner_ErrAcceptedInvalidFormat);
        }
        return jsonNode.asLong();
    }

    public long getJobId() {
        return this.jobId;
    }
}

