/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilitySnapshot;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.ISnapshotComparison;
import fr.obeo.dsl.traceability.api.ISnapshotDifference;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.dsl.traceability.api.ITypeDescriptor;
import fr.obeo.dsl.traceability.api.TraceabilityLinkDifferenceKind;
import fr.obeo.perseus.client.Messages;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.api.IModelTranslationParticipant;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.api.IModelUpdateDTOFactory;
import fr.obeo.perseus.client.api.IPerseusServerModelInput;
import fr.obeo.perseus.client.api.IPublishModelData;
import fr.obeo.perseus.client.dto.PName;
import fr.obeo.perseus.client.dto.RefName;
import fr.obeo.perseus.client.dto.meta.MetaRegistrationDTO;
import fr.obeo.perseus.client.dto.meta.MetamodelDTO;
import fr.obeo.perseus.client.dto.meta.MetamodelInfo;
import fr.obeo.perseus.client.dto.model.ImageDTO;
import fr.obeo.perseus.client.dto.model.ModelDTO;
import fr.obeo.perseus.client.dto.model.ModelObjectDTO;
import fr.obeo.perseus.client.dto.model.ModelProxyDTO;
import fr.obeo.perseus.client.dto.model.ModelRefDTO;
import fr.obeo.perseus.client.dto.model.ModelUpdateDTO;
import fr.obeo.perseus.client.dto.model.UpdateKind;
import fr.obeo.perseus.client.dto.oslc.ModelLinkChangesetDTO;
import fr.obeo.perseus.client.dto.oslc.ModelLinkDTO;
import fr.obeo.perseus.client.impl.ConvertedRepresentation;
import fr.obeo.perseus.client.impl.PublicationSettingsProvider;
import fr.obeo.perseus.client.impl.PublishModelData;
import fr.obeo.perseus.client.impl.ecore.EPackageToMetamodel;
import fr.obeo.perseus.client.impl.graphql.RegisterMetamodels;
import fr.obeo.perseus.client.impl.traceability.SessionTraceabilityStrategy;
import fr.obeo.perseus.client.util.DViewComparator;
import fr.obeo.perseus.client.util.EstimatingChronometer;
import fr.obeo.perseus.client.util.FormattingUtil;
import fr.obeo.perseus.client.util.ModelObjectDtoComparator;
import fr.obeo.perseus.client.util.ModelRefDtoComparator;
import fr.obeo.perseus.client.util.NamespaceHelper;
import fr.obeo.perseus.client.util.PerseusHttpSupport;
import fr.obeo.perseus.client.util.PerseusProperties;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.provider.ViewpointItemProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PublishModelInput<T extends ModelDTO>
implements IPerseusServerModelInput {
    public static final int REF_CONTAINMENT = 1;
    public static final int REF_DERIVED = 2;
    public static final int REF_PROXY = 4;
    public static final int REF_OTHER = 8;
    private static final String PREFIX_SERVER_CORE = "default";
    private static final String URI_SERVER_CORE = "http://www.obeo.fr/perseus/server/core/1.0";
    private static final String HASH_SERVER_CORE = "f04fb5c116eba7ca28d5bfb859b8476eaa47cfb3b8ceeadc6934d609d20a477b";
    private static final String PREFIX_SERVER_REPRESENTATIONS = "perseusr";
    private static final String URI_SERVER_REPRESENTATIONS = "http://www.obeo.fr/perseus/server/representations/1.1";
    private static final String HASH_SERVER_REPRESENTATIONS = "b7d445d88ddf67712c60e4bbd9a97dea58847847036919f3412820a6528eff44";
    private final IModelDataProvider modelDataProvider;
    private final IModelTranslationScope translationScope;
    private final IModelUpdateDTOFactory<T> dtoFactory;
    private final ITraceabilityStrategy traceabilityStrategy;
    private final PublicationSettingsProvider publicationSettingsProvider;
    private IPerseusServerModelInput.ModelOperation operation;
    private final List<String> enabledTranslationParticipantIDList = new ArrayList<String>();
    private final Map<EPackage, String> requiredPackages = new LinkedHashMap<EPackage, String>();
    private final Map<String, MetamodelDTO> mmDtoByNsURI = new LinkedHashMap<String, MetamodelDTO>();
    private final Map<String, MetamodelDTO> mmDtoByHash = new LinkedHashMap<String, MetamodelDTO>();
    private final List<DDiagram> diagrams = new ArrayList<DDiagram>();
    private final Map<String, ModelObjectDTO> diagramDTOsByUid = new LinkedHashMap<String, ModelObjectDTO>();
    private ModelUpdateDTO mu;
    private String prjName;
    private PublishModelData publishModelData;
    private List<IModelTranslationParticipant> translationParticipants;
    private final EstimatingChronometer chrono = new EstimatingChronometer();
    private final Map<String, ModelObjectDTO> moDTOsByID = new HashMap<String, ModelObjectDTO>();
    private final Map<String, TraceabilitySnapshot> newSnapshotsByRepoId = new HashMap<String, TraceabilitySnapshot>();
    private final Map<String, Map<String, Object>> iconsByHash = new HashMap<String, Map<String, Object>>();

    public PublishModelInput(IModelDataProvider modelDataProvider, ITraceabilityStrategy traceabilityStrategy, PublicationSettingsProvider publicationSettingsProvider, IModelUpdateDTOFactory<T> dtoFactory) {
        this.modelDataProvider = Objects.requireNonNull(modelDataProvider);
        this.traceabilityStrategy = Objects.requireNonNull(traceabilityStrategy);
        this.publicationSettingsProvider = Objects.requireNonNull(publicationSettingsProvider);
        this.translationScope = Objects.requireNonNull(modelDataProvider.getTranslationScope());
        this.dtoFactory = Objects.requireNonNull(dtoFactory);
    }

    @Override
    public InputStream getModelJsonAsInputStream(IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.ensureModelUpdate((IProgressMonitor)progress.split(95));
        progress.subTask(Messages.PublishModelInput_Preparing);
        ObjectMapper mapper = PerseusHttpSupport.createObjectMapper();
        ObjectWriter writer = mapper.writerFor(ModelUpdateDTO.class);
        File gzFile = File.createTempFile("perseus", ".tmp.gz");
        gzFile.deleteOnExit();
        Throwable throwable = null;
        Object var7_8 = null;
        try (GZIPOutputStream os = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(gzFile)));){
            writer.writeValue((OutputStream)os, (Object)this.mu);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        progress.worked(5);
        if (PerseusProperties.isDebug()) {
            PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", String.format("JSON payload written to %s", gzFile.getAbsolutePath())));
        }
        return new FileInputStream(gzFile);
    }

    @Override
    public IPerseusServerModelInput.ModelOperation getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(IPerseusServerModelInput.ModelOperation operation) {
        this.operation = operation;
    }

    public void setPublishModelData(PublishModelData publishModelData) {
        this.publishModelData = publishModelData;
    }

    @Override
    public IPublishModelData getPublishModelData() {
        return this.publishModelData;
    }

    public Map<String, TraceabilitySnapshot> getNewSnapshotsByRepositoryUrl() {
        return Collections.unmodifiableMap(this.newSnapshotsByRepoId);
    }

    private void initTranslationParticipants() {
        this.translationParticipants = new ArrayList<IModelTranslationParticipant>(10);
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint("fr.obeo.perseus.client.translation.participant").getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("participant".equals(configurationElement.getName())) {
                    try {
                        IModelTranslationParticipant participant = (IModelTranslationParticipant)configurationElement.createExecutableExtension("class");
                        if (this.enabledTranslationParticipantIDList.contains(participant.getParticipantId())) {
                            participant.setModelTranslationScope(this.translationScope);
                            this.translationParticipants.add(participant);
                        }
                    }
                    catch (CoreException e) {
                        PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(4, "fr.obeo.perseus.client", e.getMessage()));
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void ensureModelUpdate(IProgressMonitor monitor) throws IOException, OperationCanceledException {
        if (this.mu != null) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.initTranslationParticipants();
        this.mu = this.dtoFactory.newModelUpdateDTO();
        this.mu.setProjectId(this.publishModelData.getProjectId().toString());
        this.mu.setCommitMessage(this.publishModelData.getCommitMessage());
        T modelDTO = this.dtoFactory.newModelDTO();
        ((ModelDTO)modelDTO).setId(this.publishModelData.getModelId());
        this.mu.getMappings().put(PREFIX_SERVER_CORE, HASH_SERVER_CORE);
        this.mu.getMappings().put(PREFIX_SERVER_REPRESENTATIONS, HASH_SERVER_REPRESENTATIONS);
        String publicationName = this.publishModelData.getName();
        if (publicationName == null || publicationName.trim().isEmpty()) {
            publicationName = this.modelDataProvider.getModelName();
        }
        ((ModelDTO)modelDTO).setName(publicationName);
        ((ModelDTO)modelDTO).setDescription(this.publishModelData.getDescription());
        this.mu.setModelDTO((ModelDTO)modelDTO);
        ((ModelDTO)modelDTO).setId(this.publishModelData.getModelId());
        this.mu.setKind(UpdateKind.UPDATE);
        this.loadModelObjectsWithoutLinks(modelDTO, (IProgressMonitor)progress.split(38));
        this.loadModelObjectRefs(modelDTO, (IProgressMonitor)progress.split(1));
        this.computeLinkChanges((IProgressMonitor)progress.split(20));
        if (this.publicationSettingsProvider.getPublicationSettings().isPublishDiagrams()) {
            this.loadRepresentationObjects(modelDTO, (IProgressMonitor)progress.split(5));
            this.loadImagesAndMaps(modelDTO, (IProgressMonitor)progress.split(35));
        }
        Image projectImage = null;
        try {
            try {
                URI modelURI = this.modelDataProvider.getDAnalysisRoots().get(0).eResource().getURI();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().findMember(modelURI.toPlatformString(true)).getProject();
                projectImage = ((IWorkbenchAdapter)Adapters.adapt((Object)project, IWorkbenchAdapter.class)).getImageDescriptor((Object)project).createImage();
                ((ModelDTO)modelDTO).setIconHash(this.registerIcon(projectImage));
            }
            catch (Exception e) {
                PerseusClientPlugin.getPlugin().log("Unable to compute model icon");
                if (projectImage != null) {
                    projectImage.dispose();
                }
            }
        }
        finally {
            if (projectImage != null) {
                projectImage.dispose();
            }
        }
    }

    private void computeLinkChanges(IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        LinkedHashMap<String, ModelLinkChangesetDTO> changesets = new LinkedHashMap<String, ModelLinkChangesetDTO>();
        this.mu.setChangesetsByRepositoryId(changesets);
        Optional optTraceability = this.traceabilityStrategy.findTraceability();
        if (optTraceability.isPresent()) {
            Traceability traceability = (Traceability)optTraceability.get();
            Map<String, String> preferredPrefixes = traceability.getDomains().stream().filter(SessionTraceabilityStrategy::isValid).collect(Collectors.toMap(dom -> dom.getPrefix(), dom -> dom.getUri()));
            progress.setWorkRemaining(traceability.getRepositories().size());
            for (ArtifactRepository artifactRepository : traceability.getRepositories()) {
                if (!SessionTraceabilityStrategy.isValid(artifactRepository)) continue;
                IArtifactRepositoryStrategy repositoryStrategy = this.traceabilityStrategy.getRepositoryStrategy(artifactRepository.getUrl());
                ModelLinkChangesetDTO changeset = this.computeChangeSet(repositoryStrategy, preferredPrefixes, (IProgressMonitor)progress.split(1));
                changesets.put(artifactRepository.getUrl().toString(), changeset);
            }
        }
    }

    private ModelLinkChangesetDTO computeChangeSet(IArtifactRepositoryStrategy repositoryStrategy, Map<String, String> preferredPrefixes, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ModelLinkChangesetDTO changeset = new ModelLinkChangesetDTO();
        changeset.setNsUriPrefixes(new LinkedHashMap<String, String>());
        NamespaceHelper namespaceSupport = new NamespaceHelper(preferredPrefixes);
        try {
            TraceabilitySnapshot snapshot = repositoryStrategy.computeSnapshot();
            if (this.newSnapshotsByRepoId.putIfAbsent(repositoryStrategy.getArtifactRepositoryURL().toString(), snapshot) != null) {
                throw new IllegalStateException(String.format("Several Artifact Repositories have the same URL '%s'. That is not valid and must be fixed manually.", repositoryStrategy.getArtifactRepositoryURL()));
            }
            progress.worked(10);
            ISnapshotComparison snapshotComparison = repositoryStrategy.compareWithLatestSnapshot(snapshot);
            progress.worked(80);
            LinkedHashMap<String, IArtifact> involvedArtifacts = new LinkedHashMap<String, IArtifact>();
            StringBuilder sb = new StringBuilder();
            for (ISnapshotDifference diff : snapshotComparison.getDifferences()) {
                List changes = changeset.getChanges().computeIfAbsent(this.convert(diff.getKind()), kind -> new ArrayList(256));
                ModelLinkDTO dto = new ModelLinkDTO();
                dto.setArtifactURL(diff.getLinkDescriptor().getArtifactURL().toString());
                IArtifact artifact = involvedArtifacts.computeIfAbsent(dto.getArtifactURL(), artUrl -> repositoryStrategy.findArtifact(artUrl).orElse(null));
                if (artifact != null) {
                    dto.setTitle(artifact.getIdentifier());
                }
                dto.setObjectId(diff.getLinkDescriptor().getModelObjectId());
                ITypeDescriptor linkTypeDescriptor = diff.getLinkDescriptor().getTypeDescriptor();
                dto.setLinkType(namespaceSupport.asPName(linkTypeDescriptor.getNsURI(), linkTypeDescriptor.getName()));
                changes.add(dto);
                sb.append(diff.getKind()).append(" ").append(dto.getObjectId()).append(" ---(").append(dto.getLinkType()).append(")--> ").append(dto.getArtifactURL()).append("\n");
            }
            changeset.getNsUriPrefixes().putAll(namespaceSupport.getKnownURIsByPrefix());
            String changesInfo = sb.toString();
            if (PerseusProperties.isDebug() && !changesInfo.isEmpty()) {
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(1, "fr.obeo.perseus.client", sb.toString()));
            }
            progress.worked(10);
        }
        catch (CoreException e) {
            PerseusClientPlugin.getPlugin().getLog().log(e.getStatus());
            throw new IOException(e);
        }
        return changeset;
    }

    private UpdateKind convert(TraceabilityLinkDifferenceKind kind) {
        switch (kind) {
            case ADD: {
                return UpdateKind.ADD;
            }
            case DELETE: {
                return UpdateKind.DELETE;
            }
        }
        throw new IllegalArgumentException(String.format("The traceability kind '%s' is not supported.", kind));
    }

    private void loadModelObjectsWithoutLinks(T modelDTO, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List<EObject> semanticRoots = this.modelDataProvider.getSemanticRoots();
        int[] sizes = new int[semanticRoots.size()];
        int totalSize = 0;
        int i = 0;
        for (EObject o : semanticRoots) {
            int size = this.countAllChildren(o);
            sizes[i++] = size;
            totalSize += size;
        }
        SubMonitor loopMonitor = progress.split(100).setWorkRemaining(totalSize);
        this.chrono.setNbSteps(totalSize);
        this.chrono.setUpdateThreshold(50);
        this.chrono.start("Model objects");
        for (EObject o : semanticRoots) {
            this.addModelObject((ModelDTO)modelDTO, o, null, null, loopMonitor);
        }
        this.chrono.stop();
    }

    private void loadModelObjectRefs(T modelDTO, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List<EObject> semanticRoots = this.modelDataProvider.getSemanticRoots();
        progress.setWorkRemaining(100);
        this.chrono.start("Model object references");
        for (EObject o : semanticRoots) {
            this.addModelObjectRefs((ModelDTO)modelDTO, o);
            TreeIterator it = o.eAllContents();
            while (it.hasNext() && !progress.isCanceled()) {
                this.addModelObjectRefs((ModelDTO)modelDTO, (EObject)it.next());
            }
            progress.worked(1);
            progress.setWorkRemaining(100);
        }
        this.chrono.stop();
    }

    private void loadRepresentationObjects(T modelDTO, IProgressMonitor monitor) {
        List<DAnalysis> analysisRoots = this.modelDataProvider.getDAnalysisRoots();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor loopMonitor = progress.split(100).setWorkRemaining(analysisRoots.size());
        this.chrono.start("Lookup representations");
        for (DAnalysis analysis : analysisRoots) {
            this.computeRepresentationObjects(modelDTO, analysis, (IProgressMonitor)loopMonitor.split(1));
        }
        this.chrono.stop();
    }

    private void loadImagesAndMaps(T modelDTO, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        progress.subTask("");
        File tempFolder = Files.createTempDirectory("perseus_", new FileAttribute[0]).toFile();
        tempFolder.deleteOnExit();
        Map<String, ConvertedRepresentation> convertedRepresentations = this.modelDataProvider.getImageProducer().produceImages(this.diagrams, this.publicationSettingsProvider.getPublicationSettings().isRefreshDiagrams(), (IProgressMonitor)progress.split(100));
        this.chrono.setNbSteps(convertedRepresentations.size());
        this.chrono.setUpdateThreshold(10);
        this.chrono.start("Compute Image maps");
        SubMonitor loopProgress = progress.split(100).setWorkRemaining(this.chrono.getNbSteps());
        for (Map.Entry<String, ConvertedRepresentation> entry : convertedRepresentations.entrySet()) {
            this.chrono.runOnceInAWhile(() -> loopProgress.subTask(String.format(Messages.PublishModelInput_PrepareImageMap, this.chrono.getIndex(), this.chrono.getNbSteps(), FormattingUtil.formatDuration(this.chrono.remainingEstimate()))));
            this.chrono.nextStep();
            String diagramUid = entry.getKey();
            ConvertedRepresentation cr = entry.getValue();
            File imageFile = cr.getImageFile();
            byte[] data = Files.readAllBytes(imageFile.toPath());
            BufferedImage bi = ImageIO.read(imageFile);
            ImageDTO image = new ImageDTO();
            image.setMimeType("image/jpeg");
            image.setData(data);
            image.setHash(PublishModelInput.computeHash(data));
            image.setWidth(bi.getWidth());
            image.setHeight(bi.getHeight());
            ((ModelDTO)modelDTO).getImages().add(image);
            ImageDTO imageHashAndMap = new ImageDTO();
            imageHashAndMap.setHash(image.getHash());
            imageHashAndMap.setWidth(image.getWidth());
            imageHashAndMap.setHeight(image.getHeight());
            imageHashAndMap.setImageMap(cr.getImageDTO().getImageMap());
            ModelObjectDTO moDTO = this.diagramDTOsByUid.get(diagramUid);
            if (moDTO.getLinks() == null) {
                moDTO.setLinks(new LinkedHashMap<String, Object>());
            }
            moDTO.getLinks().put("perseus:image", imageHashAndMap);
            loopProgress.worked(1);
        }
        this.chrono.stop();
    }

    private void computeRepresentationObjects(T modelDTO, DAnalysis analysis, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ModelObjectDTO dtoAnalysis = new ModelObjectDTO();
        dtoAnalysis.setMetaclass(PName.of("perseusr:Analysis"));
        dtoAnalysis.setName(this.prjName);
        dtoAnalysis.setUid(analysis.getUid());
        ((ModelDTO)modelDTO).getRoots().add(dtoAnalysis);
        Map<Viewpoint, List> views = this.getOwnedAndReferencedViews(analysis).collect(Collectors.toMap(DView::getViewpoint, v -> {
            ArrayList<DView> res = new ArrayList<DView>();
            res.add((DView)v);
            return res;
        }, (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }));
        this.addContentRefs((ModelDTO)modelDTO, analysis.getUid(), this.getOwnedAndReferencedViews(analysis).sorted(DViewComparator.INSTANCE).collect(Collectors.toList()));
        SubMonitor loopMonitor = progress.split(100).setWorkRemaining(views.size());
        if (!views.isEmpty()) {
            ViewpointItemProvider viewpointItemProvider = (ViewpointItemProvider)new DescriptionItemProviderAdapterFactory().createViewpointAdapter();
            RefName rnOwnedViews = RefName.of("perseusr:Analysis:ownedViews");
            dtoAnalysis.getContains().put(rnOwnedViews, new ArrayList(views.size()));
            ArrayList<ModelObjectDTO> dtoViews = new ArrayList<ModelObjectDTO>();
            for (Map.Entry<Viewpoint, List> viewsEntry : views.entrySet()) {
                ModelObjectDTO dtoView = new ModelObjectDTO();
                dtoView.setMetaclass(PName.of("perseusr:View"));
                dtoView.setName(viewpointItemProvider.getText((Object)viewsEntry.getKey()));
                dtoView.setUid(((DView)viewsEntry.getValue().get(0)).getUid());
                dtoViews.add(dtoView);
                ArrayList<ModelObjectDTO> dviewDTOs = new ArrayList<ModelObjectDTO>();
                for (DView view : viewsEntry.getValue()) {
                    dviewDTOs.addAll(this.computeRepresentationDescriptors(modelDTO, view));
                }
                if (!dviewDTOs.isEmpty()) {
                    dtoView.getContains().put(RefName.of("perseusr:View:ownedRepresentationDescriptors"), dviewDTOs);
                }
                loopMonitor.worked(1);
            }
            dtoViews.sort(ModelObjectDtoComparator.INSTANCE);
            dtoAnalysis.getContains().get(rnOwnedViews).addAll(dtoViews);
        }
    }

    private Stream<DView> getOwnedAndReferencedViews(DAnalysis analysis) {
        Stream ownedViewsStream = analysis.getOwnedViews().stream();
        Stream referencedViewsStream = analysis.getReferencedAnalysis().stream().flatMap(this::getOwnedAndReferencedViews);
        return Stream.concat(ownedViewsStream, referencedViewsStream).filter(v -> v.getViewpoint() != null);
    }

    private List<ModelObjectDTO> computeRepresentationDescriptors(T modelDTO, DView view) {
        ArrayList<ModelObjectDTO> result = new ArrayList<ModelObjectDTO>(view.getOwnedRepresentationDescriptors().size());
        for (DRepresentationDescriptor descriptor : view.getOwnedRepresentationDescriptors()) {
            if (!this.translationScope.isInModel((EObject)descriptor) || !PublishModelInput.isSupported(descriptor)) continue;
            this.computeRepresentationDTO(modelDTO, descriptor).ifPresent(repr -> {
                String targetId;
                ModelObjectDTO dtoDescriptor = new ModelObjectDTO();
                dtoDescriptor.setMetaclass(PName.of("perseusr:RepresentationDescriptor"));
                dtoDescriptor.setName(descriptor.getName());
                dtoDescriptor.setUid(descriptor.getUid());
                dtoDescriptor.setProps(Collections.singletonMap("representationType", MessageTranslator.INSTANCE.getMessage((EObject)descriptor.getDescription(), new IdentifiedElementQuery((IdentifiedElement)descriptor.getDescription()).getLabel())));
                result.add(dtoDescriptor);
                RefName rnRepresentation = RefName.of("perseusr:RepresentationDescriptor:representation");
                dtoDescriptor.getContains().put(rnRepresentation, Arrays.asList(repr));
                if (Optional.ofNullable(descriptor.getTarget()).map(EObject::eClass).map(EClassifier::getEPackage).map(p -> this.isSupported((EPackage)p)).orElse(false).booleanValue() && (targetId = this.translationScope.getId(descriptor.getTarget())) != null) {
                    ModelRefDTO mr = new ModelRefDTO();
                    mr.setSourceUid(descriptor.getUid());
                    mr.setTargetUid(targetId);
                    mr.setIndex(0);
                    mr.setType(RefName.of("perseusr:RepresentationDescriptor:target"));
                    if (!this.translationScope.isInModel(descriptor.getTarget())) {
                        mr.setFlags((byte)(mr.getFlags() | 4));
                    }
                    modelDTO.getReferences().add(mr);
                }
            });
        }
        return result;
    }

    public static boolean isSupported(DRepresentationDescriptor descriptor) {
        DRepresentation dr = descriptor.getRepresentation();
        return descriptor.getDescription() != null && dr != null && (dr instanceof DDiagram || PublishModelInput.getPerseusDRepresentationType(dr.eClass()) != null);
    }

    public static PName getPerseusDRepresentationType(EClass eClass) {
        String name = eClass.getName();
        PName result = null;
        if ("DDiagram".equals(name)) {
            result = PName.of("perseusr:Diagram");
        } else if ("DTable".equals(name)) {
            result = PName.of("perseusr:Table");
        } else if ("DTree".equals(name)) {
            result = PName.of("perseusr:Tree");
        }
        return result;
    }

    private Optional<ModelObjectDTO> computeRepresentationDTO(T modelDTO, DRepresentationDescriptor descriptor) {
        Optional<DRepresentation> optRepr = Optional.ofNullable(descriptor.getRepresentation());
        return optRepr.map(repr -> this.computeRepresentationDTO(modelDTO, descriptor, (DRepresentation)repr));
    }

    private ModelObjectDTO computeRepresentationDTO(T modelDTO, DRepresentationDescriptor descriptor, DRepresentation dr) {
        ModelObjectDTO dto = new ModelObjectDTO();
        if (dr instanceof DDiagram) {
            this.diagrams.add((DDiagram)dr);
            dto.setMetaclass(PName.of("perseusr:Diagram"));
            this.diagramDTOsByUid.put(dr.getUid(), dto);
        } else {
            dto.setMetaclass(PublishModelInput.getPerseusDRepresentationType(dr.eClass()));
        }
        dto.setName(dr.getName());
        dto.setUid(dr.getUid());
        if (dr instanceof DDiagram) {
            DDiagram diag = (DDiagram)dr;
            ((ModelDTO)modelDTO).getReferences().addAll(this.computeRepresentationRefs(dr, (List<DDiagramElement>)diag.getDiagramElements(), RefName.of("default:IRepresentation:objectsWithVisibleMappings")));
            ((ModelDTO)modelDTO).getReferences().addAll(this.computeRepresentationRefs(dr, (List<DDiagramElement>)diag.getHiddenElements(), RefName.of("default:IRepresentation:objectsWithHiddenMappings")));
        }
        if (descriptor.getDocumentation() != null) {
            dto.setProps(Collections.singletonMap("description", descriptor.getDocumentation()));
        }
        LinkedHashMap<String, Object> links = new LinkedHashMap<String, Object>();
        for (IModelTranslationParticipant participant : this.translationParticipants) {
            JsonNode participantLinks = participant.apply((EObject)descriptor);
            if (participantLinks == null || participantLinks.isObject() && !participantLinks.fields().hasNext()) continue;
            links.put(participant.getParticipantId(), participantLinks);
        }
        if (!links.isEmpty()) {
            dto.setLinks(links);
        }
        return dto;
    }

    private List<ModelRefDTO> computeRepresentationRefs(DRepresentation dr, List<DDiagramElement> elements, RefName type) {
        ArrayList<ModelRefDTO> result = new ArrayList<ModelRefDTO>(elements.size());
        Set<EObject> modelObjects = elements.stream().map(DSemanticDecorator::getTarget).collect(Collectors.toSet());
        modelObjects.forEach(target -> {
            String id;
            if (target != null && this.isSupported(target.eClass().getEPackage()) && (id = this.translationScope.getId((EObject)target)) != null) {
                ModelRefDTO refDTO = new ModelRefDTO();
                refDTO.setSourceUid(dr.getUid());
                refDTO.setTargetUid(id);
                refDTO.setType(type);
                if (!this.translationScope.isInModel((EObject)target)) {
                    refDTO.setFlags((byte)(refDTO.getFlags() | 4));
                }
                result.add(refDTO);
            }
        });
        result.sort(ModelRefDtoComparator.INSTANCE);
        int i = 0;
        for (ModelRefDTO refDTO : result) {
            refDTO.setIndex(i++);
        }
        return result;
    }

    private int countAllChildren(EObject o) {
        int c = 1;
        TreeIterator eAllContents = o.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!this.translationScope.isInModel(next)) continue;
            ++c;
        }
        return c;
    }

    private void addModelObject(ModelDTO m, EObject o, RefName parentCont, ModelObjectDTO parent, SubMonitor progress) {
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.chrono.runOnceInAWhile(() -> progress.subTask(String.format(Messages.PublishModelInput_LoadingObject, this.chrono.getIndex(), this.chrono.getNbSteps(), FormattingUtil.formatDuration(this.chrono.remainingEstimate()))));
        this.chrono.nextStep();
        EPackage ePackage = o.eClass().getEPackage();
        if (!this.isSupported(ePackage)) {
            progress.worked(1);
            return;
        }
        this.require(ePackage);
        String id = this.translationScope.getId(o);
        if (id != null) {
            ModelObjectDTO mo = new ModelObjectDTO();
            ModelObjectDTO prev = this.moDTOsByID.putIfAbsent(id, mo);
            if (prev != null) {
                PerseusClientPlugin.getPlugin().getLog().log((IStatus)new Status(2, "fr.obeo.perseus.client", String.format("%s has the same ID '%s' as %s '%s', it will be ignored along with all its content", o, id, prev.getMetaclass(), prev.getName())));
                return;
            }
            this.addContentRefs(m, id, (List<EObject>)o.eContents());
            EClass eClass = o.eClass();
            mo.setMetaclass(this.getPName(eClass));
            mo.setUid(id);
            if (parentCont == null) {
                m.getRoots().add(mo);
            } else {
                parent.getContains().get(parentCont).add(mo);
            }
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
            mo.setProps(attributes);
            AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)o);
            String title = ((IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)o, IItemLabelProvider.class)).getText((Object)o);
            mo.setName(title);
            for (EAttribute att : eClass.getEAllAttributes()) {
                if (att.isID()) continue;
                attributes.put(att.getName(), o.eGet((EStructuralFeature)att));
            }
            for (EReference cRef : eClass.getEAllContainments()) {
                if (cRef.isDerived() || !o.eIsSet((EStructuralFeature)cRef)) continue;
                RefName cont = this.getRefName(cRef);
                if (cRef.isMany()) {
                    EList children = (EList)o.eGet((EStructuralFeature)cRef);
                    mo.getContains().put(cont, new ArrayList(children.size()));
                    if (children == null || children.isEmpty()) continue;
                    for (EObject child : children) {
                        this.addModelObject(m, child, cont, mo, progress);
                    }
                    continue;
                }
                mo.getContains().put(cont, new ArrayList(1));
                this.addModelObject(m, (EObject)o.eGet((EStructuralFeature)cRef), cont, mo, progress);
            }
            LinkedHashMap<String, Object> links = new LinkedHashMap<String, Object>();
            for (IModelTranslationParticipant participant : this.translationParticipants) {
                JsonNode participantLinks = participant.apply(o);
                if (participantLinks == null || participantLinks.isObject() && !participantLinks.fields().hasNext()) continue;
                links.put(participant.getParticipantId(), participantLinks);
            }
            if (!links.isEmpty()) {
                mo.setLinks(links);
            }
            try {
                mo.setIconHash(this.registerIcon(o));
            }
            catch (Exception e) {
                PerseusClientPlugin.getPlugin().log(String.format("Unable to compute icon for object of type %s", o.eClass().getName()));
            }
        } else {
            PerseusClientPlugin.getPlugin().log(String.format("EObject %s has no ID field", o));
        }
        progress.worked(1);
    }

    private void require(EPackage ePackage) {
        if (!this.requiredPackages.containsKey(ePackage)) {
            this.requiredPackages.put(ePackage, this.computePrefix(ePackage));
            LinkedHashSet<EPackage> additionalPackages = new LinkedHashSet<EPackage>();
            additionalPackages.add(ePackage);
            while (!additionalPackages.isEmpty()) {
                LinkedHashSet toConvert = new LinkedHashSet(additionalPackages);
                additionalPackages.clear();
                for (EPackage p : toConvert) {
                    LinkedHashSet<EPackage> dependencies = new LinkedHashSet<EPackage>();
                    EPackageToMetamodel p2m = new EPackageToMetamodel(p, dependencies);
                    MetamodelDTO mmDTO = p2m.convert();
                    if (this.mmDtoByNsURI.put(p.getNsURI(), mmDTO) != null) {
                        throw new IllegalStateException("Several meta-models have the same URI " + p.getNsURI());
                    }
                    if (this.mmDtoByHash.put(mmDTO.getHash(), mmDTO) != null) {
                        throw new IllegalStateException("Several meta-models have the same Hash " + p.getNsURI());
                    }
                    this.mu.getMappings().putIfAbsent(this.computePrefix(p), mmDTO.getHash());
                    for (EPackage dep : dependencies) {
                        if (this.requiredPackages.containsKey(dep)) continue;
                        this.requiredPackages.put(dep, this.computePrefix(dep));
                        additionalPackages.add(dep);
                    }
                }
            }
        }
    }

    private String registerIcon(EObject o) throws IOException {
        Image image = null;
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)o);
        Object emfImage = ((IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)o, IItemLabelProvider.class)).getImage((Object)o);
        if (emfImage != null) {
            image = ExtendedImageRegistry.getInstance().getImage(emfImage);
        }
        if (image == null) {
            throw new NullPointerException();
        }
        return this.registerIcon(image);
    }

    private String registerIcon(Image image) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ImageLoader saver = new ImageLoader();
            saver.data = new ImageData[]{image.getImageData()};
            saver.save((OutputStream)os, 5);
            byte[] imageBytes = os.toByteArray();
            String iconHash = PublishModelInput.computeHash(imageBytes);
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("data", imageBytes);
            input.put("mimeType", "image/png");
            input.put("width", image.getImageData().width);
            input.put("height", image.getImageData().height);
            this.iconsByHash.put(iconHash, input);
            return iconHash;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String computeHash(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(data);
            byte[] digest = md.digest();
            StringBuilder hashBuilder = new StringBuilder(digest.length);
            int i = 0;
            while (i < digest.length) {
                hashBuilder.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
                ++i;
            }
            return hashBuilder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 algorithm should be supported");
        }
    }

    private RefName getRefName(EReference ref) {
        return RefName.of(this.getPName(ref.getEContainingClass()), ref.getName());
    }

    private PName getPName(EClass eClass) {
        String prefix = this.computePrefix(eClass.getEPackage());
        this.mu.getMappings().putIfAbsent(prefix, this.getHash(eClass.getEPackage()));
        return PName.of(prefix, eClass.getName());
    }

    private void addModelObjectRefs(ModelDTO m, EObject o) {
        EPackage ePackage = o.eClass().getEPackage();
        if (!this.isSupported(ePackage)) {
            return;
        }
        String id = this.translationScope.getId(o);
        if (id != null) {
            EClass eClass = o.eClass();
            for (EReference ref : eClass.getEAllReferences()) {
                if (ref.isContainment() && !ref.isDerived()) continue;
                if (ref.isMany()) {
                    EList targets = (EList)o.eGet((EStructuralFeature)ref, false);
                    this.addRefs(m, id, ref, (List<EObject>)targets);
                    continue;
                }
                EObject targetEObject = (EObject)o.eGet((EStructuralFeature)ref, false);
                if (targetEObject == null) continue;
                this.addRef(m, id, ref, targetEObject);
            }
        }
    }

    private void addRef(ModelDTO m, String id, EReference ref, EObject targetEObject) {
        String targetId;
        if (!targetEObject.eIsProxy() && (targetId = this.translationScope.getId(targetEObject)) != null) {
            ModelRefDTO mr = new ModelRefDTO();
            mr.setSourceUid(id);
            mr.setTargetUid(targetId);
            mr.setIndex(0);
            mr.setType(this.getRefName(ref));
            mr.setFlags((byte)((ref.isContainment() ? 1 : 0) | (ref.isDerived() ? 2 : 0)));
            m.getReferences().add(mr);
            if (!this.translationScope.isInModel(targetEObject)) {
                Resource targetRes = targetEObject.eResource();
                URI targetResURI = targetRes.getURI();
                mr.setFlags((byte)(mr.getFlags() | 4));
                ModelProxyDTO proxy = new ModelProxyDTO();
                proxy.setUid(targetId);
                proxy.setMetaclass(this.getPName(targetEObject.eClass()));
                proxy.setModelUri(targetResURI.isPlatform() ? targetResURI.toPlatformString(true) : (targetResURI.isFile() ? targetResURI.toFileString() : targetResURI.toString()));
                m.getProxies().add(proxy);
            }
        }
    }

    private void addContentRefs(ModelDTO m, String id, List<EObject> list) {
        int refIndex = 0;
        for (EObject targetEObject : list) {
            ModelRefDTO mr = new ModelRefDTO();
            mr.setSourceUid(id);
            mr.setType(RefName.of("default:Object:perseusContent"));
            mr.setFlags((byte)1);
            if (targetEObject.eIsProxy()) continue;
            String targetId = this.translationScope.getId(targetEObject);
            if (targetId != null) {
                mr.setTargetUid(targetId);
                mr.setIndex(refIndex++);
                mr.setFlags((byte)1);
                if (!this.translationScope.isInModel(targetEObject)) {
                    Resource targetRes = targetEObject.eResource();
                    URI targetResURI = targetRes.getURI();
                    mr.setFlags((byte)(mr.getFlags() | 4));
                    ModelProxyDTO proxy = new ModelProxyDTO();
                    proxy.setUid(targetId);
                    proxy.setMetaclass(this.getPName(targetEObject.eClass()));
                    proxy.setModelUri(targetResURI.isPlatform() ? targetResURI.toPlatformString(true) : (targetResURI.isFile() ? targetResURI.toFileString() : targetResURI.toString()));
                    m.getProxies().add(proxy);
                }
            }
            m.getReferences().add(mr);
        }
    }

    private void addRefs(ModelDTO m, String id, EReference ref, List<EObject> list) {
        int refIndex = 0;
        for (EObject targetEObject : list) {
            String targetId;
            ModelRefDTO mr = new ModelRefDTO();
            mr.setSourceUid(id);
            mr.setType(this.getRefName(ref));
            mr.setFlags((byte)((ref.isContainment() ? 1 : 0) | (ref.isDerived() ? 2 : 0)));
            if (!targetEObject.eIsProxy() && (targetId = this.translationScope.getId(targetEObject)) != null) {
                mr.setTargetUid(targetId);
                mr.setIndex(refIndex++);
                if (!this.translationScope.isInModel(targetEObject)) {
                    Resource targetRes = targetEObject.eResource();
                    URI targetResURI = targetRes.getURI();
                    mr.setFlags((byte)(mr.getFlags() | 4));
                    ModelProxyDTO proxy = new ModelProxyDTO();
                    proxy.setUid(targetId);
                    proxy.setMetaclass(this.getPName(targetEObject.eClass()));
                    proxy.setModelUri(targetResURI.isPlatform() ? targetResURI.toPlatformString(true) : (targetResURI.isFile() ? targetResURI.toFileString() : targetResURI.toString()));
                    m.getProxies().add(proxy);
                }
            }
            m.getReferences().add(mr);
        }
    }

    @Override
    public Set<String> getRequiredMetamodelHashes(IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.ensureModelUpdate((IProgressMonitor)progress.split(99));
        Set<String> result = this.getInitializedMetamodelHashes();
        this.requiredPackages.forEach((pack, prefix) -> {
            boolean bl = result.add(this.getHash((EPackage)pack));
        });
        return result;
    }

    protected boolean isSupported(EPackage pack) {
        return !pack.getNsURI().startsWith("http://www.eclipse.org/sirius/") && !pack.getNsURI().startsWith("http://www.eclipse.org/gmf");
    }

    private String getHash(EPackage pack) {
        String result = this.mmDtoByNsURI.get(pack.getNsURI()).getHash();
        return result;
    }

    protected String computePrefix(EPackage pack) {
        return pack.getNsPrefix();
    }

    protected Set<String> getInitializedMetamodelHashes() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(HASH_SERVER_CORE);
        result.add(HASH_SERVER_REPRESENTATIONS);
        return result;
    }

    @Override
    public String getMetamodelsAsJson(Set<String> missingHashes, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PublishModelInput_PreparingMM, (int)100);
        MetaRegistrationDTO registration = new MetaRegistrationDTO();
        registration.getMappings().put(PREFIX_SERVER_CORE, new MetamodelInfo(URI_SERVER_CORE, HASH_SERVER_CORE));
        registration.getMappings().put(PREFIX_SERVER_REPRESENTATIONS, new MetamodelInfo(URI_SERVER_REPRESENTATIONS, HASH_SERVER_REPRESENTATIONS));
        for (String hash : missingHashes) {
            MetamodelDTO mmDTO = this.mmDtoByHash.get(hash);
            if (mmDTO == null) {
                throw new IllegalStateException(String.format(Messages.PublishModelInput_MissingMM, hash));
            }
            registration.getMetamodels().add(mmDTO);
        }
        this.requiredPackages.forEach((pack, prefix) -> {
            MetamodelDTO mmDTO = this.mmDtoByNsURI.get(pack.getNsURI());
            registration.getMappings().put(this.computePrefix((EPackage)pack), new MetamodelInfo(mmDTO.getUri(), mmDTO.getHash()));
        });
        RegisterMetamodels rm = new RegisterMetamodels(registration);
        ObjectMapper mapper = PerseusHttpSupport.createObjectMapper();
        ObjectWriter writer = mapper.writerFor(RegisterMetamodels.class);
        try {
            String string;
            block15: {
                Throwable throwable = null;
                Object var9_10 = null;
                StringWriter sw = new StringWriter(1000000);
                try {
                    writer.writeValue((Writer)sw, (Object)rm);
                    string = sw.toString();
                    if (sw == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        if (sw != null) {
                            sw.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                sw.close();
            }
            return string;
        }
        finally {
            progress.done();
        }
    }

    public List<String> getEnabledTranslationParticipantIDList() {
        return this.enabledTranslationParticipantIDList;
    }

    @Override
    public Map<String, Map<String, Object>> getRequiredIcons(IProgressMonitor monitor) throws IOException {
        return this.iconsByHash;
    }
}

