/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl;

import fr.obeo.perseus.client.Messages;
import fr.obeo.perseus.client.api.IModelImageProducer;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.impl.ConvertedRepresentation;
import fr.obeo.perseus.client.impl.DRepresentationConverter;
import fr.obeo.perseus.client.util.EstimatingChronometer;
import fr.obeo.perseus.client.util.FormattingUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;

public class SessionImageProducer
implements IModelImageProducer {
    private final File tempFolder;
    private final Session session;
    private final IModelTranslationScope translationScope;

    public SessionImageProducer(File tempFolder, Session session, IModelTranslationScope translationScope) {
        this.tempFolder = Objects.requireNonNull(tempFolder);
        this.session = Objects.requireNonNull(session);
        this.translationScope = Objects.requireNonNull(translationScope);
    }

    @Override
    public Map<String, ConvertedRepresentation> produceImages(List<DDiagram> diagrams, boolean refreshDiagrams, IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)diagrams.size());
        DRepresentationConverter converter = new DRepresentationConverter(this.tempFolder, this.session, this.translationScope, refreshDiagrams);
        LinkedHashMap<String, ConvertedRepresentation> result = new LinkedHashMap<String, ConvertedRepresentation>();
        EstimatingChronometer chrono = new EstimatingChronometer();
        chrono.setNbSteps(diagrams.size());
        chrono.setUpdateThreshold(1);
        chrono.start("Export diagrams as JPEG images");
        for (DDiagram diagram : diagrams) {
            chrono.runOnceInAWhile(() -> progress.subTask(String.format(Messages.SessionImageProducer_PreparingImage, chrono.getIndex(), chrono.getNbSteps(), FormattingUtil.formatDuration(chrono.remainingEstimate()), diagram.getName())));
            result.put(diagram.getUid(), converter.convert(diagram, (IProgressMonitor)progress.split(1)));
            chrono.nextStep();
        }
        chrono.stop();
        return result;
    }
}

