/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl;

import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.api.IModelDataProvider;
import fr.obeo.perseus.client.api.IModelImageProducer;
import fr.obeo.perseus.client.api.IModelTranslationScope;
import fr.obeo.perseus.client.impl.SessionImageProducer;
import fr.obeo.perseus.client.util.ModelURI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DAnalysis;

public class SessionModelDataProvider
implements IModelDataProvider {
    private final Session session;
    private final IModelTranslationScope translationScope;
    private SessionImageProducer imageProducer;

    public SessionModelDataProvider(Session session, IModelTranslationScope translationScope) {
        this.session = Objects.requireNonNull(session);
        this.translationScope = Objects.requireNonNull(translationScope);
    }

    @Override
    public List<EObject> getSemanticRoots() {
        return this.session.getSemanticResources().stream().filter(this.translationScope::isInModel).flatMap(r -> r.getContents().stream()).collect(Collectors.toList());
    }

    @Override
    public List<DAnalysis> getDAnalysisRoots() {
        return this.session.getSessionResource().getContents().stream().filter(DAnalysis.class::isInstance).map(DAnalysis.class::cast).collect(Collectors.toList());
    }

    @Override
    public String getModelName() {
        URI sessionResourceURI = this.session.getSessionResource().getURI();
        return URI.decode((String)sessionResourceURI.segment(1));
    }

    @Override
    public IModelTranslationScope getTranslationScope() {
        return this.translationScope;
    }

    @Override
    public IModelImageProducer getImageProducer() throws IOException {
        if (this.imageProducer == null) {
            this.imageProducer = new SessionImageProducer(Files.createTempDirectory("perseus", new FileAttribute[0]).toFile(), this.session, this.translationScope);
        }
        return this.imageProducer;
    }

    public List<String> getRootUids() {
        ArrayList<String> result = new ArrayList<String>();
        this.getSemanticRoots().forEach(o -> {
            boolean bl = result.add(this.translationScope.getId((EObject)o));
        });
        this.getDAnalysisRoots().forEach(dan -> {
            boolean bl = result.add(dan.getUid());
        });
        return result;
    }

    @Override
    public void storePerseusModelURI(final ModelURI modelURI) {
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                SessionModelDataProvider.this.getTraceabilityStrategy().findTraceability().ifPresent(traceability -> traceability.setModelUri(modelURI.toString()));
            }
        });
    }

    @Override
    public void storePerseusModelConfigurationURI(final IArtifact configuration) {
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                SessionModelDataProvider.this.getTraceabilityStrategy().findTraceability().ifPresent(traceability -> traceability.setConfiguration(configuration));
            }
        });
    }

    @Override
    public Optional<ModelURI> getPerseusModelURI() {
        return this.getTraceabilityStrategy().findTraceability().map(Traceability::getModelUri).filter(uri -> !uri.isEmpty()).map(ModelURI::of);
    }

    @Override
    public Optional<IArtifact> getPerseusModelConfiguration() {
        return this.getTraceabilityStrategy().findTraceability().map(Traceability::getConfiguration);
    }

    private ITraceabilityStrategy getTraceabilityStrategy() {
        return (ITraceabilityStrategy)Adapters.adapt((Object)this.session, ITraceabilityStrategy.class);
    }

    @Override
    public Optional<EObject> findSemanticObjectById(String objectId) {
        return Stream.concat(this.session.getSemanticResources().stream(), this.session.getAllSessionResources().stream()).filter(res -> !"traceability".equals(res.getURI().fileExtension())).map(res -> res.getEObject(objectId)).filter(Objects::nonNull).findFirst();
    }

    public Session getSession() {
        return this.session;
    }
}

