/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl;

import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilityPackage;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.api.IPublicationSettings;
import fr.obeo.perseus.client.impl.OptimisticModelTranslationScope;
import fr.obeo.perseus.client.impl.PublicationSettingsProvider;
import java.util.Objects;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.DRepresentationDescriptorQuery;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;

public class SessionModelTranslationScope
extends OptimisticModelTranslationScope {
    private final Session session;

    public SessionModelTranslationScope(Session session) {
        this.session = Objects.requireNonNull(session);
    }

    @Override
    public boolean isInModel(EObject o) {
        Resource res;
        boolean result;
        boolean bl = result = !o.eIsProxy() && o.eClass() != null && o.eClass().getEPackage() != null && !TraceabilityPackage.eINSTANCE.getNsURI().equals(o.eClass().getEPackage().getNsURI());
        if (result && !(result = this.isInModel(res = o.eResource())) && (this.session.getAllSessionResources().contains(res) || this.session.getSrmResources().contains(res))) {
            result = o instanceof DRepresentation ? this.isPartOfPublish((DRepresentation)o) : (o instanceof DRepresentationDescriptor ? this.isPartOfPublish((DRepresentationDescriptor)o) : o instanceof DAnalysis || o instanceof DView);
        }
        return result;
    }

    @Override
    public boolean isInModel(Resource r) {
        boolean result = false;
        if (r != null && !"traceability".equals(r.getURI().fileExtension()) && !(result = this.session.getSemanticResources().contains(r)) && this.session instanceof DAnalysisSessionEObject) {
            result = ((DAnalysisSessionEObject)this.session).getControlledResources().contains((Object)r);
        }
        return result;
    }

    public boolean isPartOfPublish(DRepresentation representation) {
        DRepresentationDescriptor diagramDescriptor = new DRepresentationQuery(representation).getRepresentationDescriptor();
        if (diagramDescriptor != null) {
            return this.isPartOfPublish(diagramDescriptor);
        }
        return false;
    }

    public boolean isPartOfPublish(DRepresentationDescriptor representationDescriptor) {
        if (new DRepresentationDescriptorQuery(representationDescriptor).isRepresentationValid()) {
            String diagramDescriptorName = representationDescriptor.getName();
            ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)this.session, ITraceabilityStrategy.class);
            Traceability traceability = null;
            if (traceabilityStrategy != null) {
                traceability = traceabilityStrategy.findTraceability().orElse(null);
            }
            PublicationSettingsProvider publicationSettingsProvider = new PublicationSettingsProvider(traceability);
            IPublicationSettings publicationSettings = publicationSettingsProvider.getPublicationSettings();
            boolean isDiagramPublished = true;
            if (publicationSettings.isPublishDiagrams()) {
                if (diagramDescriptorName != null && publicationSettings.isFilterDiagramsToPublish()) {
                    isDiagramPublished = !diagramDescriptorName.contains(publicationSettings.getDiagramExcludePrefix());
                }
            } else {
                isDiagramPublished = false;
            }
            return isDiagramPublished;
        }
        return false;
    }
}

