/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl;

import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.SynchronizationPoint;
import fr.obeo.dsl.traceability.Traceability;
import fr.obeo.dsl.traceability.TraceabilitySnapshot;
import fr.obeo.dsl.traceability.api.ITraceabilityStrategy;
import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.impl.SessionModelDataProvider;
import fr.obeo.perseus.client.impl.SessionModelTranslationScope;
import fr.obeo.perseus.client.impl.graphql.GQLJobResult;
import fr.obeo.perseus.client.impl.jobs.PublicationResultJob;
import fr.obeo.perseus.client.util.ModelURI;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UpdateTraceabilityOnPublicationOutcome
extends JobChangeAdapter {
    private final Shell shell;

    public UpdateTraceabilityOnPublicationOutcome(Shell shell) {
        this.shell = Objects.requireNonNull(shell);
    }

    public void done(IJobChangeEvent event) {
        if (!(event.getJob() instanceof PublicationResultJob)) {
            return;
        }
        PublicationResultJob job = (PublicationResultJob)event.getJob();
        if (event.getResult().isOK()) {
            Display.getDefault().syncExec(() -> this.applyPublicationResult(job));
        }
    }

    protected Shell getUsableShell() {
        Shell shellToUse = this.shell.isDisposed() ? Display.getDefault().getActiveShell() : this.shell;
        return shellToUse;
    }

    private void applyPublicationResult(PublicationResultJob job) {
        GQLJobResult publishJobResult = job.getPublishJobResult();
        ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getUsableShell());
        try {
            dlg.run(false, false, monitor -> {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                Session session = job.getSession();
                if (!session.isOpen()) {
                    session.open((IProgressMonitor)progress.split(80));
                }
                progress.setWorkRemaining(20);
                if (publishJobResult == null) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Publication not Successful", (String)"The publication ended without results.");
                    this.applyPublicationFailure(session);
                } else {
                    switch (publishJobResult.getOutcome()) {
                        case SUCCESS: {
                            MessageDialog.openInformation((Shell)this.getUsableShell(), (String)"Publication Success", (String)publishJobResult.getMessage());
                            this.applyPublicationSuccess(session);
                            break;
                        }
                        case WARNING: {
                            MessageDialog.openWarning((Shell)this.getUsableShell(), (String)"Publication Success with Warnings", (String)String.format("You will be directed to the model's web page in your web browser,\nwhere you can fix the warnings.\n\nWarnings:\n%s", publishJobResult.getMessage()));
                            this.applyPublicationSuccess(session);
                            SessionModelTranslationScope scope = new SessionModelTranslationScope(session);
                            SessionModelDataProvider modelDataProvider = new SessionModelDataProvider(session, scope);
                            this.openWebBrowserOnModelPage(modelDataProvider);
                            break;
                        }
                        case CANCELED: {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Publication Canceled", (String)"Please note that the publication has been canceled, hence the changes have not been taken into account online!");
                            this.applyPublicationFailure(session);
                            break;
                        }
                        case ERROR: {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Publication not Successful", (String)publishJobResult.getMessage());
                            this.applyPublicationFailure(session);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("Unrecognized JobOutcome value: %s", new Object[]{publishJobResult.getOutcome()}));
                        }
                    }
                }
                session.save((IProgressMonitor)progress.split(20));
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            PerseusClientPlugin.getPlugin().logError("Could not apply publication job result", e);
        }
    }

    protected void openWebBrowserOnModelPage(SessionModelDataProvider modelDataProvider) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(modelDataProvider.getPerseusModelURI().get().toURL());
        }
        catch (Exception e) {
            PerseusClientPlugin.getPlugin().logError("Could not open web browser on publish success with warnings.", e);
            MessageDialog.openError((Shell)this.getUsableShell(), (String)"Open Web Browser Error", (String)String.format("Could not open web browser. Please navigate to %s to fix the publication warnings.", modelDataProvider.getPerseusModelURI().map(ModelURI::getURI).map(Object::toString).orElse("the model's web page")));
        }
    }

    protected void applyPublicationSuccess(Session session) {
        ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)session, ITraceabilityStrategy.class);
        traceabilityStrategy.findTraceability().ifPresent(traceability -> session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain(), (Traceability)traceability){
            private final /* synthetic */ Traceability val$traceability;
            {
                this.val$traceability = traceability;
                super($anonymous0);
            }

            protected void doExecute() {
                UpdateTraceabilityOnPublicationOutcome.this.applyPublication(this.val$traceability);
            }
        }));
    }

    protected void applyPublicationFailure(Session session) {
        ITraceabilityStrategy traceabilityStrategy = (ITraceabilityStrategy)Adapters.adapt((Object)session, ITraceabilityStrategy.class);
        traceabilityStrategy.findTraceability().ifPresent(traceability -> session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain(), (Traceability)traceability){
            private final /* synthetic */ Traceability val$traceability;
            {
                this.val$traceability = traceability;
                super($anonymous0);
            }

            protected void doExecute() {
                UpdateTraceabilityOnPublicationOutcome.this.resetPublication(this.val$traceability);
            }
        }));
    }

    protected void applyPublication(Traceability traceability) {
        Optional.ofNullable(traceability.getPendingPublication()).orElseThrow(IllegalStateException::new);
        HashSet repos = new HashSet(traceability.getRepositories());
        for (TraceabilitySnapshot snapshot : traceability.getPendingPublication().getTraceabilitySnapshots()) {
            ArtifactRepository repo = (ArtifactRepository)snapshot.eContainer();
            repo.getSnapshots().clear();
            repo.getSnapshots().add((Object)snapshot);
            repos.remove(repo);
        }
        for (ArtifactRepository repo : repos) {
            repo.getSnapshots().clear();
        }
        traceability.setLatestSynchronizationPoint((SynchronizationPoint)traceability.getPendingPublication());
    }

    protected void resetPublication(Traceability traceability) {
        Optional.ofNullable(traceability.getPendingPublication()).orElseThrow(IllegalStateException::new);
        for (TraceabilitySnapshot snapshot : traceability.getPendingPublication().getTraceabilitySnapshots()) {
            ArtifactRepository repo = (ArtifactRepository)snapshot.eContainer();
            repo.getSnapshots().remove((Object)snapshot);
        }
        traceability.setPendingPublication(null);
    }
}

