/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.commands;

import fr.obeo.dsl.traceability.api.IArtifactRepositoryChangeSet;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryUpdater;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ApplyTraceabilityChangesCommand
extends RecordingCommand {
    private final Instant timestamp;
    private final IArtifactRepositoryChangeSet artifactRepositoryChangeSet;
    private final IArtifactRepositoryStrategy repositoryStrategy;

    public ApplyTraceabilityChangesCommand(TransactionalEditingDomain domain, String label, IArtifactRepositoryStrategy repositoryStrategy, Instant timestamp, IArtifactRepositoryChangeSet artifactRepositoryChangeSet) {
        super(domain, label);
        this.timestamp = Objects.requireNonNull(timestamp);
        this.repositoryStrategy = Objects.requireNonNull(repositoryStrategy);
        this.artifactRepositoryChangeSet = Objects.requireNonNull(artifactRepositoryChangeSet);
    }

    protected void doExecute() {
        IArtifactRepositoryUpdater updater = this.repositoryStrategy.findArtifactRepositoryUpdater().orElseGet(() -> ((IArtifactRepositoryStrategy)this.repositoryStrategy).createArtifactRepositoryUpdater());
        updater.applyChanges(this.artifactRepositoryChangeSet, this.timestamp);
    }
}

