/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.commands;

import fr.obeo.dsl.traceability.api.IArtifactDescriptor;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryUpdater;
import java.util.Objects;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public final class CreateArtifactCommand
extends RecordingCommand {
    private final IArtifactRepositoryStrategy repositoryStrategy;
    private final IArtifactDescriptor artifactDescriptor;

    public CreateArtifactCommand(TransactionalEditingDomain domain, IArtifactRepositoryStrategy repositoryStrategy, IArtifactDescriptor artifactDescriptor) {
        super(domain);
        this.repositoryStrategy = Objects.requireNonNull(repositoryStrategy);
        this.artifactDescriptor = Objects.requireNonNull(artifactDescriptor);
    }

    protected void doExecute() {
        IArtifactRepositoryUpdater repositoryUpdater = this.repositoryStrategy.findArtifactRepositoryUpdater().orElseGet(() -> this.repositoryStrategy.createArtifactRepositoryUpdater());
        this.repositoryStrategy.findArtifact(this.artifactDescriptor.getArtifactURL()).orElseGet(() -> repositoryUpdater.createArtifact(this.artifactDescriptor));
    }
}

