/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.commands;

import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.LinkDirection;
import fr.obeo.dsl.traceability.LinkType;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryStrategy;
import fr.obeo.dsl.traceability.api.IArtifactRepositoryUpdater;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public final class CreateLinkCommand
extends RecordingCommand {
    private final IArtifactRepositoryStrategy repositoryStrategy;
    private final EObject modelObject;
    private final String artifactUrl;
    private final LinkType linkType;

    public CreateLinkCommand(TransactionalEditingDomain domain, IArtifactRepositoryStrategy repositoryStrategy, String artifactUrl, LinkType linkType, EObject modelObject) {
        super(domain);
        this.repositoryStrategy = Objects.requireNonNull(repositoryStrategy);
        this.artifactUrl = Objects.requireNonNull(artifactUrl);
        this.linkType = Objects.requireNonNull(linkType);
        this.modelObject = Objects.requireNonNull(modelObject);
    }

    protected void doExecute() {
        IArtifactRepositoryUpdater repositoryUpdater = (IArtifactRepositoryUpdater)this.repositoryStrategy.findArtifactRepositoryUpdater().orElseThrow(IllegalStateException::new);
        IArtifact artifact = (IArtifact)this.repositoryStrategy.findArtifact(this.artifactUrl).orElseThrow(IllegalStateException::new);
        repositoryUpdater.createLink(this.modelObject, this.linkType, LinkDirection.MODEL_TO_ARTIFACT, artifact);
    }
}

