/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.commands;

import fr.obeo.dsl.traceability.ArtifactRepository;
import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.ILink;
import fr.obeo.perseus.client.Messages;
import fr.obeo.perseus.client.PerseusClientPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class FixRepresentationLinksCommand
extends RecordingCommand {
    private final List<ArtifactRepository> repositories;
    private List<String> fixedLinkDescriptions = new ArrayList<String>();

    public FixRepresentationLinksCommand(TransactionalEditingDomain domain, List<ArtifactRepository> repositories) {
        super(domain);
        this.repositories = repositories;
    }

    public boolean canUndo() {
        return false;
    }

    protected void doExecute() {
        this.repositories.stream().filter(repository -> repository.getStore() != null).forEach(repository -> {
            for (IArtifact artifact : repository.getStore().getOwnedArtifacts()) {
                ArrayList artifactLinks = new ArrayList(artifact.getOwnedLinks());
                for (ILink link : artifactLinks) {
                    if (!(link.getModelObject() instanceof DRepresentation)) continue;
                    DRepresentation representation = (DRepresentation)link.getModelObject();
                    String linkDescription = String.format(Messages.FetchHandler_FixedRepresentationLinkDescription, link.getType().getName(), representation.getName(), artifact.getUrl());
                    DRepresentationDescriptor representationDescriptor = new DRepresentationQuery(representation).getRepresentationDescriptor();
                    if (representationDescriptor != null) {
                        boolean exists = artifact.getOwnedLinks().stream().filter(existing -> existing.getType().equals(link.getType()) && representationDescriptor.equals(existing.getModelObject())).findAny().isPresent();
                        if (exists) {
                            EcoreUtil.remove((EObject)link);
                            PerseusClientPlugin.getPlugin().log(new Status(1, "fr.obeo.perseus.client", String.format(Messages.FetchHandler_FixedRepresentationLinksLogRemove, linkDescription)));
                        } else {
                            link.setModelObject((EObject)representationDescriptor);
                        }
                        this.fixedLinkDescriptions.add(linkDescription);
                        PerseusClientPlugin.getPlugin().log(new Status(1, "fr.obeo.perseus.client", String.format(Messages.FetchHandler_FixedRepresentationLinksLog, linkDescription)));
                        continue;
                    }
                    PerseusClientPlugin.getPlugin().log(String.format(Messages.FetchHandler_OrphanRepresentationLink, linkDescription));
                }
            }
        });
    }

    public List<String> getFixedLinkDescriptions() {
        return this.fixedLinkDescriptions;
    }
}

