/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.ecore;

import fr.obeo.perseus.client.dto.PName;
import fr.obeo.perseus.client.dto.RefName;
import fr.obeo.perseus.client.dto.digest.MetamodelDigest;
import fr.obeo.perseus.client.dto.meta.MAttributeDTO;
import fr.obeo.perseus.client.dto.meta.MDataTypeDTO;
import fr.obeo.perseus.client.dto.meta.MEnumDTO;
import fr.obeo.perseus.client.dto.meta.MEnumLiteralDTO;
import fr.obeo.perseus.client.dto.meta.MReferenceDTO;
import fr.obeo.perseus.client.dto.meta.MetaclassDTO;
import fr.obeo.perseus.client.dto.meta.MetamodelDTO;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

public class EPackageToMetamodel {
    private static final String DESC_DETAILS = "description";
    private static final String DOC_SRC = "documentation";
    private final EPackage pack;
    private final Set<EPackage> dependencies;

    public EPackageToMetamodel(EPackage pack, Set<EPackage> dependencies) {
        this.pack = pack;
        this.dependencies = dependencies;
    }

    public MetamodelDTO convert() {
        MetamodelDTO mm = new MetamodelDTO();
        mm.setName(this.getName(this.pack));
        mm.setUri(this.getNsURI(this.pack));
        mm.setNsPrefix(this.getNsPrefix(this.pack));
        for (EClassifier classifier : this.pack.getEClassifiers()) {
            if (classifier instanceof EClass) {
                EClass c = (EClass)classifier;
                MetaclassDTO metaclass = new MetaclassDTO();
                metaclass.setAbstract(c.isAbstract());
                metaclass.setInterface(c.isInterface());
                this.getDescriptionFromAnnotations((EModelElement)c).ifPresent(metaclass::setDescription);
                mm.getClassifiers().put(this.getName((EClassifier)c), metaclass);
                for (EClass superClass : c.getESuperTypes()) {
                    metaclass.getSuperClasses().add(PName.of(this.getNsPrefix(superClass.getEPackage()), this.getName((EClassifier)superClass)));
                    this.dependencies.add(superClass.getEPackage());
                }
                for (EAttribute att : c.getEAttributes()) {
                    this.convertAttribute(att, metaclass);
                }
                for (EReference ref : c.getEReferences()) {
                    this.convertReference(ref, metaclass);
                }
                continue;
            }
            if (classifier instanceof EEnum) {
                EEnum eEnum = (EEnum)classifier;
                this.convertEnum(eEnum, mm);
                continue;
            }
            if (!(classifier instanceof EDataType)) continue;
            EDataType dataType = (EDataType)classifier;
            this.convertDataType(dataType, mm);
        }
        MetamodelDigest md = new MetamodelDigest(this.dependencies.stream().collect(Collectors.toMap(p -> this.getNsPrefix((EPackage)p), p -> this.getNsURI((EPackage)p))));
        md.init();
        mm.accept(md);
        mm.setHash(md.getHash());
        return mm;
    }

    private void convertDataType(EDataType dataType, MetamodelDTO mm) {
        MDataTypeDTO dt = new MDataTypeDTO();
        this.getDescriptionFromAnnotations((EModelElement)dataType).ifPresent(dt::setDescription);
        dt.setSerializable(dataType.isSerializable());
        mm.getClassifiers().put(this.getName((EClassifier)dataType), dt);
    }

    private void convertEnum(EEnum eEnum, MetamodelDTO mm) {
        MEnumDTO mEnum = new MEnumDTO();
        this.getDescriptionFromAnnotations((EModelElement)eEnum).ifPresent(mEnum::setDescription);
        mEnum.setSerializable(eEnum.isSerializable());
        mEnum.setLiterals(new ArrayList<MEnumLiteralDTO>(eEnum.getELiterals().size()));
        for (EEnumLiteral elit : eEnum.getELiterals()) {
            MEnumLiteralDTO lit = new MEnumLiteralDTO();
            lit.setLiteral(elit.getLiteral());
            lit.setValue(elit.getValue());
            mEnum.getLiterals().add(lit);
        }
        mm.getClassifiers().put(this.getName((EClassifier)eEnum), mEnum);
    }

    private void convertReference(EReference eRef, MetaclassDTO metaclass) {
        MReferenceDTO ref = new MReferenceDTO();
        ref.setContainer(eRef.isContainer());
        ref.setContainment(eRef.isContainment());
        ref.setDerived(eRef.isDerived());
        this.getDescriptionFromAnnotations((EModelElement)eRef).ifPresent(ref::setDescription);
        ref.setLowerBound(eRef.getLowerBound());
        ref.setMany(eRef.isMany());
        ref.setOrdered(eRef.isOrdered());
        ref.setRequired(eRef.isRequired());
        this.dependencies.add(eRef.getEReferenceType().getEPackage());
        ref.setType(this.getType((EClassifier)eRef.getEReferenceType()));
        ref.setUnique(eRef.isUnique());
        ref.setUpperBound(eRef.getUpperBound());
        if (eRef.getEOpposite() != null) {
            ref.setOpposite(this.getRefName(eRef.getEOpposite()));
        }
        metaclass.getStructuralFeatures().put(eRef.getName(), ref);
    }

    private void convertAttribute(EAttribute att, MetaclassDTO metaclass) {
        MAttributeDTO prop = new MAttributeDTO();
        prop.setDerived(att.isDerived());
        this.getDescriptionFromAnnotations((EModelElement)att).ifPresent(prop::setDescription);
        prop.setLowerBound(att.getLowerBound());
        prop.setMany(att.isMany());
        prop.setOrdered(att.isOrdered());
        prop.setRequired(att.isRequired());
        this.dependencies.add(att.getEAttributeType().getEPackage());
        prop.setType(this.getType((EClassifier)att.getEAttributeType()));
        prop.setUnique(att.isUnique());
        prop.setUpperBound(att.getUpperBound());
        metaclass.getStructuralFeatures().put(att.getName(), prop);
    }

    private RefName getRefName(EReference ref) {
        return RefName.of(this.getNsPrefix(ref.getEContainingClass().getEPackage()), this.getName((EClassifier)ref.getEContainingClass()), ref.getName());
    }

    private Optional<String> getDescriptionFromAnnotations(EModelElement c) {
        EList annotations = c.getEAnnotations();
        String result = null;
        for (EAnnotation annot : annotations) {
            if (annot.getSource().contains(DOC_SRC) && annot.getDetails().containsKey((Object)DESC_DETAILS)) {
                result = (String)annot.getDetails().get((Object)DESC_DETAILS);
                continue;
            }
            if (!"http://www.eclipse.org/emf/2002/GenModel".equals(annot.getSource()) || !annot.getDetails().containsKey((Object)DOC_SRC)) continue;
            result = (String)annot.getDetails().get((Object)DOC_SRC);
        }
        return Optional.ofNullable(result);
    }

    private String getName(EClassifier c) {
        return c.getName();
    }

    private PName getType(EClassifier c) {
        return PName.of(this.getNsPrefix(c.getEPackage()), c.getName());
    }

    private String getNsPrefix(EPackage p) {
        return p.getNsPrefix();
    }

    private String getNsURI(EPackage p) {
        return p.getNsURI();
    }

    private String getName(EPackage p) {
        return p.getName();
    }
}

