/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.graphql;

import fr.obeo.dsl.traceability.IArtifact;
import fr.obeo.dsl.traceability.api.IArtifactDescriptor;
import fr.obeo.dsl.traceability.api.ITypeDescriptor;
import fr.obeo.perseus.client.impl.graphql.GQLTypeDescriptor;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class GQLOslcArtifactDescriptor
implements IArtifactDescriptor {
    private String artifactUrl;
    private String title;
    private String id;
    private String sourceUrl;
    private List<GQLTypeDescriptor> types;

    public final String getArtifactUrl() {
        return this.artifactUrl;
    }

    public final void setArtifactUrl(String artifactUrl) {
        this.artifactUrl = artifactUrl;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final String getSourceUrl() {
        return this.sourceUrl;
    }

    public final void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public final List<GQLTypeDescriptor> getTypes() {
        return this.types;
    }

    public final void setTypes(List<GQLTypeDescriptor> types) {
        this.types = types;
    }

    public String getArtifactURL() {
        return this.artifactUrl;
    }

    public Optional<String> getSourceURL() {
        return Optional.ofNullable(this.sourceUrl);
    }

    public List<? extends ITypeDescriptor> getTypeDescriptors() {
        return this.getTypes();
    }

    public static GQLOslcArtifactDescriptor createFromArtifact(IArtifact art) {
        GQLOslcArtifactDescriptor oa = new GQLOslcArtifactDescriptor();
        oa.setArtifactUrl(art.getUrl());
        oa.setTitle(art.getTitle());
        oa.setId(art.getIdentifier());
        oa.setTypes(art.getTypes().stream().map(at -> {
            GQLTypeDescriptor type = new GQLTypeDescriptor();
            type.setUri(at.getUri());
            type.setLabel(at.getName());
            return type;
        }).collect(Collectors.toList()));
        return oa;
    }
}

