/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.graphql;

import fr.obeo.perseus.client.impl.graphql.ProjectFilter;
import fr.obeo.perseus.client.impl.graphql.StringFilterOperation;
import fr.obeo.perseus.client.impl.project.SearchPageMode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class QueryAvailableProjects {
    private static final String QUERY_AVAILABLE_PROJECTS = "query($after: String, $before: String, $filter: ProjectFilter) {\n  viewer {\n    projects (after: $after, before: $before, filter: $filter) {\n      edges {\n        node {\n          id\n          name\n          accessLevel\n          isPrivate\n        }\n      }\n      pageInfo {\n        count\n        endCursor\n        hasNextPage\n        hasPreviousPage\n        startCursor\n      }\n    }\n  }\n}";
    private final Map<String, Object> variables = new LinkedHashMap<String, Object>();

    private QueryAvailableProjects() {
    }

    public String getQuery() {
        return QUERY_AVAILABLE_PROJECTS;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public static QueryAvailableProjectsBuilder newQuery() {
        return new QueryAvailableProjectsBuilder();
    }

    /* synthetic */ QueryAvailableProjects(QueryAvailableProjects queryAvailableProjects) {
        this();
    }

    public static class QueryAvailableProjectsBuilder {
        private ProjectFilter filter;
        private SearchPageMode pageMode;
        private String projectId;

        public QueryAvailableProjectsBuilder withProjectNameContains(String projectNameContains) {
            this.filter = new ProjectFilter(new StringFilterOperation(projectNameContains));
            return this;
        }

        public QueryAvailableProjectsBuilder withPage(SearchPageMode aPageMode, String aProjectId) {
            this.pageMode = Objects.requireNonNull(aPageMode);
            this.projectId = Objects.requireNonNull(aProjectId);
            return this;
        }

        public QueryAvailableProjects build() {
            QueryAvailableProjects result = new QueryAvailableProjects(null);
            if (this.filter != null) {
                result.variables.put("filter", this.filter);
            }
            if (this.pageMode != null) {
                result.variables.put(this.pageMode.name(), this.projectId);
            }
            return result;
        }
    }
}

