/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.jobs;

import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.IPublicationResultJobRegistry;
import fr.obeo.perseus.client.impl.UpdateTraceabilityOnPublicationOutcome;
import fr.obeo.perseus.client.impl.jobs.PublicationResultJob;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PublicationJobRegistry
implements IPublicationResultJobRegistry {
    private final IJobManager jobManager;

    public PublicationJobRegistry() {
        this(Job.getJobManager());
    }

    public PublicationJobRegistry(IJobManager jobManager) {
        this.jobManager = jobManager;
    }

    @Override
    public boolean hasPublicationResultJob(String publicationJobId) {
        Job[] publishJobs = this.jobManager.find((Object)"PublicationResultJob_Family");
        return Stream.of(publishJobs).filter(PublicationResultJob.class::isInstance).map(PublicationResultJob.class::cast).anyMatch(j -> publicationJobId.equals(j.getPublicationJobId()));
    }

    @Override
    public Optional<PublicationResultJob> trySchedulingPublicationResultJob(Session session, IPerseusServerConfig serverConfig, String modelName, String publicationJobId, Shell shell) {
        PublicationResultJob result = null;
        if (!this.hasPublicationResultJob(publicationJobId)) {
            PublicationResultJob resultJob = new PublicationResultJob(session, serverConfig, modelName, publicationJobId);
            Display.getDefault().syncExec(() -> {
                UpdateTraceabilityOnPublicationOutcome listener = new UpdateTraceabilityOnPublicationOutcome(shell);
                resultJob.addJobChangeListener((IJobChangeListener)listener);
                PlatformUI.getWorkbench().getProgressService().showInDialog(Display.getDefault().getActiveShell(), (Job)resultJob);
                resultJob.schedule();
            });
            result = resultJob;
        }
        return Optional.ofNullable(result);
    }
}

