/*
 * Decompiled with CFR 0.152.
 */
package fr.obeo.perseus.client.impl.jobs;

import fr.obeo.perseus.client.PerseusClientPlugin;
import fr.obeo.perseus.client.api.IPerseusServerConfig;
import fr.obeo.perseus.client.api.PerseusServerException;
import fr.obeo.perseus.client.dto.jobs.JobStatus;
import fr.obeo.perseus.client.impl.graphql.GQLJob;
import fr.obeo.perseus.client.impl.graphql.GQLJobResult;
import fr.obeo.perseus.client.util.PerseusProperties;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sirius.business.api.session.Session;

public class PublicationResultJob
extends Job {
    public static final String FAMILY = "PublicationResultJob_Family";
    private final IPerseusServerConfig config;
    private final Session session;
    private final String publicationJobId;
    private GQLJobResult publishJobResult;

    public PublicationResultJob(Session session, IPerseusServerConfig perseusServerConfig, String modelName, String publicationJobId) {
        super(String.format("[%s] Awaiting Publication result", modelName));
        this.session = Objects.requireNonNull(session);
        this.config = Objects.requireNonNull(perseusServerConfig);
        this.publicationJobId = Objects.requireNonNull(publicationJobId);
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        JobStatus jobStatus = null;
        IStatus status = Status.OK_STATUS;
        while (!JobStatus.DONE.equals((Object)jobStatus)) {
            try {
                GQLJob publishJob = this.fetch((IProgressMonitor)progress.split(2));
                jobStatus = publishJob.getStatus();
                if (!JobStatus.DONE.equals((Object)jobStatus)) {
                    progress.setWorkRemaining(10);
                    Thread.sleep(PerseusProperties.getPublishResultFetchIntervalMs());
                    continue;
                }
                this.publishJobResult = publishJob.getResult();
            }
            catch (InterruptedException | OperationCanceledException e) {
                status = Status.CANCEL_STATUS;
                break;
            }
            catch (PerseusServerException | IOException e) {
                status = new Status(4, "fr.obeo.perseus.client", e.getMessage(), (Throwable)e);
                break;
            }
        }
        return status;
    }

    public boolean belongsTo(Object family) {
        return family == FAMILY;
    }

    public GQLJobResult getPublishJobResult() {
        return this.publishJobResult;
    }

    public IPerseusServerConfig getConfig() {
        return this.config;
    }

    public Session getSession() {
        return this.session;
    }

    public String getPublicationJobId() {
        return this.publicationJobId;
    }

    private GQLJob fetch(IProgressMonitor monitor) throws IOException, PerseusServerException {
        return PerseusClientPlugin.getPlugin().getPerseusDataFetcher().getJob(this.config, Long.valueOf(this.publicationJobId), monitor);
    }
}

